<?php
if ( ! function_exists( 'wpj_get_chatbox_uid_by_user_type' ) ) {
	function wpj_get_chatbox_uid_by_user_type( $user_type = '' ) {
		if ( $user_type == 'buyer' ) {
			$buyer = [-1, -8, -12, -13, -16, -19, -22, -31, -32, -39, -41, -43, -45, -47, -48, -49, -50];

			return apply_filters( 'wpj_chatbox_buyer_uid_filter', $buyer );

		} elseif ( $user_type == 'seller' ) {
			$seller = [0, -2, -9, -10, -11, -14, -15, -17, -18, -21, -33, -34, -35, -37, -40, -42, -44, -46, -51, -52];

			return apply_filters( 'wpj_chatbox_seller_uid_filter', $seller );
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_chatbox_hidden_notifications_uid' ) ) {
	function wpj_get_chatbox_hidden_notifications_uid() {
		return apply_filters( 'wpj_chatbox_hidden_notifications_uid_filter', [-32, -33, -34, -37, -38, -47, -48] );
	}
}

if ( ! function_exists( 'wpj_get_order_notifications_data' ) ) {
	function wpj_get_order_notifications_data( $row ) {
		if ( $row ) {
			$order = wpj_get_job_order_by_id( $row->oid );

			$uid         = get_current_user_id();

			$seller_id   = get_post_field( 'post_author', $order->pid );
			$seller_data = get_userdata( $seller_id );
			$seller_name = is_object( $seller_data ) ? wpj_get_user_display_type( $seller_id ) : __( 'Deleted User', 'wpjobster' );

			$buyer_id    = $order->uid;
			$buyer_data  = get_userdata( $buyer_id );
			$buyer_name  = is_object( $buyer_data ) ? wpj_get_user_display_type( $buyer_id ) : __( 'Deleted User', 'wpjobster' );

			$tips = wpj_json_decode( wpj_stripslashes( $order->tips ) );
			$tip  = ! empty( $tips[$row->content] ) ? $tips[$row->content] : '';

			$image_accepted     = get_template_directory_uri() . '/assets/images/notification/svg/accepted-white.svg';
			$image_declined     = get_template_directory_uri() . '/assets/images/notification/svg/declined-white.svg';
			$image_declined2    = get_template_directory_uri() . '/assets/images/notification/svg/declined-white-2.svg';
			$image_delivered    = get_template_directory_uri() . '/assets/images/notification/svg/accepted-white.svg';
			$image_modification = get_template_directory_uri() . '/assets/images/notification/svg/modification-white.svg';
			$image_tips         = get_template_directory_uri() . '/assets/images/notification/svg/tips-white.svg';
			$image_arb_request  = get_template_directory_uri() . '/assets/images/notification/svg/arbitration-request-white.svg';
			$image_arb_response = get_template_directory_uri() . '/assets/images/notification/svg/arbitration-request-white.svg';
			$image_star         = get_template_directory_uri() . '/assets/images/notification/svg/star-white.svg';
			$custom_extra       = get_template_directory_uri() . '/assets/images/notification/svg/custom-extra-white.svg';
			$image_admin_action = get_template_directory_uri() . '/assets/images/notification/svg/admin-white.svg';

			$icon     = get_template_directory_uri() . '/assets/images/notification/svg/accepted-white.svg';
			$iconsize = 50;
			$bgcolor  = "blue";
			$message  = '';

			if ( $row->uid > 0 ) {

				$icon     = wpj_get_avatar( $row->uid, 61, 61 );
				$iconsize = 60;
				$bgcolor  = "gray";

				$filtered_message = $row->content;

				if ( ! str_contains( $filtered_message, sprintf( 'pwd=%d%d', $buyer_id, $seller_id ) ) ) { /* zoom link */
					$filtered_message = wpj_apply_filter_to_string( $filtered_message, true, 'transactionpages' );
				}

				$message = nl2br( wpj_stripslashes( strip_tags( htmlspecialchars_decode( $filtered_message ) ) ) );

			} else {

				if ( $row->uid == -1 ) { // marked as delivered

					$icon     = $image_delivered;
					$iconsize = 50;
					$bgcolor  = "green";

					if ( $uid == $seller_id ) {
						$message = __( 'You have marked this order as delivered.', 'wpjobster' );
					} else {
						$message = __( 'The order has been marked as delivered by the seller.', 'wpjobster' );
						if ( wpj_is_order_completed( $order->id ) != 1 )
							$message .= '<br/>' . __( 'Please confirm using the button below.', 'wpjobster' );
					}
				}

				if ( $row->uid == -2 ) { // marked as completed

					$icon     = $image_accepted;
					$iconsize = 50;
					$bgcolor  = "green";

					if ( $uid == $seller_id ) {
						$message = __( 'The order has been marked as completed by the buyer.', 'wpjobster' );
					} else {
						$message = __( 'You have marked this order as completed.', 'wpjobster' );

						$awarded = wpj_get_job_rating( 'awarded', ['orderid' => $order->id], 'var' );

						if ( $awarded != 1 )
							$message .= '<br/>' . __( 'Please review it using the form below.', 'wpjobster' );
					}
				}

				if ( $row->uid == -8 ) { // the seller requested cancellation

					$icon     = $image_declined;
					$iconsize = 50;
					$bgcolor  = "red";

					if ( $uid == $seller_id) {
						$message = __( 'You have requested a mutual cancellation for this order.', 'wpjobster' );
					} else {
						$message = __( 'The seller of this job has requested a mutual cancellation for this order.', 'wpjobster' );
					}

					$filtered_message = $row->content;
					$filtered_message = wpj_apply_filter_to_string( $filtered_message, true, 'transactionpages' );

					$message .= '<br>' . __( 'Cancellation Message:', 'wpjobster' ) . ' "' . $filtered_message . '"';

				}

				if ( $row->uid == -9 ) { // the buyer requested cancellation

					$icon     = $image_declined;
					$iconsize = 50;
					$bgcolor  = "red";

					if ( $uid == $seller_id) {
						$message = __( 'The buyer has requested a mutual cancellation for this order.', 'wpjobster' );
					} else {
						$message = __( 'You have requested a mutual cancellation for this order.', 'wpjobster' );
					}

					$filtered_message = $row->content;
					$filtered_message = wpj_apply_filter_to_string( $filtered_message, true, 'transactionpages' );

					$message .= '<br>' . __( 'Cancellation Message:', 'wpjobster' ) . ' "' . $filtered_message . '"';

				}

				if ( $row->uid == -10 ) { // the buyer accepted mutual cancellation

					$icon     = $image_accepted;
					$iconsize = 50;
					$bgcolor  = "green";

					if ( $uid == $seller_id) {
						$message = __( 'The buyer has accepted the mutual cancellation for this order.', 'wpjobster' );
					} else {
						$message = __( 'You have accepted the mutual cancellation for this order.', 'wpjobster' );
					}
				}

				if ( $row->uid == -11 ) { // the buyer declined mutual cancellation

					$icon     = $image_declined2;
					$iconsize = 50;
					$bgcolor  = "red";

					if ( $uid == $seller_id) {
						$message = __( 'The buyer has declined the mutual cancellation for this order.', 'wpjobster' );
					} else {
						$message = __( 'You have declined the mutual cancellation for this order.', 'wpjobster' );
					}
				}

				if ( $row->uid == -12 ) { // the seller accepted mutual cancellation

					$icon     = $image_accepted;
					$iconsize = 50;
					$bgcolor  = "green";

					if ( $uid == $seller_id) {
						$message = __( 'You have accepted the mutual cancellation for this order.', 'wpjobster' );
					} else {
						$message = __( 'The seller has accepted the mutual cancellation for this order.', 'wpjobster' );
					}
				}

				if ( $row->uid == -13 ) { // the seller declined mutual cancellation

					$icon     = $image_declined2;
					$iconsize = 50;
					$bgcolor  = "red";

					if ( $uid == $seller_id) {
						$message = __( 'You have declined the mutual cancellation for this order.', 'wpjobster' );
					} else {
						$message = __( 'The seller has declined the mutual cancellation for this order.', 'wpjobster' );
					}
				}

				if ( $row->uid == -14 ) { // transaction was cancelled by admin

					$icon     = $image_admin_action;
					$iconsize = 50;
					$bgcolor  = "red";

					$message = __( 'Transaction has been cancelled by the admin based on the requested arbitrage.', 'wpjobster' );
				}

				if ( $row->uid == -15 ) { // buyer request modification

					$icon     = $image_modification;
					$iconsize = 50;
					$bgcolor  = "orange";

					if ( $uid == $seller_id) {
						$message = __( 'The buyer has requested a modification for this order.', 'wpjobster' );
					} else {
						$message = __( 'You have requested a modification for this order.', 'wpjobster' );
					}

					$filtered_message = $row->content;
					$filtered_message = wpj_apply_filter_to_string( $filtered_message, true, 'transactionpages' );

					$message .= '<br>' . __( 'Modification Message:', 'wpjobster' ) . ' "' . $filtered_message . '"';

				}

				if ( $row->uid == -16 ) { // mutual cancellation was aborted by seller

					$icon     = $image_declined2;
					$iconsize = 50;
					$bgcolor  = "red";

					if ( $uid == $seller_id) {
						$message = __( 'You have aborted the mutual cancellation for this order.', 'wpjobster' );
					} else {
						$message = __( 'The seller has aborted the mutual cancellation for this order.', 'wpjobster' );
					}
				}

				if ( $row->uid == -17 ) { // mutual cancellation was aborted by buyer

					$icon     = $image_declined2;
					$iconsize = 50;
					$bgcolor  = "red";

					if ( $uid == $seller_id) {
						$message = __( 'The buyer has aborted the mutual cancellation for this order.', 'wpjobster' );
					} else {
						$message = __( 'You have aborted the mutual cancellation for this order.', 'wpjobster' );
					}
				}

				if ( $row->uid == -18 ) { // buyer rating

					$reason = wpj_get_job_rating( 'reason', ['orderid' => $order->id], 'var' );

					if ( $reason ) {

						$icon     = $image_star;
						$iconsize = 50;
						$bgcolor  = "orange";

						if ( $uid == $seller_id ) {
							$message .= __( 'The buyer has rated this order.', 'wpjobster' ) . '<br>';
						} else {
							$message .= __( 'You have rated this order.', 'wpjobster' ) . '<br>';
						}

						$filtered_message = str_replace( '\n', '<br>', $reason );
						$filtered_message = wpj_apply_filter_to_string( $filtered_message, false, 'transactionpages' );

						if ( $filtered_message ) {
							$message .= '<br>' . sprintf( __( "Feedback Message: %s", "wpjobster" ), wpj_stripslashes( wpj_stripslashes( $filtered_message ) ) );
						}

					}
				}

				if ( $row->uid == -19 ) { // seller rating

					$rating_row = wpj_get_job_seller_rating( 'grade, reason', ['orderid' => $order->id], 'row' );

					if ( $rating_row ) {
						$icon     = $image_star;
						$iconsize = 50;
						$bgcolor  = "orange";

						ob_start();
						wpj_display_rating_stars( $rating_row->grade );
						$message = ob_get_contents();
						ob_end_clean();

						if ( $uid == $seller_id) {
							$message .= __( 'You have replied to buyer\'s feedback.', 'wpjobster' ) . '<br>';
						} else {
							$message .= __( 'Seller replied to your feedback.', 'wpjobster' ) . '<br>';
						}

						$filtered_message = str_replace( '\n', '<br>', $rating_row->reason );
						$filtered_message = wpj_apply_filter_to_string( $filtered_message, false, 'transactionpages' );

						if ( $filtered_message ) {

							if ( $uid == $seller_id) {
								$message .= '<br>' . sprintf( __( "Your response: %s", "wpjobster" ), wpj_stripslashes( wpj_stripslashes( $filtered_message ) ) );
							} else {
								$message .= '<br>' . sprintf( __( "Seller’s response: %s", "wpjobster" ), wpj_stripslashes( wpj_stripslashes( $filtered_message ) ) );
							}

						}

					}
				}

				if ( $row->uid == -31 ) { // custom extra

					$icon     = $custom_extra;
					$iconsize = 50;
					$bgcolor  = "green";
					$message  = apply_filters( 'wpj_custom_extra_title_string_filter', __( 'Custom extra', 'wpjobster' ) );
				}

				if ( $row->uid == -35 ) { // order cancellation by buyer( delivery time expired );

					$icon     = $image_declined;
					$iconsize = 50;
					$bgcolor  = "red";

					if ( $uid == $seller_id) {
						$message = __( 'The buyer has cancelled the transaction.', 'wpjobster' );
					} else {
						$message = __( 'You cancelled this transaction.', 'wpjobster' );
					}
				}

				if ( $row->uid == -36 && ( $uid != $seller_id || ! empty( $tip->paid ) ) ) { // new tips

					$icon     = $image_tips;
					$iconsize = 75;
					$bgcolor  = "green";
					$message  = __( 'Tips', 'wpjobster' );
				}

			}

			if ( $row->uid == -21 ) { // pending order cancelled by seller

				$icon     = $image_declined2;
				$iconsize = 50;
				$bgcolor  = "red";

				if ( $uid == $seller_id) {
					$message = __( 'You have aborted the mutual cancellation for this order.', 'wpjobster' );
				} else {
					$message = __( 'The buyer has aborted the mutual cancellation for this order.', 'wpjobster' );
				}
			}

			if ( $row->uid == -39 ) { // the seller requested arbitration

				$icon     = $image_arb_request;
				$iconsize = 50;
				$bgcolor  = "green";

				if ( $uid == $seller_id ) {
					$message = __( 'You have requested arbitration for this order.', 'wpjobster' );
				} else {
					$message = __( 'The seller has requested arbitration for this order.', 'wpjobster' );
				}

				$filtered_message = $row->content;
				$filtered_message = wpj_apply_filter_to_string( $filtered_message, true, 'transactionpages' );

				$message .= '<br>' . __( 'Message to support:', 'wpjobster' ) . ' "' . $filtered_message . '"';
			}

			if ( $row->uid == -40 ) { // the buyer requested arbitration

				$icon     = $image_arb_request;
				$iconsize = 50;
				$bgcolor  = "green";

				if ( $uid == $seller_id ) {
					$message = __( 'The buyer has requested arbitration for this order.', 'wpjobster' );
				} else {
					$message = __( 'You have requested arbitration for this order.', 'wpjobster' );
				}


				$filtered_message = $row->content;
				$filtered_message = wpj_apply_filter_to_string( $filtered_message, true, 'transactionpages' );

				$message .= '<br>' . __( 'Message to support:', 'wpjobster' ) . ' "' . $filtered_message . '"';
			}

			if ( $row->uid == -41 || $row->uid == -42 || $row->uid == -43 || $row->uid == -44 ) { // arbitration response

				$icon     = $image_arb_response;
				$iconsize = 50;
				$bgcolor  = "green";

				if ( $row->uid == -41 && $uid == $seller_id ) {

					$message = __( 'Arbitration was decided in your favor.', 'wpjobster' );

				} elseif ( $row->uid == -42 && ( $uid == $buyer_id || ( is_super_admin() && $uid != $seller_id ) ) ) {

					$message = sprintf( __( 'Arbitration was decided in favor of %s.', 'wpjobster' ), $seller_name );
					$message .= '<br>' . sprintf( __( '%s should proceed with delivering the order.', 'wpjobster' ), $seller_name );

				} elseif ( $row->uid == -43 && ( $uid == $seller_id || ( is_super_admin() && $uid != $buyer_id ) ) ) {

					$message = sprintf( __( 'Arbitration was decided in favor of %s', 'wpjobster' ), $buyer_name );
					$message .= '<br>' . sprintf( __( 'This order has been cancelled and %s has been refunded.', 'wpjobster' ), $buyer_name );

				} elseif ( $row->uid == -44 && $uid == $buyer_id ) {

					$message = __( 'Arbitration was decided in your favor. This transaction has been cancelled, and you have been refunded.', 'wpjobster' );

				}

				if ( $message ) {
					$filtered_message = $row->content;
					$filtered_message = wpj_apply_filter_to_string( $filtered_message, true, 'transactionpages' );

					$message .= '<br>' . __( 'Message from support:', 'wpjobster' ) . ' "' . $filtered_message . '"';
				}
			}

			if ( $row->uid == -45 ) { // the seller aborted arbitration

				$icon     = $image_declined2;
				$iconsize = 50;
				$bgcolor  = "red";

				if ( $uid == $seller_id ) {
					$message = __( 'You have aborted the arbitration for this order.', 'wpjobster' );
				} else {
					$message = __( 'The seller has aborted the arbitration for this order.', 'wpjobster' );
				}
			}

			if ( $row->uid == -46 ) { // the buyer aborted arbitration

				$icon     = $image_declined2;
				$iconsize = 50;
				$bgcolor  = "red";

				if ( $uid == $seller_id ) {
					$message = __( 'The buyer has aborted the arbitration for this order.', 'wpjobster' );
				} else {
					$message = __( 'You have aborted the arbitration for this order.', 'wpjobster' );
				}
			}

			if ( $row->uid == -49 ) { // the seller requested extended delivery time

				$icon     = $image_modification;
				$iconsize = 50;
				$bgcolor  = "orange";

				if ( $uid == $seller_id ) {
					$message = __( 'You have requested an extension of the delivery time for this order.', 'wpjobster' );
				} else {
					$message = __( 'The seller has requested an extension of the delivery time for this order.', 'wpjobster' );
				}

				$filtered_message = $row->content;
				$filtered_message = wpj_apply_filter_to_string( $filtered_message, true, 'transactionpages' );

				if ( $filtered_message ) {
					$message .= '<br>' . __( 'Message:', 'wpjobster' ) . ' "' . $filtered_message . '"';
				}

				$required_days = wpj_get_extended_delivery_order( 'days', ['order_id' => $row->oid, 'message' => $row->content, 'date_request' => $row->datemade], 'var' );

				$message .= '<br>' . sprintf( __( 'Required number of days: %d', 'wpjobster' ), $required_days );
			}

			if ( $row->uid == -50 ) { // the seller aborted extended delivery time

				$icon     = $image_declined2;
				$iconsize = 50;
				$bgcolor  = "red";

				if ( $uid == $seller_id ) {
					$message = __( 'You have aborted the extension of the delivery time for this order.', 'wpjobster' );
				} else {
					$message = __( 'The seller has aborted the extension of the delivery time for this order.', 'wpjobster' );
				}
			}

			if ( $row->uid == -51 ) { // the buyer accepted extended delivery time

				$icon     = $image_accepted;
				$iconsize = 50;
				$bgcolor  = "green";

				if ( $uid == $seller_id ) {
					$message = __( 'The buyer has accepted the extension of the delivery time for this order.', 'wpjobster' );
				} else {
					$message = __( 'You have accepted the extension of the delivery time for this order.', 'wpjobster' );
				}
			}

			if ( $row->uid == -52 ) { // the buyer declined extended delivery time

				$icon     = $image_declined2;
				$iconsize = 50;
				$bgcolor  = "red";

				if ( $uid == $seller_id ) {
					$message = __( 'The buyer has declined the extension of the delivery time for this order.', 'wpjobster' );
				} else {
					$message = __( 'You have declined the extension of the delivery time for this order.', 'wpjobster' );
				}
			}

			return ['icon' => $icon, 'iconsize' => $iconsize, 'bgcolor' => $bgcolor, 'message' => $message];

		}

		return false;

	}
}