<?php
if ( ! function_exists( 'wpj_refund_payment' ) ) {
	function wpj_refund_payment( $row = [], $oid = '', $from_cron = false ) {
		if ( $row && $oid ) {
			$transaction = wpj_get_payment_transaction( 'id', ['tp' => 1, 'oid' => $oid, 'rid' => 7, 'uid' => $row->uid], 'row' );

			if ( $transaction ) {
				return false;
			}

			if ( $row->closed == 1 || ( $row->completed == 1 && $row->clearing_period != 3 ) ) {
				return false;
			}

			$post = get_post( $row->pid );

			if ( ! $from_cron ) {
				if ( ! is_super_admin( get_current_user_id() ) ) {
					if ( $row->uid != get_current_user_id() && $post->post_author != get_current_user_id() ) {
						return false;
					}
				}
			}

			if ( ( $row->closed != 1 && $row->completed != 1 ) || ( $row->closed != 1 && $row->clearing_period == 3 ) ) {
				$amount = wpj_get_refundable_amount( $row );

				wpj_update_user_credit( $row->uid, wpj_get_user_credit( $row->uid ) + $amount );

				$reason = __( 'Payment refunded for', 'wpjobster' ) . ': <a href="' . wpj_get_order_link( $oid ) . '">' . $post->post_title . '</a>';

				wpj_add_history_log(['tp' => '1', 'reason' => $reason, 'amount' => $amount, 'uid' => $row->uid, 'oid' => $oid, 'rid' => 7]);
			}
		}

		return true;
	}
}

if ( ! function_exists( 'wpj_get_refundable_amount' ) ) {
	function wpj_get_refundable_amount( $order ) {
		if ( ! is_object( $order ) ) $order = wpj_get_job_order_by_id( $order );

		$enable_refund_processing_fees = wpj_get_option( 'wpjobster_enable_refund_buyer_processing_fees' );
		$enable_refund_tax             = wpj_get_option( 'wpjobster_enable_refund_tax' );

		if ( $order->payment_gateway == 'cod' ) {
			$refundable_amount = 0;

		} elseif ( $order->payment_status == 'completed' || $order->payment_status == '' || $order->payment_status == 'cancelled' ) {
			$refundable_amount = $order->mc_gross;

			if ( $enable_refund_processing_fees == 'yes' ) {
				$refundable_amount = $refundable_amount + $order->processing_fees;
			}

			if ( $enable_refund_tax == 'yes' ) {
				$refundable_amount = $refundable_amount + $order->tax_amount;
			}

		} else {
			$refundable_amount = 0;

		}

		if ( ! empty( $order->custom_extras ) ) {
			$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );

			if ( $custom_extras ) {
				$i = 0;

				foreach ( $custom_extras as $custom_extra ) {
					if ( $custom_extra->paid ) {
						$custom_extra_order   = wpj_get_custom_extra_order( '*', ['order_id' => $order->id, 'custom_extra_id' => $i], 'row' );
						$custom_extra_payment = wpj_get_payment(['payment_type' => 'custom_extra', 'payment_type_id' => $custom_extra_order->id]);

						if ( $custom_extra_payment && $custom_extra_payment->payment_gateway != 'cod' && $custom_extra_payment->payment_status == 'completed' ) {

							$refundable_amount += $custom_extra_payment->amount;

							if ( $enable_refund_processing_fees == 'yes' ) {
								$refundable_amount += $custom_extra_payment->fees;
							}

							if ( $enable_refund_tax == 'yes' ) {
								$refundable_amount += $custom_extra_payment->tax;
							}
						}
					} $i++;
				}
			}
		}

		if ( ! empty ( $order->tips ) ) {
			$tips = wpj_json_decode( wpj_stripslashes( $order->tips ) );

			if ( $tips ) {
				$i = 0;

				foreach ( $tips as $tip ) {
					if ( $tip->paid ) {
						$tips_order   = wpj_get_tips_order( '*', ['order_id' => $order->id, 'tips_id' => $i], 'row' );
						$tips_payment = wpj_get_payment(['payment_type' => 'tips', 'payment_type_id' => $tips_order->id]);

						if ( $tips_payment->payment_gateway != 'cod' && $tips_payment->payment_status == 'completed' ) {

							$refundable_amount += $tips_payment->amount;

							if ( $enable_refund_processing_fees == 'yes' ) {
								$refundable_amount += $tips_payment->fees;
							}

							if ( $enable_refund_tax == 'yes' ) {
								$refundable_amount += $tips_payment->tax;
							}
						}
					} $i++;
				}
			}
		}

		return apply_filters( 'wpj_refund_price_filter', $refundable_amount, $order );
	}
}