<?php
if ( ! function_exists( 'wpj_send_transaction_message' ) ) {
	function wpj_send_transaction_message( $oid = '', $message = '', $attachments = '', $sender_id = '' ) {
		if ( ! is_demo_user() ) {
			$oid         = WPJ_Form::post( 'order_id', $oid );
			$message     = WPJ_Form::post( 'message', $message );
			$attachments = WPJ_Form::post( 'hidden_files_chat_box_attachments', $attachments );

			if ( ! $sender_id ) {
				$sender_id = get_current_user_id();
			}

			if ( ! $oid ) $oid = get_query_var( 'oid' );

			if ( $oid ) {
				$order = wpj_get_job_order_by_id( $oid );

				if ( $order ) {
					$seller_id = get_post_field( 'post_author', $order->pid );
					$message   = trim( nl2br( strip_tags( htmlspecialchars( wpj_encode_emoji( $message ) ) ) ) );

					// Insert notification
					$this_notification = wpj_insert_order_notification( ['uid' => $sender_id, 'oid' => $order->id, 'content' => $message, 'attachment' => $attachments], ['%d', '%d', '%s', '%s'] );

					if ( $this_notification > 0 ) {
						wpj_save_attachments( explode( ',', $attachments ), $this_notification, 'message_id', 'new', 'post' );

						if ( is_super_admin( $sender_id ) && $sender_id != $order->uid && $sender_id != $seller_id ) {
							wpj_update_user_notifications([
								'user1'       => $order->uid,
								'user2'       => $sender_id,
								'type'        => 'notifications',
								'number'      => +1,
								'notify_id'   => $this_notification,
								'notify_type' => 'order_message',
								'order_id'    => $order->id
							]);

							wpj_notify_user_translated( 'order_message', $order->uid, [
								'##sender_username##'       => wpj_get_user_display_type( $sender_id ),
								'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
								'##transaction_page_link##' => wpj_get_order_link( $order->id ),
								'##job_name##'              => $order->job_title,
								'##job_link##'              => urldecode( get_permalink( $order->pid ) )
							]);
						}

						$uid_to_send = $sender_id == $seller_id ? $order->uid : $seller_id;
						$uid_sender  = $sender_id == $seller_id ? $seller_id : $order->uid;

						wpj_update_user_notifications([
							'user1'       => $uid_to_send,
							'user2'       => $uid_sender,
							'type'        => 'notifications',
							'number'      => +1,
							'notify_id'   => $this_notification,
							'notify_type' => 'order_message',
							'order_id'    => $order->id
						]);

						wpj_notify_user_translated( 'order_message', $uid_to_send, [
							'##sender_username##'       => wpj_get_user_display_type( $sender_id ),
							'##transaction_number##'    => wpj_camouflage_oid( $order->id, $order->date_made ),
							'##transaction_page_link##' => wpj_get_order_link( $order->id ),
							'##job_name##'              => $order->job_title,
							'##job_link##'              => urldecode( get_permalink( $order->pid ) )
						]);
					}
				}
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}