<?php

/**
 * Returns true if currently editing the page with a known page builder
 * Supports Brizy and Visual Composer (WPBakery)
 *
 * Undefined if called too early, for example in hooks before wp_load!
 */
if ( ! function_exists( 'wpj_is_pagebuilder_editor' ) ) {
	function wpj_is_pagebuilder_editor() {
		global $pagenow;

		if ( wpj_is_visual_composer_editor()
			|| wpj_is_brizy_editor()
			|| ( $pagenow == 'post.php' && isset( $_GET['action'] ) && $_GET['action'] == 'edit' )
		) {
			return true;
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_is_brizy_editor' ) ) {
	function wpj_is_brizy_editor(){
		if ( isset( $_GET['brizy-edit'] ) || isset( $_GET['brizy-edit-iframe'] ) || ( isset( $_POST['action'] ) && $_POST['action'] == 'brizy_shortcode_content' ) )
			return true;

		return false;
	}
}

if ( ! function_exists( 'wpj_is_visual_composer_editor' ) ) {
	function wpj_is_visual_composer_editor(){
		if ( function_exists( 'vc_is_inline' ) ) {
			if ( vc_is_inline() )
				return true;

			else
				return false;

		} else {
			return false;

		}
	}
}

if ( ! function_exists( 'wpj_page_builder_rows_conditionally_appearance' ) ) {
	function wpj_page_builder_rows_conditionally_appearance() {
		if ( wpj_get_option( 'wpjobster_enable_shoutout_offer_number' ) != 'yes' ) {
			wp_add_inline_style( 'semantic-ui-css', '.shoutout-offer-wrapper {display:none;}' );
		}

		if ( wpj_get_option( 'wpjobster_enable_user_2fa' ) == 'no' && wpj_is_page( 'wpjobster_my_account_personal_info_page_id' ) ) {
			wp_add_inline_style( 'semantic-ui-css', '.twofa-authentication-row-wrapper {display:none;}' );
		}

		if ( wpj_get_option( 'wpjobster_enable_user_company' ) == 'no' ) {
			wp_add_inline_style( 'semantic-ui-css', '.company-column-wrapper .kt-inside-inner-col {display:none;}' );
		}

		if ( wpj_get_option( 'wpjobster_enable_user_vat_id' ) == 'no' ) {
			wp_add_inline_style( 'semantic-ui-css', '.tax-id-column-wrapper .kt-inside-inner-col {display:none;}' );
		}

		if ( wpj_get_option( 'wpjobster_enable_country_select' ) == 'no' ) {
			wp_add_inline_style( 'semantic-ui-css', '.country-column-wrapper .kt-inside-inner-col {display:none;}' );
		}

		if ( count( wpj_get_preferred_languages() ) < 2 ) {
			wp_add_inline_style( 'semantic-ui-css', '.preferred-language-column-wrapper .kt-inside-inner-col {display:none;}' );
		}

		if ( wpj_withdrawal_gateway_enabled_exist( true ) ) {
			wp_add_inline_style( 'semantic-ui-css', '#payments {display:block !important;}' );
		}

		if ( wpj_is_payment_type_enabled( 'paypal', 'withdraw' ) ) {
			wp_add_inline_style( 'semantic-ui-css', '#paypal-settings {display:block !important;}' );
		}

		if ( wpj_is_payment_type_enabled( 'payoneer', 'withdraw', true ) ) {
			wp_add_inline_style( 'semantic-ui-css', '#payoneer-settings {display:block !important;}' );
		}

		if ( wpj_is_payment_type_enabled( 'banktransfer', 'withdraw' ) ) {
			wp_add_inline_style( 'semantic-ui-css', '#bank-transfer-settings {display:block !important;}' );
		}
	}
}