<?php /* Site Pages */

if ( ! function_exists( 'wpj_get_page_names' ) ) {
	function wpj_get_page_names( $with_filter = true ) {
		$pages = [
			'wpjobster_not_found_page_id'                    => '404',
			'wpjobster_all_categories_page_id'               => 'All Categories',
			'wpjobster_all_news_page_id'                     => 'All News',
			'wpjobster_all_proposals_page_id'                => 'All Proposals',
			'wpjobster_all_requests_page_id'                 => 'All Requests',
			'wpjobster_badges_page_id'                       => 'Badges',
			'wpjobster_all_blog_posts_page_id'               => 'Blog Posts',
			'wpjobster_checkout_page_id'                     => 'Checkout',
			'wpjobster_feature_page_id'                      => 'Feature Job',
			'wpjobster_forgot_password_page_id'              => 'Authentication - Forgot Password',
			'main_page_url'                                  => 'Homepage',
			'main_page_url_user'                             => 'Homepage - Loggedin',
			'wpjobster_how_it_works_page_id'                 => 'How It Works?',
			'wpjobster_jobs_map_overview_page_id'            => 'Jobs Map Overview',
			'wpjobster_levels_page_id'                       => 'Levels',
			'wpjobster_login_page_id'                        => 'Authentication - Login',
			'wpjobster_my_account_page_id'                   => 'My Account',
				'wpjobster_my_account_all_notifications_page_id' => 'All Notifications',
				'wpjobster_email_settings_page_id'               => 'Email Settings',
				'wpjobster_my_favorites_page_id'                 => 'My Favorites',
				'wpjobster_my_requests_page_id'                  => 'My Requests',
				'wpjobster_my_account_payments_page_id'          => 'Payments',
				'wpjobster_my_account_priv_mess_page_id'         => 'Private Messages',
				'wpjobster_my_account_reviews_page_id'           => 'Reviews/Feedback',
				'wpjobster_my_account_sales_page_id'             => 'Sales',
				'wpjobster_my_account_personal_info_page_id'     => 'Settings',
				'wpjobster_my_account_shopping_page_id'          => 'Shopping',
				'wpjobster_subscriptions_page_id'                => 'Subscriptions',
			'wpjobster_order_page_id'                        => 'Order',
			'wpjobster_post_new_page_id'                     => 'Post New or Edit Job',
			'wpjobster_new_request_page_id'                  => 'Post New or Edit Request',
			'wpjobster_privacy_policy_page_id'               => 'Privacy Policy',
			'wpjobster_register_page_id'                     => 'Authentication - Register',
			'wpjobster_advanced_search_id'                   => 'Search Jobs',
			'wpjobster_advanced_search_request_page_id'      => 'Search Requests',
			'wpjobster_search_user_page_id'                  => 'Search Users',
			'wpjobster_single_blog_page_id'                  => 'Single Blog',
			'wpjobster_single_job_page_id'                   => 'Single Job',
			'wpjobster_single_news_page_id'                  => 'Single News',
			'wpjobster_single_request_page_id'               => 'Single Request',
			'wpjobster_terms_of_service_page_id'             => 'Terms of Service',
			'wpjobster_topup_order_page_id'                  => 'TopUp Order',
			'wpjobster_user_profile_page_id'                 => 'User Profile',
			'wpjobster_verify_email_page_id'                 => 'Verify Email',
			'wpjobster_verify_phone_page_id'                 => 'Verify Phone'
		];

		if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
		}

		if ( $with_filter && is_plugin_active( 'di-aiosc/di-aiosc.php' ) ) {
			$pages['wpjobster_new_ticket_page_id']    = 'New Ticket';
			$pages['wpjobster_single_ticket_page_id'] = 'Single Ticket';
			$pages['wpjobster_ticket_list_page_id']   = 'Support Page';
		}

		if ( $with_filter ) {
			$pages = apply_filters( 'wpj_page_names_filter', $pages );
		}

		return $pages;
	}
}

if ( ! function_exists( 'wpj_get_page_functions' ) ) {
	function wpj_get_page_functions() {
		return apply_filters( 'wpj_page_functions_filter', [
			/* Theme */
			'wpjobster_not_found_page_id'                    => 'wpj_page_not_found_fnc',
			'main_page_url'                                  => 'wpj_page_homepage_fnc',
			'main_page_url_user'                             => 'wpj_page_homepage_loggedin_fnc',
			'wpjobster_levels_page_id'                       => 'wpj_page_levels_fnc',
			'wpjobster_how_it_works_page_id'                 => 'wpj_page_how_it_works_fnc',
			'wpjobster_privacy_policy_page_id'               => 'wpj_page_privacy_policy_fnc',
			'wpjobster_terms_of_service_page_id'             => 'wpj_page_terms_of_service_fnc',

			/* Authentication */
			'wpjobster_forgot_password_page_id'              => 'wpj_page_forgot_password_fnc',
			'wpjobster_login_page_id'                        => 'wpj_page_login_fnc',
			'wpjobster_register_page_id'                     => 'wpj_page_register_fnc',

			/* Blog */
			'wpjobster_all_blog_posts_page_id'               => 'wpj_page_blog_posts_fnc',
			'wpjobster_single_blog_page_id'                  => 'wpj_page_single_blog_fnc',
			'wpjobster_all_news_page_id'                     => 'wpj_page_news_posts_fnc',
			'wpjobster_single_news_page_id'                  => 'wpj_page_single_news_fnc',

			/* Job */
			'wpjobster_single_job_page_id'                   => 'wpj_page_single_job_fnc',
			'wpjobster_my_account_page_id'                   => 'wpj_page_my_account_fnc',
			'wpjobster_my_favorites_page_id'                 => 'wpj_page_favourites_fnc',
			'wpjobster_all_categories_page_id'               => 'wpj_page_all_categories_fnc',
			'wpjobster_advanced_search_id'                   => 'wpj_page_job_search_fnc',
			'wpjobster_post_new_page_id'                     => 'wpj_page_post_new_edit_job_fnc',
			'wpjobster_jobs_map_overview_page_id'            => 'wpj_page_jobs_map_overview_fnc',

			/* Request */
			'wpjobster_single_request_page_id'               => 'wpj_page_single_request_fnc',
			'wpjobster_my_requests_page_id'                  => 'wpj_page_my_requests_fnc',
			'wpjobster_advanced_search_request_page_id'      => 'wpj_page_request_search_fnc',
			'wpjobster_new_request_page_id'                  => 'wpj_page_post_new_edit_request_fnc',
			'wpjobster_all_requests_page_id'                 => 'wpj_page_all_requests_fnc',
			'wpjobster_all_proposals_page_id'                => 'wpj_page_all_proposals_fnc',

			/* User */
			'wpjobster_my_account_personal_info_page_id'     => 'wpj_page_personal_info_fnc',
			'wpjobster_search_user_page_id'                  => 'wpj_page_user_search_fnc',
			'wpjobster_user_profile_page_id'                 => 'wpj_page_user_profile_fnc',

			/* User Verification */
			'wpjobster_verify_email_page_id'                 => 'wpj_page_verify_email_fnc',
			'wpjobster_verify_phone_page_id'                 => 'wpj_page_verify_phone_fnc',

			/* Payment */
			'wpjobster_my_account_sales_page_id'             => 'wpj_page_sales_fnc',
			'wpjobster_my_account_shopping_page_id'          => 'wpj_page_shopping_fnc',
			'wpjobster_my_account_payments_page_id'          => 'wpj_page_payments_fnc',
			'wpjobster_checkout_page_id'                     => 'wpj_page_checkout_fnc',
			'wpjobster_badges_page_id'                       => 'wpj_page_badge_checkout_fnc',
			'wpjobster_feature_page_id'                      => 'wpj_page_feature_checkout_fnc',
			'wpjobster_subscriptions_page_id'                => 'wpj_page_subscription_fnc',

			/* Order */
			'wpjobster_order_page_id'                        => 'wpj_page_order_fnc',
			'wpjobster_topup_order_page_id'                  => 'wpj_page_topup_order_fnc',
			'wpjobster_my_account_reviews_page_id'           => 'wpj_page_review_fnc',

			/* Notification */
			'wpjobster_my_account_all_notifications_page_id' => 'wpj_page_all_notifications_fnc',
			'wpjobster_my_account_priv_mess_page_id'         => 'wpj_page_private_message_fnc',
			'wpjobster_email_settings_page_id'               => 'wpj_page_email_settings_fnc',
		] );
	}
}

if ( ! function_exists( 'wpj_get_page_ids' ) ) {
	function wpj_get_page_ids() {
		$jobster_pages = [];

		foreach ( wpj_get_page_functions() as $option => $function_name ) {
			$jobster_pages[$option] = wpj_get_option( $option );
		}

		return apply_filters( 'wpj_page_ids_filter', $jobster_pages );
	}
}

if ( ! function_exists( 'wpj_get_user_account_pages' ) ) {
	function wpj_get_user_account_pages() {
		return apply_filters( 'wpj_user_account_pages_filter', [
			wpj_get_option( 'wpjobster_my_account_all_notifications_page_id' ),
			wpj_get_option( 'wpjobster_email_settings_page_id' ),
			wpj_get_option( 'wpjobster_my_account_payments_page_id' ),
			wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' ),
			wpj_get_option( 'wpjobster_my_account_reviews_page_id' ),
			wpj_get_option( 'wpjobster_my_account_sales_page_id' ),
			wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ),
			wpj_get_option( 'wpjobster_my_account_shopping_page_id' ),
			wpj_get_option( 'wpjobster_my_favorites_page_id' ),
			wpj_get_option( 'wpjobster_my_requests_page_id' ),
			wpj_get_option( 'wpjobster_all_proposals_page_id' ),
			wpj_get_option( 'wpjobster_subscriptions_page_id' ),
			wpj_get_option( 'wpjobster_my_account_page_id' )
		] );
	}
}

if ( ! function_exists( 'wpj_get_user_logged_in_pages' ) ) {
	function wpj_get_user_logged_in_pages() {
		return apply_filters( 'wpj_user_logged_in_pages_filter', [
			wpj_get_option( 'main_page_url_user' ),
			wpj_get_option( 'wpjobster_my_account_page_id' ),
			wpj_get_option( 'wpjobster_my_favorites_page_id' ),
			wpj_get_option( 'wpjobster_post_new_page_id' ),
			wpj_get_option( 'wpjobster_my_requests_page_id' ),
			wpj_get_option( 'wpjobster_all_proposals_page_id' ),
			wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ),
			wpj_get_option( 'wpjobster_my_account_sales_page_id' ),
			wpj_get_option( 'wpjobster_my_account_shopping_page_id' ),
			wpj_get_option( 'wpjobster_my_account_payments_page_id' ),
			wpj_get_option( 'wpjobster_checkout_page_id' ),
			wpj_get_option( 'wpjobster_badges_page_id' ),
			wpj_get_option( 'wpjobster_feature_page_id' ),
			wpj_get_option( 'wpjobster_subscriptions_page_id' ),
			wpj_get_option( 'wpjobster_order_page_id' ),
			wpj_get_option( 'wpjobster_topup_order_page_id' ),
			wpj_get_option( 'wpjobster_my_account_reviews_page_id' ),
			wpj_get_option( 'wpjobster_my_account_all_notifications_page_id' ),
			wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' ),
			wpj_get_option( 'wpjobster_email_settings_page_id' )
		] );
	}
}

/* Helpers */

if ( ! function_exists( 'wpj_page_content_type' ) ) {
	function wpj_page_content_type( $page_id = '' ) {
		if ( ! is_numeric( $page_id ) ) {
			$page_id = wpj_get_option( $page_id );
		}

		$page_data = get_post_meta( $page_id, 'page_content_source', true );

		if ( strtolower( $page_data ) == 'code' ) {
			return 'code';
		}

		return 'page_builder';
	}
}

if ( ! function_exists( 'wpj_is_page' ) ) {
	function wpj_is_page( $page = '' ) {
		if ( is_numeric( $page ) && is_page( $page ) )
			return true;

		elseif ( wpj_get_option( $page ) && is_page( wpj_get_option( $page ) ) )
			return true;

		return false;
	}
}

if ( ! function_exists( 'wpj_insert_page' ) ) {
	function wpj_insert_page( $page_id_meta, $page_title, $page_content, $parent_pg = 0, $wp_page_template = '' ) {
		$page_id = wpj_get_option( $page_id_meta );

		if ( ! wpj_page_exist( $page_id ) ) {
			$post = [
				'post_title'   => $page_title,
				'post_content' => $page_content,
				'post_status'  => 'publish',
				'post_type'    => 'page',
				'post_author'  => 1,
				'ping_status'  => 'closed',
				'post_parent'  => $parent_pg
			];

			$page_id = wp_insert_post( $post );

			if ( $wp_page_template ) {
				update_post_meta( $page_id, '_wp_page_template', 'page-templates/' . $wp_page_template );
			}

			update_post_meta( $page_id, 'page_content_source', 'page_builder' );
		}

		if ( class_exists( 'Redux' ) ) {
			Redux::set_option( 'jobster_settings', $page_id_meta, $page_id );
		}

		update_option( $page_id_meta, $page_id );

		return $page_id;
	}
}

if ( ! function_exists( 'wpj_page_exist' ) ) {
	function wpj_page_exist( $pid ) {
		if ( $pid ) {
			$results = wpj_get_post( 'COUNT( * )', ['post_type' => 'page', 'post_status' => 'publish', 'ID' => $pid], 'var' );

			if ( $results > 0 ) {
				return true;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_tabs_by_page' ) ) {
	function wpj_get_tabs_by_page( $page ) {
		$tabs = [];

		if ( $page == 'user_jobs' ) {
			$tabs = [
				'active'       => __( 'Active', 'wpjobster' ),
				'inactive'     => __( 'Inactive', 'wpjobster' ),
				'under-review' => __( 'Under Review', 'wpjobster' ),
				'rejected'     => __( 'Rejected', 'wpjobster' ),
			];

			$tabs = apply_filters( 'wpj_user_jobs_tabs_slug_filter', $tabs );
		}

		if ( $page == 'user_shopping' ) {
			$tabs = ['active' => __( 'Active', 'wpjobster' )];

			if ( wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) == 'yes' ) $tabs['pending-confirmation'] = __( 'Pending Confirmation', 'wpjobster' );

			$tabs['pending-review']  = __( 'Pending Review', 'wpjobster' );
			$tabs['completed']       = __( 'Completed', 'wpjobster' );
			$tabs['pending-payment'] = __( 'Pending Payment', 'wpjobster' );
			$tabs['cancelled']       = __( 'Cancelled', 'wpjobster' );

			$tabs = apply_filters( 'wpj_user_shopping_tabs_slug_filter', $tabs );
		}

		if ( $page == 'user_sales' ) {
			$tabs = ['active' => __( 'Active', 'wpjobster' )];

			if ( wpj_get_option( 'wpjobster_seller_order_rejection_enable' ) == 'yes' ) $tabs['pending-confirmation'] = __( 'Pending Confirmation', 'wpjobster' );

			$tabs['pending-payment'] = __( 'Pending Orders', 'wpjobster' );
			$tabs['delivered']       = __( 'Delivered', 'wpjobster' );
			$tabs['completed']       = __( 'Completed', 'wpjobster' );
			$tabs['cancelled']       = __( 'Cancelled', 'wpjobster' );

			$tabs = apply_filters( 'wpj_user_sales_tabs_slug_filter', $tabs );
		}

		if ( $page == 'user_requests' ) {
			$tabs = [
				'active'    => __( 'Active', 'wpjobster' ),
				'inactive'  => __( 'Inactive', 'wpjobster' ),
				'in-review' => __( 'In Review', 'wpjobster' ),
				'rejected'  => __( 'Rejected', 'wpjobster' ),
				'assigned'  => __( 'Assigned', 'wpjobster' ),
				'completed' => __( 'Completed', 'wpjobster' ),
			];

			$tabs = apply_filters( 'wpj_user_requests_tabs_slug_filter', $tabs );
		}

		if ( $page == 'user_payments' ) {
			$tabs = [
				'payments'     => __( 'Payments', 'wpjobster' ),
				'transactions' => __( 'Transactions', 'wpjobster' )
			];

			if ( wpj_get_option( 'wpjobster_enable_topup' ) == 'yes' ) $tabs['top-up'] = __( 'Top Up', 'wpjobster' );

			if ( wpj_withdrawal_gateway_enabled_exist() ) $tabs['withdraw-money'] = __( 'Withdraw Money', 'wpjobster' );

			$tabs = apply_filters( 'wpj_user_payments_tabs_slug_filter', $tabs );
		}

		if ( $page == 'user_feedback' ) {
			$tabs = [
				'ratings-to-award' => __( 'Ratings to Award', 'wpjobster' ),
				'pending-ratings'  => __( 'Pending Ratings', 'wpjobster' ),
				'my-ratings'       => __( 'My Ratings', 'wpjobster' ),
			];

			$tabs = apply_filters( 'wpj_user_feedback_tabs_slug_filter', $tabs );
		}

		if ( $page == 'user_settings' ) {
			$tabs['account'] = __( 'Account', 'wpjobster' );

			if ( wpj_get_option( 'wpjobster_enable_user_social_media' ) == 'yes' ) $tabs['social-media'] = __( 'Social Media', 'wpjobster' );

			if ( wpj_get_up_custom_fields_content() ) $tabs['additional-details'] = __( 'Additional Details', 'wpjobster' );

			$tabs['security'] = __( 'Security', 'wpjobster' );

			if ( wpj_withdrawal_gateway_enabled_exist() ) $tabs['payments'] = __( 'Payments', 'wpjobster' );

			$tabs = apply_filters( 'wpj_user_settings_tabs_slug_filter', $tabs );
		}

		if ( $page == 'user_subscription' ) {
			$tabs = [
				'current-subscription'  => __( 'Current Subscription', 'wpjobster' ),
				'upgrade-subscription'  => __( 'Upgrade Subscription', 'wpjobster' ),
				'schedule-subscription' => __( 'Schedule Upgrade', 'wpjobster' ),
			];

			$tabs = apply_filters( 'wpj_user_subscription_tabs_slug_filter', $tabs );
		}

		if ( $page == 'user_proposals' ) {
			$tabs = [
				'send'     => __( 'Sent', 'wpjobster' ),
				'received' => __( 'Received', 'wpjobster' )
			];

			$tabs = apply_filters( 'wpj_user_proposals_tabs_slug_filter', $tabs );
		}

		return apply_filters( 'wpj_tabs_list_info_filter', $tabs, $page );
	}
}

if ( ! function_exists( 'wpj_get_filtered_block_content' ) ) {
	function wpj_get_filtered_block_content( $post_id ) {
		global $post;

		$prev_post = $post; // backup $post

		$post = get_post( $post_id );

		setup_postdata( $post ); // update $post

		$content = apply_filters( 'the_content', $post->post_content ); // retrieve content

		wp_reset_postdata(); // restore $post

		$post = $prev_post;

		return $content;
	}
}

if ( ! function_exists( 'wpj_get_page_by_title' ) ) {
	function wpj_get_page_by_title( $title, $post_type = 'page' ) {
		$query = new WP_Query(
			[
				'post_type'              => $post_type,
				'title'                  => $title,
				'post_status'            => 'all',
				'posts_per_page'         => 1,
				'no_found_rows'          => true,
				'ignore_sticky_posts'    => true,
				'update_post_term_cache' => false,
				'update_post_meta_cache' => false,
				'orderby'                => 'post_date ID',
				'order'                  => 'ASC',
			]
		);

		if ( ! empty( $query->post ) ) {
			return $query->post;
		}

		return false;
	}
}