<?php
if ( ! function_exists( 'wpj_get_payment' ) ) {
	function wpj_get_payment( $args ) {
		$defaults = [
			'id'              => false,
			'payment_type'    => 'job_purchase',
			'payment_type_id' => false,
		];

		$args = wp_parse_args( $args, $defaults );

		/**
		 * @var number $id
		 * @var string $payment_type
		 * @var number $payment_type_id
		 */
		extract( $args );

		if ( $id )
			return wpj_get_payment_order( '*', ['id' => $id], 'row' );

		elseif ( $payment_type_id )
			return wpj_get_payment_order( '*', ['payment_type' => $payment_type, 'payment_type_id' => $payment_type_id], 'row' );

		return false;
	}
}

if ( ! function_exists( 'wpj_get_query_payments' ) ) {
	function wpj_get_query_payments( $query_type, $query_status, $function_name, $class_name, $posts_per_page = '' ) {
		if ( ! $posts_per_page ) {
			$posts_per_page = wpj_get_option( 'posts_per_page' ) ? wpj_get_option( 'posts_per_page' ) : 12;
		}

		return new WPJ_Load_More_Queries(
			[
				'query_type'        => $query_type,
				'query_status'      => $query_status,
				'function_name'     => $function_name,
				'posts_per_page'    => $posts_per_page,
				'row_extra_classes' => $class_name
			]
		);
	}
}

if ( ! function_exists( 'wpj_get_payment_info_by_url' ) ) {
	function wpj_get_payment_info_by_url( $var = '' ) {
		$oid = WPJ_Form::request( 'oid' );

		if ( ! $oid ) {
			global $wp_query;

			if ( isset( $wp_query->query_vars['oid'] ) ) {
				$oid = $wp_query->query_vars['oid'];
			}
		}

		$jobid = isset( $_REQUEST['jobid'] ) ? $_REQUEST['jobid'] : '';

		if ( ! $jobid ) {
			if ( empty( $wp_query ) ) {
				global $wp_query;
			}

			if ( isset( $wp_query->query_vars['jobid'] ) ) {
				$jobid = $wp_query->query_vars['jobid'];
			}
		}

		$pid = $payment_type = $order = $custom_extra = $tip = false;
		$redirect_link = get_bloginfo( 'url' );

		// Job purchase
		if ( $jobid ) {
			$payment_type  = 'job_purchase';
			$pid           = WPJ_Form::request( 'jobid' );
			$redirect_link = get_permalink( $pid );
		}

		// Custom extra purchase
		if ( $oid && isset( $_REQUEST['custom_extra'] ) ) {
			$payment_type    = 'custom_extra';
			$order           = wpj_get_job_order( 'pid, custom_extras, uid', ['id' => $oid], 'row' );
			$pid             = $order->pid;
			$custom_extra_id = WPJ_Form::request( 'custom_extra' );
			$custom_extras   = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );
			$custom_extra    = $custom_extras[$custom_extra_id];
			$redirect_link   = wpj_get_order_link( $oid );
		}

		// Tips purchase
		if ( $oid && isset( $_REQUEST['tips'] ) ) {
			$payment_type  = 'tips';
			$order         = wpj_get_job_order( 'pid, tips, uid', ['id' => $oid], 'row' );
			$pid           = $order->pid;
			$tips_id       = WPJ_Form::request( 'tips' );
			$tips          = wpj_json_decode( wpj_stripslashes( $order->tips ) );
			$tip           = $tips[$tips_id];
			$redirect_link = wpj_get_order_link( $oid );
		}

		$return_arr = [
			'payment_type'  => $payment_type,
			'pid'           => $pid,
			'order'         => $order,
			'oid'           => $oid,
			'custom_extra'  => $custom_extra,
			'tip'           => $tip,
			'redirect_link' => $redirect_link
		];

		return $var ? $return_arr[$var] : $return_arr;
	}
}

if ( ! function_exists( 'wpj_get_total_amount_spent' ) ) {
	function wpj_get_total_amount_spent( $by_user = '' ) {
		if ( $by_user ) {
			return wpj_show_price( wpj_get_job_orders_total_spent_by_user( get_current_user_id() ) );

		} else {
			$transaction_amount_total = 0;

			$total_spent_results = wpj_get_users_total_spent_amount();

			if ( $total_spent_results ) {
				foreach ( $total_spent_results as $key => $row ) {
					$trans_amount = explode( '|', $row->final_paidamount );

					if ( $trans_amount[0] && $trans_amount[0] != wpj_get_site_default_currency() ) {
						$currency_from = $trans_amount[0];
						$currency_to   = wpj_get_site_default_currency();

						$transaction_amount = wpj_get_exchanged_value( $trans_amount[1], $currency_from, $currency_to );

					} else {
						$transaction_amount = $trans_amount[1];

					}

					$transaction_amount_total += floatval( $transaction_amount );
				}
			}

			return $transaction_amount_total > 0 ? wpj_show_price( $transaction_amount_total ) : '0';
		}
	}
}

if ( ! function_exists( 'wpj_get_total_completed_orders' ) ) {
	function wpj_get_total_completed_orders( $by_user = '' ) {
		if ( $by_user ) {
			if ( $by_user != 'sales' ) {
				$total_shopping_completed = wpj_get_shopping_orders( get_current_user_id(), 'completed' );

				return $total_shopping_completed ? intval( $total_shopping_completed ) : __( 'None', 'wpjobster' );

			} else {
				$total_sales_completed = wpj_get_sales_orders( get_current_user_id(), 'completed' );

				return $total_sales_completed ? intval( $total_sales_completed ) : __( 'None', 'wpjobster' );
			}

		} else {
			return wpj_get_job_order( 'COUNT( * )', ['completed' => 1], 'var' );

		}
	}
}