<?php
if ( ! function_exists( 'wpj_get_wpjobster_plugins_list' ) ) {
	function wpj_get_wpjobster_plugins_list( $ret_part = [], $ret_as_folder = false ) {
		$extensions = $gateways = $withdrawal_gateways = [];

		if ( ! $ret_part || in_array( 'extensions', $ret_part ) )
			$extensions = apply_filters( 'wpj_extensions_plugins_folder_list_filter', ['wpjobster-demo-admin', 'wpjobster-category-price', 'wpjobster-category-tax'] );

		if ( ! $ret_part || in_array( 'gateways', $ret_part ) )
			$gateways = apply_filters( 'wpj_gateways_plugins_folder_list_filter', [] );

		if ( ! $ret_part || in_array( 'withdrawals', $ret_part ) )
			$withdrawal_gateways = apply_filters( 'wpj_withdrawal_gateways_plugins_folder_list_filter', [] );

		$plugins = array_merge( $extensions, $gateways, $withdrawal_gateways );

		if ( $ret_as_folder )
			return apply_filters( 'wpj_plugins_folder_list_filter', $plugins );

		$plugins_array = [];

		foreach ( $plugins as $key => $plugin ) {
			$plugins_array[] = $plugin . '/' . $plugin . '.php';
		}

		return apply_filters( 'wpj_plugins_list_filter', $plugins_array );
	}
}

if ( ! function_exists( 'wpj_deactivate_plugin' ) ) {
	function wpj_deactivate_plugin( $plugin_path, $error = '' ) {
		if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
		}

		if ( is_plugin_active( $plugin_path ) ) {
			deactivate_plugins( $plugin_path, true ); ?>

			<div data-dismissible="compatibility-theme-notice" class="notice notice-error is-dismissible"><p><?php echo $error; ?></p></div>

			<?php if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );
		}
	}
}

if ( ! function_exists( 'wpj_remove_plugin_class_method_action' ) ) {
	function wpj_remove_plugin_class_method_action( $tag, $class = '', $method = '', $priority = null ) : bool {
		global $wp_filter;

		if ( isset( $wp_filter[$tag] ) ) {
			$len = strlen( $method );

			foreach ( $wp_filter[$tag] as $_priority => $actions ) {
				if ( $actions ) {
					foreach ( $actions as $function_key => $data ) {
						if ( $data ) {
							if ( substr( $function_key, -$len ) == $method ) {
								if ( $class !== '' ) {
									if ( is_string( $data['function'][0] ) )
										$_class = $data['function'][0];

									elseif ( is_object( $data['function'][0] ) )
										$_class = get_class( $data['function'][0] );

									else
										return false;

									if ( $_class !== '' && $_class == $class ) {
										if ( is_numeric( $priority ) ) {
											if ( $_priority == $priority ) {
												return $wp_filter[$tag]->remove_filter( $tag, $function_key, $_priority );
											}

										} else {
											return $wp_filter[$tag]->remove_filter( $tag, $function_key, $_priority );

										}
									}

								} else {
									if ( is_numeric( $priority ) ) {
										if ( $_priority == $priority ) {
											return $wp_filter[$tag]->remove_filter( $tag, $function_key, $_priority );
										}

									} else {
										return $wp_filter[$tag]->remove_filter( $tag, $function_key, $_priority );

									}
								}
							}
						}
					}
				}
			}
		}

		return false;
	}
}