<?php
if ( ! function_exists( 'wpj_get_post_id' ) ) {
	function wpj_get_post_id( $pid = '' ) {
		if ( $pid && is_numeric( $pid ) ) return $pid;

		if ( ! empty( $_REQUEST['pid'] ) ) return $_REQUEST['pid'];

		if ( ! empty( $_REQUEST['jobid'] ) ) return $_REQUEST['jobid'];

		if ( ! empty( $_REQUEST['requestid'] ) ) return $_REQUEST['requestid'];

		if ( wpj_get_payment_info_by_url( 'pid' ) ) return wpj_get_payment_info_by_url( 'pid' );

		if ( ! empty ( $_REQUEST['oid'] ) ) {
			$order = wpj_get_job_order_by_id( $_REQUEST['oid'] );
			if ( ! empty( $order->pid ) ) return $order->pid;
		}

		global $wp_query;

		if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
			$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			if ( ! empty( $order->pid ) ) return $order->pid;
		}

		if ( ! empty( $wp_query->query_vars['jobid'] ) ) {
			$job_post = get_page_by_path( urldecode( $wp_query->query_vars['jobid'] ), OBJECT, 'job' );
			if ( ! empty( $job_post->ID ) ) return $job_post->ID;
		}

		if ( get_the_ID() ) return get_the_ID();

		global $post;

		if ( ! empty( $post->ID ) ) return $post->ID;

		return 0;
	}
}



if ( ! function_exists( 'wpj_create_fake_post' ) ) {
	function wpj_create_fake_post() {
		global $post;

		if ( ! $post ) {
			$post_id              = -99; // negative ID, to avoid clash with a valid post
			$post                 = new stdClass();
			$post->ID             = $post_id;
			$post->post_author    = 1;
			$post->post_date      = current_time( 'mysql' );
			$post->post_date_gmt  = current_time( 'mysql', 1 );
			$post->post_title     = 'Fake post';
			$post->post_content   = 'This is a fake post...';
			$post->post_status    = 'publish';
			$post->comment_status = 'closed';
			$post->ping_status    = 'closed';
			$post->post_name      = 'fake-page-' . rand( 1, 99999 );
			$post->post_type      = 'page';
			$post->filter         = 'raw'; // important

			$wp_post = new WP_Post( $post );
		}
	}
}

if ( ! function_exists( 'wpj_create_auto_draft_post' ) ) {
	function wpj_create_auto_draft_post( $uid = '', $post_type = 'job' ) {
		$post = [];

		$post['post_title']  = 'Auto Draft';
		$post['post_type']   = $post_type;
		$post['post_status'] = 'auto-draft';
		$post['post_author'] = $uid;

		return wp_insert_post( $post, true );
	}
}

if ( ! function_exists( 'wpj_get_auto_draft_post' ) ) {
	function wpj_get_auto_draft_post( $uid = '', $post_type = 'job' ) {
		// check anonymous request auto-draft
		if ( ! is_user_logged_in() && $post_type == 'request' && isset( $_COOKIE['wpj_request_id'] ) && is_int( $_COOKIE['wpj_request_id'] ) ) {
			$id = wpj_get_post( 'ID', ['post_author' => $uid, 'post_status' => 'auto-draft', 'post_type' => $post_type, 'ID' => $_COOKIE['wpj_request_id']], 'var', 'ID DESC' );

			if ( $id ) {
				return $id;
			}
		}

		// check regular auto-draft
		global $pagenow;

		if ( is_user_logged_in() && $pagenow != 'widgets.php' ) {
			$id = wpj_get_post( 'ID', ['post_author' => $uid, 'post_status' => 'auto-draft', 'post_type' => $post_type], 'var', 'ID DESC' );

			if ( $id ) {
				return $id;
			}
		}

		$pid = wpj_create_auto_draft_post( $uid, $post_type );

		if ( ! is_user_logged_in() ) {
			if ( $post_type == 'request' ) {
				setcookie( 'wpj_request_id', $pid, time() + 3600, '/' ); // 1h // 60s * 60m = 3600 sec
			}
		}

		return $pid;
	}
}