<?php
if ( ! function_exists( 'wpj_number_format' ) ) {
	function wpj_number_format( $number, $cents = 1, $currency = '' ) { // cents: 0 = never, 1 = if needed, 2 = always
		if ( isset( $currency ) && $currency != '' ) {
			$number = wpj_get_exchanged_value( $number, wpj_get_site_default_currency(), $currency );

		} elseif ( isset( $_GET['site_currency'] ) ) {
			$number = wpj_get_exchanged_value( $number, wpj_get_site_default_currency(), $_GET['site_currency'] );

		} elseif ( isset( $_COOKIE["site_currency"] ) ) {
			$number = wpj_get_exchanged_value( $number, wpj_get_site_default_currency(), $_COOKIE["site_currency"] );

		}

		$dec_sep = wpj_get_option( 'wpjobster_decimal_sum_separator' );

		if ( empty( $dec_sep ) ) $dec_sep = '.';

		$tho_sep = wpj_get_option( 'wpjobster_thousands_sum_separator' );

		if ( empty( $tho_sep ) ) $tho_sep = ',';

		if ( ! is_numeric( $number ) ) $number = 0;

		if ( ! $number ) { // zero
			$money = ( $cents == 2 ? '0' . $dec_sep . '00' : '0' ); // output zero

		} else { // value
			if ( floor( $number ) == $number ) { // whole number
				$money = number_format( $number, ( $cents == 2 ? 2 : 0 ), $dec_sep, $tho_sep ); // format

			} else { // cents
				$money = number_format( round( $number, 2 ), ( $cents == 0 ? 0 : 2 ), $dec_sep, $tho_sep ); // format

			} // integer or decimal

		} // value

		return $money;
	}
}

// for display, both separators, no exchange currency
if ( ! function_exists( 'wpj_number_format_classic' ) ) {
	function wpj_number_format_classic( $number, $cents = 1 ) { // cents: 0=never, 1=if needed, 2=always
		$dec_sep = wpj_get_option( 'wpjobster_decimal_sum_separator' );

		if ( empty( $dec_sep ) ) $dec_sep = '.';

		$tho_sep = wpj_get_option( 'wpjobster_thousands_sum_separator' );

		if ( empty( $tho_sep ) ) $tho_sep = ',';

		if ( is_numeric( $number ) ) { // a number
			if ( ! $number ) { // zero
				$money = ( $cents == 2 ? '0' . $dec_sep . '00' : '0' ); // output zero

			} else { // value
				if ( floor( $number ) == $number ) { // whole number
					$money = number_format( $number, ( $cents == 2 ? 2 : 0 ), $dec_sep, $tho_sep ); // format

				} else { // cents
					$money = number_format( round( $number, 2 ), ( $cents == 0 ? 0 : 2 ), $dec_sep, $tho_sep ); // format

				} // integer or decimal

			} // value

			return $money;

		} // numeric

		return false;
	}
}

// for database, no thousands separator. eg: 100000.00 no exchange currency
if ( ! function_exists( 'wpj_number_format_special' ) ) {
	function wpj_number_format_special( $number, $cents = 1 ) { // cents: 0=never, 1=if needed, 2=always
		$dec_sep = '.';

		if ( is_numeric( $number ) ) { // a number
			if ( ! $number ) { // zero
				$money = ( $cents == 2 ? '0' . $dec_sep . '00' : '0' ); // output zero

			} else { // value
				if ( floor( $number ) == $number ) { // whole number
					$money = number_format( $number, ( $cents == 2 ? 2 : 0 ), $dec_sep, '' ); // format

				} else { // cents
					$money = number_format( round( $number, 2 ), ( $cents == 0 ? 0 : 2 ), $dec_sep, '' ); // format

				} // integer or decimal

			} // value

			return $money;

		} // numeric

		return false;
	}
}

// for database, no thousands separator. eg: 100000.00 + exchange foreign currency
if ( ! function_exists( 'wpj_number_format_special_exchange' ) ) {
	function wpj_number_format_special_exchange( $number, $cents = 1, $currency = '' ) { // cents: 0=never, 1=if needed, 2=always
		if ( isset( $currency ) && $currency != '' ) {
			$number = wpj_get_exchanged_value( $number, wpj_get_site_default_currency(), $currency );

		} elseif ( isset( $_GET['site_currency'] ) ) {
			$number = wpj_get_exchanged_value( $number, wpj_get_site_default_currency(), $_GET['site_currency'] );

		} elseif ( isset( $_COOKIE["site_currency"] ) ) {
			$number = wpj_get_exchanged_value( $number, wpj_get_site_default_currency(), $_COOKIE["site_currency"] );

		}

		$dec_sep = '.';

		if ( is_numeric( $number ) ) { // a number
			if ( ! $number ) { // zero
				$money = ( $cents == 2 ? '0' . $dec_sep . '00' : '0' ); // output zero

			} else { // value
				if ( floor( $number ) == $number ) { // whole number
					$money = number_format( $number, ( $cents == 2 ? 2 : 0 ), $dec_sep, '' ); // format

				} else { // cents
					$money = number_format( round( $number, 2 ), ( $cents == 0 ? 0 : 2 ), $dec_sep, '' ); // format

				} // integer or decimal

			} // value

			return $money;

		} // numeric

		return false;
	}
}

// does nothing else than the regular function
if ( ! function_exists( 'wpj_number_format_mm' ) ) {
	function wpj_number_format_mm( $number, $cents = 1 ) {
		return wpj_number_format( $number, $cents );
	}
}

if ( ! function_exists( 'wpj_show_price_in_front' ) ) {
	function wpj_show_price_in_front() {
		$opt = wpj_get_option( 'wpjobster_currency_position' );

		if ( $opt == 'front' ) return true;

		return false;
	}
}

if ( ! function_exists( 'wpj_show_price' ) ) {
	function wpj_show_price( $price = '', $cents = 2, $use_free = false ) {
		if ( ! $price ) $price = '0';

		$decimals = wpj_get_option( 'wpjobster_decimals' );

		if ( $decimals == 'ifneeded' ) {
			$cents = 1;

		} elseif ( $decimals == 'never' ) {
			$cents = 0;

		}

		$currency_position      = wpj_get_option( 'wpjobster_currency_position' );
		$currency_symbol_space  = wpj_bool_option( 'wpjobster_currency_symbol_space' );
		$replace_zero_with_free = wpj_bool_option( 'wpjobster_replace_zero_with_free' );

		$space    = ( $currency_symbol_space ) ? " " : $space = "";
		$currency = wpj_get_currency_symbol_by_name( wpj_get_site_currency() );

		if ( $price == 0 && $use_free && $replace_zero_with_free ) {
			return __( 'Free', 'wpjobster' );

		} elseif ( $currency_position == 'front' ) {
			return $currency . $space . wpj_number_format( $price, $cents );

		} else {
			return wpj_number_format( $price, $cents ) . $space . $currency;

		}
	}
}

// price in default currency + symbol
if ( ! function_exists( 'wpj_show_price_classic' ) ) {
	function wpj_show_price_classic( $price, $cents = 2 ) {
		$decimals = wpj_get_option( 'wpjobster_decimals' );

		if ( $decimals == 'ifneeded' ) {
			$cents = 1;

		} elseif ( $decimals == 'never' ) {
			$cents = 0;

		}

		$currency_position     = wpj_get_option( 'wpjobster_currency_position' );
		$currency_symbol_space = wpj_get_option( 'wpjobster_currency_symbol_space' );

		$space    = $currency_symbol_space == 'no' ? "" : " ";
		$currency = wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() );

		if ( $currency_position == 'front' )
			return apply_filters( 'wpj_price_classic_filter', $currency .  $space . wpj_number_format_classic( $price, $cents ), $price, $cents );

		return apply_filters( 'wpj_price_classic_filter', wpj_number_format_classic( $price, $cents ) .  $space . $currency, $price, $cents );
	}
}

// price exactly as we say
if ( ! function_exists( 'wpj_show_price_precise' ) ) {
	function wpj_show_price_precise( $price, $cents = 2, $currency = '' ) {
		$decimals = wpj_get_option( 'wpjobster_decimals' );

		if ( $decimals == 'ifneeded' ) {
			$cents = 1;

		} elseif ( $decimals == 'never' ) {
			$cents = 0;

		}

		$currency_position     = wpj_get_option( 'wpjobster_currency_position' );
		$currency_symbol_space = wpj_get_option( 'wpjobster_currency_symbol_space' );
		$space                 = $currency_symbol_space == 'no' ? "" : " ";

		if ( ! $currency ) { $currency = wpj_get_site_currency(); }

		$currency = wpj_get_currency_symbol_by_name( $currency );

		if ( $currency_position == 'front' ) {
			return $currency .  $space . wpj_number_format_classic( $price, $cents );
		}

		return wpj_number_format_classic( $price, $cents ) .  $space . $currency;
	}
}

if ( ! function_exists( 'wpj_deciphere_amount_classic' ) ) {
	function wpj_deciphere_amount_classic( $pipeseparatedprice, $cents = 2 ) {
		$pipeseparatedprice = str_replace( ',', '.', $pipeseparatedprice );
		$amn = explode( '|', $pipeseparatedprice );

		$decimals = wpj_get_option( 'wpjobster_decimals' );

		if ( $decimals == 'ifneeded' ) {
			$cents = 1;

		} elseif ( $decimals == 'never' ) {
			$cents = 0;

		}

		$currency_position     = wpj_get_option( 'wpjobster_currency_position' );
		$currency_symbol_space = wpj_get_option( 'wpjobster_currency_symbol_space' );

		$space    = $currency_symbol_space == 'no' ? "" : " ";
		$currency = isset( $amn[0] ) ? wpj_get_currency_symbol_by_name( $amn[0] ) : wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() );

		$amount = isset( $amn[1] ) ? $amn[1] : 0;

		if ( $currency_position == 'front' ) {
			return $currency . $space . wpj_number_format_classic( $amount, $cents );
		}

		return wpj_number_format_classic( $amount, $cents ) . $space . $currency;
	}
}

if ( ! function_exists( 'wpj_get_job_price_types' ) ) {
	function wpj_get_job_price_types() {
		return apply_filters( 'wpj_job_price_type_filter', ['fixed', 'hourly', 'daily', 'weekly', 'monthly', 'package', 'custom'] );
	}
}

if ( ! function_exists( 'wpj_get_job_no_days_price_types' ) ) {
	function wpj_get_job_no_days_price_types() {
		return apply_filters( 'wpj_job_no_days_price_type_filter', ['package'] );
	}
}

if ( ! function_exists( 'wpj_is_job_price_type_enabled' ) ) {
	function wpj_is_job_price_type_enabled( $price_type = '' ) {
		$wpjobster_packages = wpj_get_option( 'wpjobster_packages_enabled' );
		$lvl_sts            = wpj_get_user_feature_value( 'packages', 'packages', 'no', get_current_user_id() );

		$packages = $wpjobster_packages == 'yes' && $lvl_sts == 'yes' ? 'yes' : 'no';

		if (
			( wpj_get_option( 'wpjobster_enable_' . $price_type . '_rate' ) == 'yes' && $price_type != 'package' )
			|| ( $price_type == 'package' && $packages == 'yes' )
		) {
			$price_type_enabled = true;

		} else {
			$price_type_enabled = false;

		}

		return apply_filters( 'wpj_job_price_type_enabled_filter', $price_type_enabled, $price_type );
	}
}

if ( ! function_exists( 'wpj_exist_job_price_type_enabled' ) ) {
	function wpj_exist_job_price_type_enabled() {
		$price_type_arr = wpj_get_job_price_types();

		$wpjobster_packages = wpj_get_option( 'wpjobster_packages_enabled' );
		$lvl_sts            = wpj_get_user_feature_value( 'packages', 'packages', 'no', get_current_user_id() );

		$packages = $wpjobster_packages == 'yes' && $lvl_sts == 'yes' ? 'yes' : 'no';

		$show_price_type = false;

		foreach ( $price_type_arr as $key => $price_type ) {
			if (
				( wpj_get_option( 'wpjobster_enable_' . $price_type . '_rate' ) == 'yes' && $price_type != 'package' )
				|| ( $price_type == 'package' && $packages == 'yes' )
			) {
				$show_price_type = true;

			}
		}

		return apply_filters( 'wpj_exist_job_price_type_enabled_filter', $show_price_type );
	}
}

if ( ! function_exists( 'wpj_is_job_price_type_custom_only_enabled' ) ) {
	function wpj_is_job_price_type_custom_only_enabled() {
		$price_type_arr = wpj_get_job_price_types();

		$wpjobster_packages = wpj_get_option( 'wpjobster_packages_enabled' );
		$lvl_sts            = wpj_get_user_feature_value( 'packages', 'packages', 'no', get_current_user_id() );

		$packages = $wpjobster_packages == 'yes' && $lvl_sts == 'yes' ? 'yes' : 'no';

		$custom_rate_only = true;

		foreach ( $price_type_arr as $key => $price_type ) {
			if ( $price_type != 'package' && $price_type != 'custom'
				&& wpj_get_option( 'wpjobster_enable_' . $price_type . '_rate' ) == 'yes'
			) {
				$custom_rate_only = false;

			}
		}

		if ( $custom_rate_only && $packages == 'yes' ) {
			$custom_rate_only = false;

		}

		if ( $custom_rate_only && wpj_get_option( 'wpjobster_enable_custom_rate' ) == 'yes' ) {
			$custom_rate_only = true;

		} else {
			$custom_rate_only = false;

		}

		return apply_filters( 'wpj_exist_job_price_type_custom_only_enabled_filter', $custom_rate_only );
	}
}