<?php
if ( ! function_exists( 'wpj_save_quick_response' ) ) {
	function wpj_save_quick_response( $uid = '', $id = '', $name = '', $content = '' ) {
		$uid = WPJ_Form::post( 'uid', $uid );

		if ( ! $uid ) $uid = get_current_user_id();

		$id      = WPJ_Form::post( 'id', $id );
		$name    = WPJ_Form::post( 'name', $name );
		$content = WPJ_Form::post( 'content', $content );

		if ( $id && $name && $content ) {
			$quick_responses = get_user_meta( $uid, 'quick_responses', true );

			if ( ! $quick_responses || ! is_array( $quick_responses ) ) $quick_responses = [];

			$quick_responses[$id] = ['name' => $name, 'content' => $content ];

			update_user_meta( $uid, 'quick_responses', $quick_responses );
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_delete_quick_response' ) ) {
	function wpj_delete_quick_response( $uid = '', $id = '' ) {
		$uid = WPJ_Form::post( 'uid', $uid );

		if ( ! $uid ) $uid = get_current_user_id();

		$id = WPJ_Form::post( 'id', $id );

		if ( $id ) {
			$quick_responses = get_user_meta( $uid, 'quick_responses', true );

			unset( $quick_responses[$id] );

			update_user_meta( $uid, 'quick_responses', $quick_responses );
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_delete_all_quick_responses' ) ) {
	function wpj_delete_all_quick_responses( $uid = '' ) {
		$uid = WPJ_Form::post( 'uid', $uid );

		if ( ! $uid ) $uid = get_current_user_id();

		delete_user_meta( $uid, 'quick_responses' );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}