<?php
if ( ! function_exists( 'wpj_create_request_post_id' ) ) {
	function wpj_create_request_post_id() {
		// Init new post
		if ( ! isset( $_GET['requestid'] ) ) {
			$pid = wpj_get_auto_draft_post( get_current_user_id(), 'request' );

			$args = ['requestid' => $pid];

			if ( ! empty( $_GET['category'] ) ) {
				$args['category'] = $_GET['category'];
			}

			wp_redirect(
				add_query_arg(
					$args,
					get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) )
				)
			);

			exit;
		}

		// Double check that we are on the right page
		$pid = WPJ_Form::get( 'requestid' );

		if ( is_user_logged_in() ) {
			if ( WPJ_Form::get( 'action' ) != 'edit-request' ) {
				$last_draft = wpj_get_post( 'ID', ['post_type' => 'request', 'post_status' => 'auto-draft', 'post_author' => get_current_user_id()], 'row', 'ID DESC' );

				if ( ( isset( $last_draft->ID ) && $last_draft->ID > $pid ) || get_current_user_id() != get_post_field( 'post_author', $pid ) ) {
					$args = ['requestid' => $last_draft->ID];

					if ( ! empty( $_GET['category'] ) ) {
						$args['category'] = $_GET['category'];
					}

					wp_redirect(
						add_query_arg(
							$args,
							get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) )
						)
					);

					exit;
				}
			}

		} else {
			if ( isset( $_COOKIE['wpj_request_id'] ) && $pid != $_COOKIE['wpj_request_id'] ) {
				wp_redirect( add_query_arg( 'requestid', $_COOKIE['wpj_request_id'], get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) ) ) );

				exit;

			} elseif ( ! isset( $_COOKIE['wpj_request_id'] ) ) {
				wp_redirect( get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) ) );

				exit;
			}

		}
	}
}

if ( ! function_exists( 'wpj_activate_request' ) ) {
	function wpj_activate_request( $pid = '', $reason = '' ) {
		if ( is_user_logged_in() ) {
			$pid = WPJ_Form::post( 'post_id', $pid );

			if ( ! $pid ) $pid = wpj_get_post_id();

			$post = get_post( $pid );

			if ( $post->post_author == get_current_user_id() || current_user_can( 'administrator' ) ) {
				update_post_meta( $pid, 'active', 1 );

				if ( $reason )
					update_post_meta( $pid, 'activate_reason', $reason );

				delete_post_meta( $pid, 'deactivation_reason' );

				if ( wpj_is_ajax_call() ) echo 1;

			} elseif ( wpj_is_ajax_call() ) echo 'not_your_post';

		} elseif ( wpj_is_ajax_call() ) echo 'not_logged_in';

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_activate_all_requests' ) ) {
	function wpj_activate_all_requests( $user_id = '', $reason = '' ) {
		$reason  = isset( $_POST['reason'] ) ? $_POST['reason'] : $reason;
		$user_id = isset( $_POST['user_id'] ) ? $_POST['user_id'] : $user_id;

		if ( ! $user_id ) $user_id = get_current_user_id();

		$args = [
			'post_type'      => 'request',
			'posts_per_page' => -1,
			'post_status'    => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash'],
			'meta_query'     => [
				[
					'key'     => 'active',
					'value'   => '0',
					'compare' => '=',
				],
			],
		];

		if ( $user_id && $user_id != 'all' ) $args['author'] = $user_id;

		$posts = get_posts( $args );

		if ( $posts && is_user_logged_in() && ( get_current_user_id() == $user_id || current_user_can( 'administrator' ) ) ) {
			foreach ( $posts as $key ) {
				update_post_meta( $key->ID, 'active', '1' );

				if ( $reason )
					update_post_meta( $key->ID, 'activate_reason', $reason );

				delete_post_meta( $key->ID, 'deactivation_reason' );
			}
		}
	}
}

if ( ! function_exists( 'wpj_deactivate_request' ) ) {
	function wpj_deactivate_request( $pid = '', $reason = '' ) {
		if ( is_user_logged_in() ) {
			$pid = WPJ_Form::post( 'post_id', $pid );

			if ( ! $pid ) $pid = wpj_get_post_id();

			$post = get_post( $pid );

			if ( $post->post_author == get_current_user_id() || current_user_can( 'administrator' ) ) {
				update_post_meta( $pid, 'active', 0 );

				if ( $reason )
					update_post_meta( $pid, 'deactivation_reason', $reason );

				delete_post_meta( $pid, 'activate_reason' );

				if ( wpj_is_ajax_call() ) echo 1;

			} elseif ( wpj_is_ajax_call() ) echo 'not_your_post';

		} elseif ( wpj_is_ajax_call() ) echo 'not_logged_in';

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_deactivate_all_requests' ) ) {
	function wpj_deactivate_all_requests( $user_id = '', $reason = '' ) {
		$reason  = isset( $_POST['reason'] ) ? $_POST['reason'] : $reason;
		$user_id = isset( $_POST['user_id'] ) ? $_POST['user_id'] : $user_id;

		if ( ! $user_id ) { $user_id = get_current_user_id(); }

		$args = [
			'post_type'      => 'request',
			'posts_per_page' => -1,
			'post_status'    => ['publish', 'pending', 'draft', 'auto-draft', 'future', 'private', 'inherit', 'trash'],
			'meta_query'     => [
				[
					'key'     => 'active',
					'value'   => '1',
					'compare' => '=',
				],
			],
		];

		if ( $user_id && $user_id != 'all' ) $args['author'] = $user_id;

		$posts = get_posts( $args );

		if ( $posts && is_user_logged_in() && ( get_current_user_id() == $user_id || current_user_can( 'administrator' ) ) ) {
			foreach ( $posts as $key ) {
				update_post_meta( $key->ID, 'active', '0' );

				if ( $reason )
					update_post_meta( $key->ID, 'deactivation_reason', $reason );

				delete_post_meta( $key->ID, 'activate_reason' );
			}
		}
	}
}

if ( ! function_exists( 'wpj_delete_request' ) ) {
	function wpj_delete_request( $pid = '' ) {
		if ( is_user_logged_in() ) {
			$pid = WPJ_Form::post( 'post_id', $pid );

			if ( ! $pid ) $pid = wpj_get_post_id();

			$post = get_post( $pid );

			if ( $post->post_author == get_current_user_id() ) {
				wp_trash_post( $post->ID );

				if ( wpj_is_ajax_call() ) echo 1;

			} elseif ( wpj_is_ajax_call() ) echo 'not_your_post';

		} elseif ( wpj_is_ajax_call() ) echo 'not_logged_in';

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_delete_all_requests' ) ) {
	function wpj_delete_all_requests( $user_id ) {
		$user_id = isset( $_POST['user_id'] ) ? $_POST['user_id'] : $user_id;

		if ( ! $user_id ) { $user_id = get_current_user_id(); }

		$args = [
			'post_type'      => 'request',
			'posts_per_page' => -1,
			'post_status'    => ['draft', 'publish', 'pending'],
			'author'         => $user_id
		];

		$posts = get_posts( $args );

		if ( $posts && is_user_logged_in() && get_current_user_id() == $user_id ) {
			foreach ( $posts as $post ) {
				if ( $post->post_author == get_current_user_id() ) {
					wp_trash_post( $post->ID );
				}
			}
		}
	}
}

if ( ! function_exists( 'wpj_get_user_requests' ) ) {
	function wpj_get_user_requests( $uid = '', $order_status = 'active', $return = 'count' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		if ( $order_status ) {
			if ( $order_status == 'active' ) {
				$args = [
					'posts_per_page' => '-1',
					'post_type'      => 'request',
					'post_status'    => ['publish'],
					'meta_query'     => [
						[
							'key'     => 'active',
							'value'   => '1',
							'compare' => '='
						]
					]
				];

			} elseif ( $order_status == 'inactive' ) {
				$args = [
					'posts_per_page' => '-1',
					'post_type'      => 'request',
					'post_status'    => ['publish'],
					'meta_query'     => [
						[
							'key'     => 'active',
							'value'   => '0',
							'compare' => '='
						]
					]
				];

			} elseif ( $order_status == 'rejected' ) {
				$args = [
					'posts_per_page' => '-1',
					'post_type'      => 'request',
					'post_status'    => ['pending']
				];

			} elseif ( $order_status == 'in-review' ) {
				$args = [
					'posts_per_page' => '-1',
					'post_type'      => 'request',
					'post_status'    => ['draft']
				];

			} elseif ( $order_status == 'assigned' ) {
				$args = [
					'posts_per_page' => '-1',
					'post_type'      => 'request',
					'post_status'    => ['publish'],
					'meta_query'     => [
						'relation' => 'AND',
						[
							'key'     => 'assigned',
							'value'   => '1',
							'compare' => '='
						]
					]
				];

			} elseif ( $order_status == 'completed' ) {
				$args = [
					'posts_per_page' => '-1',
					'post_type'      => 'request',
					'post_status'    => ['publish'],
					'meta_query'     => [
						[
							'key'     => 'completed',
							'value'   => '1',
							'compare' => '='
						]
					]
				];

			}

			if ( $uid ) $args['author'] = $uid;

			if ( isset( $args ) ) {
				$result = new WP_Query( $args );

				if ( $return == 'query' ) {
					return apply_filters( 'wpj_user_requests_' . $order_status . '_query_filter', $args );
				}

				if ( $return == 'result' ) {
					return apply_filters( 'wpj_user_requests_' . $order_status . '_result_filter', $result );
				}

				if ( $return == 'count' ) {
					return apply_filters( 'wpj_user_requests_' . $order_status . '_count_filter', $result->post_count );
				}
			}
		}

		return 0;
	}
}

if ( ! function_exists( 'wpj_get_total_posted_requests' ) ) {
	function wpj_get_total_posted_requests() {
		return wp_count_posts( 'request' )->publish;
	}
}

if ( ! function_exists( 'wpj_get_request_rejected_input' ) ) {
	function wpj_get_request_rejected_input( $input = '', $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		${ 'rejected_' . $input } = get_post_meta( $pid, "req_rejected_" . $input, true );

		return get_post_status( $pid ) == 'pending' && ${ 'rejected_' . $input } == 1 ? 'rejected-input' : '';
	}
}