<?php
if ( ! function_exists( 'wpj_get_main_search_url' ) ) {
	function wpj_get_main_search_url() {
		$default_search = wpj_get_option( 'wpjobster_default_advanced_search' );

		if ( $default_search == 'users' )
			$url_for_search = get_permalink( wpj_get_option( 'wpjobster_search_user_page_id' ) );

		elseif ( $default_search == 'requests' )
			$url_for_search = get_permalink( wpj_get_option( 'wpjobster_advanced_search_request_page_id' ) );

		else
			$url_for_search = get_permalink( wpj_get_option( 'wpjobster_advanced_search_id' ) );

		return $url_for_search;
	}
}

if ( ! function_exists( 'wpj_search_autocomplete_ajax' ) ) {
	function wpj_search_autocomplete_ajax() {
		$input = wpj_validate_input_content( $_POST['input'] );
		$input = strtolower( $input );
		$input = esc_sql( $input );

		$job_array     = [];
		$request_array = [];
		$user_array    = [];
		$company_array = [];

		if ( $input != '' && $input != ' ' ) {
			// search jobs
			$job_query = wpj_get_jobs_by_title_or_content( $input );

			foreach ( $job_query as $job ) {
				preg_match( "/\b(\w*" . $input . "\w*)\b/", strtolower( $job->post_title ), $matches );
				preg_match( "/\b(\w*" . $input . "\w*)\b/", strtolower( $job->post_content ), $matches2 );

				if ( isset( $matches[0] ) && ! in_array( $matches[0], $job_array ) ) {
					$job_array[] = $matches[0];

					if ( count( $job_array ) >= 6 ) {
						break;
					}
				}

				if ( isset( $matches2[0] ) && ! in_array( $matches2[0], $job_array ) ) {
					$job_array[] = $matches2[0];

					if ( count( $job_array ) >= 6 ) {
						break;
					}
				}
			}

			// search requests
			$request_query = wpj_get_requests_by_title_or_content( $input );

			foreach ( $request_query as $request ) {
				preg_match( "/\b(\w*" . $input . "\w*)\b/", strtolower( $request->post_title ), $matches );
				preg_match( "/\b(\w*" . $input . "\w*)\b/", strtolower( $request->post_content ), $matches2 );

				if ( isset( $matches[0] ) && ! in_array( $matches[0], $request_array ) ) {
					$request_array[] = $matches[0];

					if ( count( $request_array ) >= 6 ) {
						break;
					}
				}

				if ( isset( $matches2[0] ) && ! in_array( $matches2[0], $request_array ) ) {
					$request_array[] = $matches2[0];

					if ( count( $request_array ) >= 6 ) {
						break;
					}
				}
			}

			// search users
			$users_query = wpj_get_users_by_name_or_description( $input );

			foreach ( $users_query as $user ) {
				$user_array[] = $user->user_login;

				// add company if enabled, ready to display
				if ( wpj_bool_option( 'wpjobster_enable_user_company' ) ) {
					$user_company = get_user_meta( $user->ID, 'user_company', true );

					if ( $user_company ) {
						$company_array[] = ' <span class="user-company">(' . $user_company . ')</span>';

					} else {
						$company_array[] = '';

					}
				}

				if ( count( $user_array ) >= 3 ) {
					break;
				}
			}
		}

		// return
		$return = [];

		$return['jobs']      = $job_array;
		$return['requests']  = $request_array;
		$return['users']     = $user_array;
		$return['companies'] = $company_array;

		echo json_encode( $return );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_autosuggest_it' ) ) {
	function wpj_autosuggest_it() {
		include_once get_template_directory() . '/vendor/stem.php';
		include_once get_template_directory() . '/vendor/cleaner.php';

		$string = $_POST['queryString'];

		$stemmer        = new Stemmer;
		$stemmed_string = $stemmer->stem( $string );

		$clean_string   = new jSearchString();
		$stemmed_string = $clean_string->parseString ( $stemmed_string );

		$new_string = '';

		foreach ( array_unique( explode( " ", $stemmed_string ) ) as $array => $value ) {
			if ( strlen( $value ) >= 1 ) {
				$new_string .= '' . $value . ' ';
			}
		}

		$new_string = htmlspecialchars( $_POST['queryString'] );

		if ( strlen ( $new_string ) > 0 ) {
			$rows = wpj_get_jobs_keywords_occurances( $new_string );

			if ( count( $rows ) > 0 ) {
				foreach ( $rows as $row ) {
					echo '<ul id="sk_auto_suggest" class="reset">';
						echo '<li onClick="window.location=\'' . get_permalink( $row['ID'] ) . '\';">' . wpj_wrap_title( $row['post_title'], $row['ID'] ) . '</li>';
					echo '</ul>';
				}

			} else {
				echo '<ul>';
					echo '<li onClick="fill(\'' . $new_string . '\');">' . __( 'No results found', 'wpjobster' ) . '</li>';
				echo '</ul>';

			}
		}
	}
}