<?php
if ( ! function_exists( 'wpj_fnc_to_shortcode' ) ) {
	function wpj_fnc_to_shortcode( $atts = '', $function_name = '', $args = [] ) {
		ob_start();

		$array_params = isset( $args['args'] ); // functions with array params

		if ( $array_params ) $args = $args['args'];

		$args = wp_parse_args( $atts, $args );

		if ( $array_params ) $args = [$args];

		if ( function_exists( $function_name ) ) {
			if ( $args )
				call_user_func_array( $function_name, $args );
			else
				call_user_func( $function_name );
		}

		return ob_get_clean();
	}
}

if ( ! function_exists( 'wpj_get_shortcode_args' ) ) {
	function wpj_get_shortcode_args( $atts = '' ) {
		if ( wpj_is_page( 'wpjobster_post_new_page_id' ) || ( isset( $atts['parent'] ) && $atts['parent'] == 'job' ) ) {
			$atts['parent']  = 'job';
			$atts['item_id'] = WPJ_Form::get( 'jobid' );

			if ( isset( $atts['value'] ) && $atts['value'] )
				$value = $atts['value'];

			else {
				$value = empty( $_POST[$atts['name']] ) ? get_post_meta( $atts['item_id'], $atts['name'], true ) : $_POST[$atts['name']];

				$value_decoded = wpj_json_decode( $value, true );

				if ( json_last_error() === JSON_ERROR_NONE ) $value = $value_decoded;
			}

			$atts['value'] = is_array( $value ) ? $value : wpj_stripslashes( wpj_validate_input_content( $value ) );

		} elseif ( wpj_is_page( 'wpjobster_new_request_page_id' ) || ( isset( $atts['parent'] ) && $atts['parent'] == 'request' ) ) {
			$atts['parent']  = 'request';
			$atts['item_id'] = WPJ_Form::get( 'requestid' );

			if ( isset( $atts['value'] ) && $atts['value'] )
				$value = $atts['value'];

			else {
				$value = empty( $_POST[$atts['name']] ) ? get_post_meta( $atts['item_id'], $atts['name'], true ) : $_POST[$atts['name']];

				$value_decoded = wpj_json_decode( $value, true );

				if ( json_last_error() === JSON_ERROR_NONE ) $value = $value_decoded;
			}

			$atts['value'] = is_array( $value ) ? $value : wpj_stripslashes( wpj_validate_input_content( $value ) );

		} else {
			$atts['parent']  = 'up';
			$atts['item_id'] = get_current_user_id();

			if ( isset( $atts['value'] ) && $atts['value'] )
				$value = $atts['value'];

			else {
				$value = empty( $_POST[$atts['name']] ) ? wpj_user( $atts['item_id'], $atts['name'] ) : $_POST[$atts['name']];

				if ( ! is_array( $value ) ) {
					$value_decoded = wpj_json_decode( $value, true );

					if ( json_last_error() === JSON_ERROR_NONE ) $value = $value_decoded;
				}
			}

			$atts['value'] = is_array( $value ) ? $value : wpj_stripslashes( wpj_validate_input_content( $value ) );
		}

		return $atts;
	}
}

if ( ! function_exists( 'wpj_get_email_shortcode_attr_value' ) ) {
	function wpj_get_email_shortcode_attr_value( $shortcode = [], $param = '' ) {
		if ( isset( $shortcode[1] ) ) {
			$shortcode_atts = explode( ' ', $shortcode[1] );

			if ( $shortcode_atts ) {
				foreach ( $shortcode_atts as $key => $value ) {
					if ( strpos( $value, $param ) !== false ) {
						$val_arr = explode( '=', $value );

						return ! empty( $val_arr[1] ) ? $val_arr[1] : false;
					}
				}
			}

		}

		return false;
	}
}