<?php
if ( ! function_exists( 'wpj_notify_user_translated' ) ) {
	function wpj_notify_user_translated( $reason = '', $receiver = '', $params = [], $params_multiple = [], $notify_type = 'both' ) {
		if ( ! $reason || ! $receiver ) return false;

		$receiver_data = get_userdata( $receiver );
		$user_data     = get_userdata( get_current_user_id() );

		// GLOBAL PARAMS
		$global_params_arr = [
			'##your_site_name##' => get_bloginfo( 'name' ),
			'##your_site_url##'  => get_bloginfo( 'url' )
		];

		if ( ! isset( $params['##receiver_username##'] ) ) {
			$global_params_arr['##receiver_username##'] = ! empty( $receiver_data->ID ) ? wpj_get_user_display_type( $receiver_data->ID ) : $receiver;
		}

		if ( ! isset( $params['##sender_username##'] ) ) {
			$global_params_arr['##sender_username##'] = ! empty( $user_data->ID ) ? wpj_get_user_display_type( $user_data->ID ) : get_current_user_id();
		}

		if ( ! isset( $params['##my_account_url##'] ) ) {
			$global_params_arr['##my_account_url##'] = wpj_get_my_account_link();
		}

		$global_params = apply_filters( 'wpj_user_notification_global_params', $global_params_arr );

		$params = $params ? array_merge( $params, $global_params ) : $global_params;

		// EMAIL
		$email_enable      = wpj_get_option( 'uz_email_' . $reason . '_enable' );
		$email_enable_user = get_user_meta( $receiver, 'uz_email_' . $reason . '_enable', true );

		$email_content = wpj_get_email_content( $reason, $receiver, $params, $params_multiple );

		// SMS
		$sms_enable      = wpj_get_option( 'uz_sms_' . $reason . '_enable' );
		$sms_enable_user = get_user_meta( $receiver, 'uz_sms_' . $reason . '_enable', true );

		$sms_content = wpj_get_sms_content( $reason, $receiver, $params, $params_multiple );

		// RECEIVER
		if ( $receiver == 'admin' ) {
			$to = get_bloginfo( 'admin_email' );

		} else {
			$to = is_object( $receiver_data ) && isset( $receiver_data->user_email ) ? $receiver_data->user_email : '';

		}

		if ( ! $to ) return false;

		// SEND
		if ( $notify_type == 'email' && $email_enable != 'no' && $email_enable_user != 'no' ) {
			if ( $email_content['subject'] && $email_content['message'] ) {
				wpj_send_email( $to, $email_content['subject'], $email_content['message'] );
			}

		} elseif ( $notify_type == 'sms' && $sms_enable != 'no' && $sms_enable_user != 'no' ) {
			if ( $sms_content ) {
				wpj_send_sms( $receiver, $sms_content );
			}

		} else {
			if ( $email_enable != 'no' && $email_enable_user != 'no' ) {
				if ( $email_content['subject'] && $email_content['message'] ) {
					wpj_send_email( $to, $email_content['subject'], $email_content['message'] );
				}
			}

			if ( $sms_enable != 'no' && $sms_enable_user != 'no' ) {
				if ( $sms_content ) {
					wpj_send_sms( $receiver, $sms_content );
				}
			}

		}

		return true;
	}
}

if ( ! function_exists( 'wpj_get_email_content' ) ) {
	function wpj_get_email_content( $reason = '', $receiver = '', $params = '', $params_multiple = '' ) {
		$default_lang = trim( wpj_get_option( 'wpjobster_language_1' ) );
		$lang = wpj_get_language_by_uid( $receiver, $default_lang );

		$email_subject = wpj_get_option( 'uz_email_' . $reason . '_' . $lang . '_subject' );
		$email_message = wpj_get_option( 'uz_email_' . $reason . '_' . $lang . '_message' );

		if ( ! $email_subject || ! $email_message ) {
			$email_subject = wpj_get_option( 'uz_email_' . $reason . '_' . $default_lang . '_subject' );
			$email_message = wpj_get_option( 'uz_email_' . $reason . '_' . $default_lang . '_message' );

			if ( ! $email_subject || ! $email_message ) return false;
		}

		$email_subject = wpj_replace_coded_word_with_value( array_keys( $params ), array_values( $params ), $email_subject );
		$email_message = wpj_replace_coded_word_with_value( array_keys( $params ), array_values( $params ), $email_message );

		if ( $params_multiple ) { // list shortcode
			$email_message = wpj_get_message_with_params_multiple( $email_message, $params_multiple );
		}

		return [
			'subject' => apply_filters( 'wpj_email_subject_filter', wpj_stripslashes( $email_subject ), $receiver, $reason, $params, $params_multiple ),
			'message' => apply_filters( 'wpj_email_message_filter', wpj_stripslashes( $email_message ), $receiver, $reason, $params, $params_multiple )
		];
	}
}

if ( ! function_exists( 'wpj_get_sms_content' ) ) {
	function wpj_get_sms_content( $reason = '', $receiver = '', $params = '', $params_multiple = '' ) {
		$default_lang = trim( wpj_get_option( 'wpjobster_language_1' ) );
		$lang = wpj_get_language_by_uid( $receiver, $default_lang );

		$sms_message = wpj_get_option( 'uz_sms_' . $reason . '_' . $lang . '_message' );

		if ( ! $sms_message ) {
			$sms_message = wpj_get_option( 'uz_sms_' . $reason . '_' . $default_lang . '_message' );

			if ( ! $sms_message) { return false; }
		}

		$sms_message = wpj_replace_coded_word_with_value( array_keys( $params ), array_values( $params ), $sms_message );

		if ( $params_multiple ) { // list shortcode
			$sms_message = wpj_get_message_with_params_multiple( $sms_message, $params_multiple );
		}

		return apply_filters( 'wpj_sms_message_filter', wpj_stripslashes( $sms_message ), $reason, $receiver, $params, $params_multiple );

	}
}

if ( ! function_exists( 'wpj_send_email' ) ) {
	function wpj_send_email( $recipients, $subject = '', $message = '' ) {
		$wpjobster_email_addr_from = wpj_get_option( 'wpjobster_email_addr_from' );
		$wpjobster_email_name_from = wpj_get_option( 'wpjobster_email_name_from' );

		if ( empty( $wpjobster_email_name_from ) ) {
			$wpjobster_email_name_from = get_bloginfo( 'name' );
		}

		if ( empty( $wpjobster_email_addr_from ) ) {
			$wpjobster_email_addr_from = get_bloginfo( 'admin_email' );
		}

		$headers = 'From: ' . $wpjobster_email_name_from . ' <' . $wpjobster_email_addr_from . '>' . PHP_EOL;

		if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
		}

		if ( wpj_get_option( 'wpjobster_allow_html_emails' ) == 'yes' && ! is_plugin_active( 'wp-better-emails/wpbe.php' ) ) {
			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: " . get_bloginfo( 'html_type' ) . "; charset=\"" . get_bloginfo( 'charset' ) . "\"\r\n";

			$mailtext = "<html><head><title>" . $subject . "</title></head><body>" . $message . "</body></html>";

			return wp_mail( $recipients, $subject, nl2br( $mailtext ), $headers );

		} else {
			$headers .= "MIME-Version: 1.0\n";
			$headers .= "Content-Type: text/plain; charset=\"" . get_bloginfo( 'charset' ) . "\"\n";

			$mailtext = wpj_get_option( 'wpjobster_allow_html_emails' ) == 'yes' ? nl2br( $message ) : strip_tags( $message );

			return wp_mail( $recipients, $subject, $mailtext, $headers );

		}
	}
}

if ( ! function_exists( 'wpj_send_sms' ) ) {
	function wpj_send_sms( $sms_receiver, $sms_message ) {
		if ( ! wpj_is_sms_allowed() ) return false;

		// general options
		$sms_gateway = wpj_get_option( 'wpjobster_sms_gateways_enable' );

		$admin_number = wpj_stripslashes( wpj_get_option( 'wpjobster_sms_admin_numb_from' ) );

		$user_number = get_user_meta( $sms_receiver, 'cell_number', true );
		$user_number = wpj_format_phone_number( $sms_receiver, $user_number );

		$receiver_number = $sms_receiver == 'admin' ? $admin_number : $user_number;

		$response = '';

		// gateway switch
		switch ( $sms_gateway ) {
			case 'twilio':
				$sid   = wpj_get_option( "wpjobster_theme_accountsid" );
				$token = wpj_get_option( "wpjobster_theme_authtoken" );

				if ( $sid && $token ) {
					include_once get_template_directory() . '/vendor/twilio/autoload.php';

					$client = new Twilio\Rest\Client( $sid, $token );

					$sender_number = wpj_stripslashes( wpj_get_option( 'wpjobster_sms_numb_twilio_from' ) );

					if ( $receiver_number && $sender_number ) {
						if ( wpj_get_option( 'wpjobster_twilio_sms_enabled' ) != 'no' ) {
							try {
								$response = $client->messages->create(
									$receiver_number,
									[
										'from' => $sender_number,
										'body' => $sms_message,
									]
								);

							} catch ( Exception $e ) {
								$response = $e->getMessage();

							}
						}

						if ( wpj_get_option( 'wpjobster_twilio_whatsapp_enabled' ) != 'no' ) {
							try {
								$response = $client->messages->create(
									'whatsapp:' . $receiver_number,
									[
										'from' => 'whatsapp:' . $sender_number,
										'body' => $sms_message,
									]
								);

							} catch ( Exception $e ) {
								$response = $e->getMessage();

							}
						}
					}
				}

				break;

			case 'cafe24':
				$cafeId         = wpj_get_option( "wpjobster_theme_cafe_userid" );
				$cafeKey        = wpj_get_option( "wpjobster_theme_cafe_secure" );
				$sender_number  = wpj_get_option( "wpjobster_sms_numb_cafe_from" );

				if ( $cafeId && $cafeKey && $sender_number ) {
					include_once get_template_directory() . '/vendor/cafetwentyfour.php';

					$cafe     = new ServicesCafe( $cafeId, $cafeKey );
					$response = $cafe->send( $sms_message, $receiver_number, $sender_number );
				}

				break;
		}

		return $response;
	}
}

if ( ! function_exists( 'wpj_get_message_with_params_multiple' ) ) {
	function wpj_get_message_with_params_multiple( $message = '', $params = [] ) {
		if ( strpos( $message, '[start_list]' ) !== false ) {
			$message_start_arr = explode( '[start_list]', $message );
			$message_end_arr   = explode( '[end_list]', $message );

			$completed_message = $message_start_arr[0];

			if ( $params ) {
				foreach ( $params as $key => $value ) {
					$completed_message .= wpj_get_string_between( wpj_replace_coded_word_with_value( array_keys( $value ), array_values( $value ), $message ), '[start_list]', '[end_list]' ) . PHP_EOL;
				}
			}

			$completed_message .= $message_end_arr[1];

			return $completed_message;
		}

		return $message;
	}
}

if ( ! function_exists( 'wpj_replace_coded_word_with_value' ) ) {
	function wpj_replace_coded_word_with_value( $find, $replace, $subject ) {
		$i = 0;

		if ( $find ) {
			foreach ( $find as $item ) {
				$subject = str_replace( $item, $replace[$i], $subject ); $i++;
			}
		}

		return $subject;
	}
}

// ARRAY FOR NOTIFICATIONS
if ( ! function_exists( 'wpj_notification_key_exists' ) ) {
	function wpj_notification_key_exists( $key ) {
		$reasons = wpj_get_notifications_array();

		foreach ( $reasons as $reason ) {
			if ( array_key_exists( $key, $reason['items'] ) ) {
				return true;
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_notifications_array' ) ) {
	function wpj_get_notifications_array() {
		$reasons = [
			"admin" => [
				"title" => "Admin Notifications",
				"items" => [
					"user_admin_new" => [
						"title"       => __( "New User", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when a new user registers on the website.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##user_email##</strong>",
					],
					"job_admin_new" => [
						"title"       => __( "New Job Not-Approved", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when someone posts a job on the website if the job is not automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##job_name##</strong>",
					],
					"job_admin_acc" => [
						"title"       => __( "New Job Approved", "wpjobster" ),
						"description" =>
							"This email will be received by the admin when someone posts a job on the website if the the job is automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##job_link##<br />##job_name##</strong>",
					],
					"job_edit" => [
						"title"       => __( "Edit Job", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when a user edit a job and the job is not automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##user_email##</strong>",
					],
					"job_admin_purchased" => [
						"title"       => __( "New Job Purchased", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when a user buys a new job.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##job_link##<br />##job_name##</strong>",
					],
					"featured_admin_new" => [
						"title"       => __( "New Job Featured", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when someone features a job on the website.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##job_link##<br />##job_name##<br />##all_featured_info##</strong>",
					],
					"request_admin_new" => [
						"title"       => __( "New Request Not-Approved", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when someone posts a request on the website if the request is not automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##request_name##</strong>",
					],
					"request_admin_acc" => [
						"title"       => __( "New Request Approved", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when someone posts a request on the website if the the job is automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##request_link##<br />##request_name##</strong>",
					],
					"request_edit" => [
						"title"       => __( "Edit Request", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when an user edits a request and the request is not automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##user_email##</strong>",
					],
					"custom_extra_paid_admin_new" => [
						"title"       => __( "New Custom Extra Paid", "wpjobster" ),
						"description" =>
							"This notification will be received by admin when a custom extra is bought.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##username##<br />##transaction_page_link##</strong>",
					],
					"badge_admin_new" => [
						"title"       => __( "New Badge Purchased", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when a user buys a new badge.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##badge_title##<br />##badge_price##<br />##payment_gateway##</strong>",
					],
					"balance_admin_down" => [
						"title"       => __( "Balance Down", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when an user's credits are decreased by an admin.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##amount_updated##</strong>",
					],
					"balance_admin_up" => [
						"title"       => __( "Balance Up", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when an user's credits are increased by an admin.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##amount_updated##</strong>",
					],
					"balance_admin_up_paypal" => [
						"title"       => __( "Balance Up via Paypal", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when an user's credits are increased via Paypal.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##amount_updated##</strong>",
					],
					"balance_admin_up_topup" => [
						"title"       => __( "Balance Up via Top Up", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when an user's credits are increased via Top Up.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##amount_updated##<br />##payment_gateway##</strong>",
					],
					"admin_payment_completed_by_admin" => [
						"title"       => __( "Admin Mark Payment Complete", "wpjobster" ),
						"description" =>
							"This notification will be received by admin when admin marks as completed any job payment.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_page_link##<br />##job_name##</strong>",
					],
					"new_bank_transfer_pending" => [
						"title"       => __( "New Bank Transfer Pending", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when user purchases via bank transfer.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##payment_type##<br />##payment_amount##<br />##admin_orders_url##</strong>",
					],
					"admin_arbitration" => [
						"title"       => __( "Arbitration", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when new arbitration is requested.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##username##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"admin_new_subscription" => [
						"title"       => __( "New Subscription", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when a user subscribes for any level
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level##<br />##next_subscription_amount##<br />##next_billing_date##<br />##next_subscription_level##<br />##current_subscription_period##<br />##current_subscription_amount##</strong>",
					],
					"admin_upgrade_subscription" => [
						"title"       => __( "Upgrade Subscription", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when a user upgrade his subscription.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level##<br />##next_subscription_amount##<br />##next_billing_date##<br />##next_subscription_level##<br />##current_subscription_period##<br />##current_subscription_amount##</strong>",
					],
					"admin_cancel_subscription" => [
						"title"       => __( "Cancel subscription", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when a user cancel his subscription.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level####current_subscription_period##<br />##current_subscription_amount##</strong>",
					],
					"admin_new_withdrawal_request" => [
						"title"       => __( "New withdrawal request", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when he has a new  withdrawal request
							<br /><br />Available shortcodes:
							<br /><br /><strong>##withdrawal_username##<br />##withdrawal_amount##<br />##withdrawal_method##</strong>",
					],
					"admin_openexchangerates_not_responding" => [
						"title"       => __( "OpenExchangeRates not responding", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when OpenExchangeRates.org is not responding
							<br /><br />Available shortcodes: <br />",
					],
					"admin_openexchangerates_higher" => [
						"title"       => __( "Currency drop higher than x%", "wpjobster" ),
						"description" =>
							"This notification will be received by the admin when currency drop is higher than x%
							<br /><br />Available shortcodes:
							<br /><br /><strong>##main_currency##<br />##old_price##<br />##new_price##<br />##percent_difference##</strong>",
					],
				],
			],
			"registration" => [
				"title" => "Registration",
				"items" => [
					"user_new" => [
						"title"       => __( "New User", "wpjobster" ),
						"description" =>
							"This notification will be received by all new users who register on your website using the Ajax form and social login options (most of them).
							<br /><br />Available shortcodes:
							<br /><br /><strong>##receiver_email##<br />##email_verification##</strong>",
					],
					"user_verification" => [
						"title"       => __( "User Email Verification", "wpjobster" ),
						"description" =>
							"This notification will be received by an user who wants to verify his email and he didn't receive the verification link into the registration email.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##receiver_email##<br />##email_verification##</strong>",
					],
					"user_forgot_password" => [
						"title"       => __( "User Forgot Password", "wpjobster" ),
						"description" =>
							"This notification will be received by an user who requests forgot / reset password on your website.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##receiver_email##<br/>##password_reset_link##</strong>",
					],
				],
			],
			"levels" => [
				"title" => "User Levels",
				"items" => [
					"level_down" => [
						"title"       => __( "Level Down", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when his level gets downgraded.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##current_level##</strong>",
					],
					"level_up" => [
						"title"       => __( "Level Up", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when his level gets upgraded.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##current_level##</strong>",
					],
				],
			],
			"messages" => [
				"title" => "Messages",
				"items" => [
					"new_message" => [
						"title"       => __( "New Message", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when they receive a private message in their account.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##private_message_link##<br />##private_message_excerpt##<br />##private_message_content##</strong>",
					],
				],
			],
			"jobs" => [
				"title" => "Jobs",
				"items" => [
					"job_new" => [
						"title"       => __( "New Job Not Approved", "wpjobster" ),
						"description" =>
							"This notification will be received by your users after posting a new job on your website if the job is not automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_name##</strong>",
					],
					"job_acc" => [
						"title"       => __( "New Job Approved", "wpjobster" ),
						"description" =>
							"This notification will be received by your users after posting a new job on your website if the job is automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##</strong>",
					],
					"job_decl" => [
						"title"       => __( "New Job Rejected", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when you reject a job by marking it as pending.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_name##</strong>",
					],
					"featured_new" => [
						"title"       => __( "New Job Featured", "wpjobster" ),
						"description" =>
							"This notification will be received by your users after featuring a job on your website.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_name##<br />##job_link##<br />##all_featured_info##</strong>",
					]
				],
			],
			"job_orders" => [
				"title" => "Job Orders",
				"items" => [
					"incomplete_order" => [
						"title"       => __( "Incomplete Order (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when they reach the checkout page but do not complete the purchase of the order.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##</strong>",
					],
					"pending_payment_expires" => [
						"title"       => __( "Pending Payment Expires Soon (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer 24 hours before the pending payment time expires.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"order_accepted"  => [
						"title"       => __( "Accepted Order", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when the seller accept the order.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"order_rejected"  => [
						"title"       => __( "Rejected Order", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when the seller reject the order.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"purchased_buyer" => [
						"title"       => __( "Job Purchased (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when they purchase a new job.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##mc_gross##<br />##processing_fees##<br />##tax_amount##<br />##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"purchased_seller" => [
						"title"       => __( "Job Sold (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when they sell one of their jobs.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##mc_gross##<br />##processing_fees##<br />##tax_amount##<br />##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"order_message" => [
						"title"       => __( "Transaction Message", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when they receive a new message on a transaction page.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_buyer" => [
						"title"       => __( "Cancellation Requested (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the job when the buyer requests a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_seller" => [
						"title"       => __( "Cancellation Requested (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the job when the seller requests a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_acc_buyer" => [
						"title"       => __( "Cancellation Accepted (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the job when the buyer accepts a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_acc_seller" => [
						"title"       => __( "Cancellation Accepted (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the job when the seller accepts a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_decl_buyer" => [
						"title"       => __( "Cancellation Declined (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the job when the buyer declines a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_decl_seller" => [
						"title"       => __( "Cancellation Declined (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the job when the seller declines a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_abort_buyer" => [
						"title"       => __( "Cancellation Aborted (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the job when the buyer aborts a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_abort_seller" => [
						"title"       => __( "Cancellation Aborted (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the job when the seller aborts a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_admin" => [
						"title"       => __( "Cancelled by Admin", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller and the buyer when the admin cancels the job.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_ord_expired_seller" => [
						"title"       => __( "Order Expired (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when the buyer cancel the job because delivery time has expired.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_ord_expired_buyer" => [
						"title"       => __( "Order Expired (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when canceling the job because delivery time has expired.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"ord_expires_soon" => [
						"title"       => __( "Order Expires Soon (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller 24 hours before the order delivery time expires.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"mod_buyer" => [
						"title"       => __( "Modification Request (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the job when the buyer requests a modification.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"extend_delivery_request" => [
						"title"       => __( "Extend Delivery Time Request (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the job when the seller requests an extension of the delivery time.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"extend_delivery_abort" => [
						"title"       => __( "Extend Delivery Time Aborted (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the job when the seller cancels the request for an extension of the delivery time.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"extend_delivery_accept" => [
						"title"       => __( "Extend Delivery Time Accepted (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the job when the buyer accepts to extend the delivery time.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"extend_delivery_decline" => [
						"title"       => __( "Extend Delivery Time Declined (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the job when the buyer refuses to extend the delivery time.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"order_delivered" => [
						"title"       => __( "Job Delivered (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when the seller marks the job as done/delivered.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"order_complete" => [
						"title"       => __( "Job Completed (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when the buyer accepts the delivered job.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"new_feedback" => [
						"title"       => __( "New Feedback (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when he received feedback from the buyer.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##job_link##<br />##job_name##<br />##transaction_number##<br />##transaction_page_link##</strong>",
					],
				],
			],
			"arbitration" => [
				"title" => "Arbitration",
				"items" => [
					"arb_new_request" => [
						"title"       => __( "New Arbitration Request", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when arbitration has been opened.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##transaction_number##<br />##job_name##<br />##job_link##<br />##transaction_page_link##</strong>",
					],
					"arb_request_closed_buyer" => [
						"title"       => __( "Arbitration Request Closed (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when arbitration request has been closed in favor of buyer.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##transaction_number##<br />##job_name##<br />##job_link##<br />##transaction_page_link##</strong>",
					],
					"arb_request_closed_seller" => [
						"title"       => __( "Arbitration Request Closed (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when arbitration request has been closed in favor of seller.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##transaction_number##<br />##job_name##<br />##job_link##<br />##transaction_page_link##</strong>",
					],
					"arb_request_aborted" => [
						"title"       => __( "Arbitration Request Aborted", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when arbitration request has been aborted.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##username##<br />##transaction_number##<br />##job_name##<br />##job_link##<br />##transaction_page_link##</strong>",
					],
				],
			],
			"requests" => [
				"title" => "Requests",
				"items" => [
					"request_new" => [
						"title"       => __( "New Request Not Approved", "wpjobster" ),
						"description" =>
							"This notification will be received by your users after posting a new job on your website if the request is not automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##request_name##</strong>",
					],
					"request_acc" => [
						"title"       => __( "New Request Approved", "wpjobster" ),
						"description" =>
							"This notification will be received by your users after posting a new request on your website if the job is automatically approved.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##request_link##<br />##request_name##</strong>",
					],
					"request_decl" => [
						"title"       => __( "New Request Rejected (Pending)", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when you reject a job by marking it as pending.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##request_name##</strong>",
					],
					"withdraw_req" => [
						"title"       => __( "Withdraw Request", "wpjobster" ),
						"description" =>
							"This notification will be received by the user after he requests a withdrawal.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_withdrawn##<br />##withdraw_method##<br />##withdrawal_email_verification##</strong>",
					],
					"withdraw_req_confirmation" => [
						"title"       => __( "Withdraw Request With Confirmation", "wpjobster" ),
						"description" =>
							"This notification will be received by the user after he requests a withdrawal.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_withdrawn##<br />##withdraw_method##<br />##withdrawal_email_verification##</strong>",
					],
					"withdraw_compl" => [
						"title"       => __( "Withdraw Processed (Accepted)", "wpjobster" ),
						"description" =>
							"This notification will be received by the user after his withdrawal request has been processed.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_withdrawn##<br />##withdraw_method##</strong>",
					],
					"withdraw_decl" => [
						"title"       => __( "Withdraw Rejected", "wpjobster" ),
						"description" =>
							"This notification will be received by the user after his withdrawal request has been rejected.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_withdrawn##<br />##withdraw_method##</strong>",
					],
				],
			],
			"custom_offers" => [
				"title" => "Custom Offers",
				"items" => [
					"new_request" => [
						"title"       => __( "New Request (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when they receive a custom offer request.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##private_message_link##</strong>",
					],
					"new_offer" => [
						"title"       => __( "New Offer (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when they receive a custom offer.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##private_message_link##</strong>",
					],
					"offer_acc_buyer" => [
						"title"       => __( "Offer Accepted (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when he accepted a custom offer.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##private_message_link##<br />##transaction_page_link##<br />##transaction_number##</strong>",
					],
					"offer_acc_seller" => [
						"title"       => __( "Offer Accepted (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when his custom offer was accepted.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##private_message_link##<br />##transaction_page_link##<br />##transaction_number##</strong>",
					],
					"offer_decl" => [
						"title"       => __( "Offer Declined (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when their custom offer was declined.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##private_message_link##</strong>",
					],
					"offer_withdr" => [
						"title"       => __( "Offer Withdrawn (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when their custom offer was withdrawn.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##private_message_link##</strong>",
					],
					"offer_exp" => [
						"title"       => __( "Offer Expired (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by your users when their custom offer expired.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##private_message_link##</strong>",
					],
				],
			],
			"custom_offer_orders" => [
				"title" => "Custom Offer Orders",
				"items" => [
					"cancel_offer_buyer" => [
						"title"       => __( "Offer Cancellation Requested (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the custom offer when the buyer requests a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_offer_seller" => [
						"title"       => __( "Offer Cancellation Requested (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the custom offer when the seller requests a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_offer_acc_buyer" => [
						"title"       => __( "Offer Cancellation Accepted (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the custom offer when the buyer accepts a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_offer_acc_seller" => [
						"title"       => __( "Offer Cancellation Accepted (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the custom offer when the seller accepts a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_offer_decl_buyer" => [
						"title"       => __( "Offer Cancellation Declined (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the custom offer when the buyer declines a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_offer_decl_seller" => [
						"title"       => __( "Offer Cancellation Declined (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the custom offer when the seller declines a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_offer_abort_buyer" => [
						"title"       => __( "Offer Cancellation Aborted (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the custom offer when the buyer aborts a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_offer_abort_seller" => [
						"title"       => __( "Offer Cancellation Aborted (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of the custom offer when the seller aborts a mutual cancellation.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"cancel_offer_admin" => [
						"title"       => __( "Offer Cancelled by Admin", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller and the buyer when the admin cancels the custom offer.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"mod_offer_buyer" => [
						"title"       => __( "Offer Modification Request (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller of the custom offer when the buyer requests a modification.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"order_offer_delivered" => [
						"title"       => __( "Offer Job Delivered (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when the seller marks the custom offer as done.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"order_offer_complete" => [
						"title"       => __( "Offer Job Completed (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when the buyer accepts the custom offer as delivered.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
					"new_offer_feedback" => [
						"title"       => __( "Offer New Feedback (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when he received feedback from the buyer.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##transaction_number##<br />##transaction_page_link##</strong>",
					],
				],
			],
			"custom_extras" => [
				"title" => "Custom Extras",
				"items" => [
					"new_custom_extra" => [
						"title"       => __( "New Custom Extra (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when a new custom extra is added.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
					"cancel_custom_extra" => [
						"title"       => __( "Custom Extra Cancelled (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when a custom extra is cancelled by seller.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
					"decline_custom_extra" => [
						"title"       => __( "Custom Extra Declined (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when a custom extra is declined by buyer.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
					"custom_extra_paid_new" => [
						"title"       => __( "Custom Extra Paid (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer of a custom extra.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
					"custom_extra_paid_new_seller" => [
						"title"       => __( "Custom Extra Paid (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when a custom extra is bought.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
					"custom_extra_cancelled_by_admin" => [
						"title"       => __( "BT Custom Extra Cancelled (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when a Bank Transfer custom extra is cancelled by admin.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
					"custom_extra_cancelled_by_admin_seller" => [
						"title"       => __( "BT Custom Extra Cancelled (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when a Bank Transfer custom extra is cancelled by admin.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
				],
			],
			"tips" => [
				"title" => "Tips",
				"items" => [
					"new_tips" => [
						"title"       => __( "New Tips (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when a new tips is added.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
					"cancel_tips" => [
						"title"       => __( "Tips Cancelled (Buyer)", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when a tips order is cancelled.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
					"tips_paid_new" => [
						"title"       => __( "Tips Paid (Seller)", "wpjobster" ),
						"description" =>
							"This notification will be received by the seller when a tips is paid.
							<br /><br /> Available shortcodes:
							<br /><br /> <strong>##transaction_page_link##</strong>",
					],
				],
			],
			"subscriptions" => [
				"title" => "Subscriptions",
				"items" => [
					"price_update_subscription" => [
						"title"       => __( "Subscription Price Update", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when admin updates the subscription price.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##subscription_url##</strong>",
					],
					"balance_down_subscription" => [
						"title"       => __( "New Subscription", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when he subscribes for any level.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level##<br />##next_subscription_amount##<br />##next_billing_date##<br />##next_subscription_level##<br />##current_subscription_period##<br />##current_subscription_amount##</strong>",
					],
					"balance_down_subscription_change" => [
						"title"       => __( "Subscription Change", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when he changes his subscription level with immediate effect.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level##<br />##next_subscription_amount##<br />##next_billing_date##<br /><br />##current_subscription_period##<br />##current_subscription_amount##</strong>",
					],
					"wpjobster_subscription_prior_notification" => [
						"title"       => __( "Prior Subscription Renewal", "wpjobster" ),
						"description" =>
							"This notification will be received by the user few days before his subscription renewal.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level##<br />##next_subscription_amount##<br />##next_billing_date##<br />##next_subscription_level##<br />##current_subscription_period##<br />##current_subscription_amount##<br />##no_of_days_subscription_left##</strong>",
					],
					"subscription_cancel" => [
						"title"       => __( "Subscription Cancel (Manual)", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when he cancels his subscription.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level##<br />##current_subscription_period##<br />##current_subscription_amount##</strong>",
					],
					"subscription_cancel_lowbalance" => [
						"title"       => __( "Subscription Cancel (Low Balance)", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when his subscription was cancelled due to low credits balance.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level##<br />##next_subscription_amount##<br />##next_billing_date##<br />##next_subscription_level##<br />##current_subscription_period##<br />##current_subscription_amount##</strong>",
					],
					"subscription_schedule" => [
						"title"       => __( "Subscription Schedule", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when he schedules his subscription.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##current_subscription_level##<br />##next_subscription_amount##<br />##next_billing_date##<br />##next_subscription_level##<br />##current_subscription_period##<br />##current_subscription_amount##</strong>",
					],
				],
			],
			"user_balance" => [
				"title" => "User Balance",
				"items" => [
					"balance_down" => [
						"title"       => __( "Balance Down", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when his credits are decreased by an admin.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##</strong>",
					],
					"balance_up" => [
						"title"       => __( "Balance Up", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when his credits are increased by an admin.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##</strong>",
					],
					"balance_up_paypal" => [
						"title"       => __( "Balance Up via Paypal", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when his credits are increased by payment via PayPal.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##amount_updated_in_currency##</strong>",
					],
					"balance_up_topup" => [
						"title"       => __( "Balance Up via Top Up", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when credits are increased via Topup.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##<br />##amount_updated_in_currency##<br />##payment_gateway##</strong>",
					],
					"balance_negative" => [
						"title"       => __( "Balance Negative", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when his credits are gone negative.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##amount_updated##</strong>",
					],
				],
			],
			"various_payments" => [
				"title" => "Various Payments",
				"items" => [
					"payment_completed_by_admin" => [
						"title"       => __( "Admin mark Payment Complete", "wpjobster" ),
						"description" =>
							"This notification will be received by the buyer when admin marks the payment completed.
							<br /><br />Available shortcodes:
							<br /><br /><strong><br />##transaction_page_link##<br />##job_name##</strong>",
					],
					"send_bankdetails_to_buyer" => [
						"title"       => __( "Send Bank Details", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when they choose to pay using the bank transfer payment menthod.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##bank_details##<br />##job_name##<br />##transaction_page_link##</strong>",
					],
					"send_bankdetails_to_topup_buyer" => [
						"title"       => __( "Send Bank Details (Top Up)", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when they choose to pay using the bank transfer payment menthod.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##bank_details##<br />##job_name##<br />##transaction_page_link##</strong>",
					],
					"send_bankdetails_to_feature_buyer" => [
						"title"       => __( "Send Bank Details (Feature)", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when they choose to pay using the bank transfer payment menthod.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##bank_details##<br />##job_name##<br />##transaction_page_link##</strong>",
					],
					"send_bankdetails_to_custom_extra_buyer" => [
						"title"       => __( "Send Bank Details (Custom Extra)", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when they choose to pay using the bank transfer payment menthod.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##bank_details##<br />##job_name##<br />##transaction_page_link##</strong>",
					],
					"send_bankdetails_to_tips_buyer" => [
						"title"       => __( "Send Bank Details (Tips)", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when they choose to pay using the bank transfer payment menthod.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##bank_details##<br />##job_name##<br />##transaction_page_link##</strong>",
					],
					"badge_new" => [
						"title"       => __( "New Badge Purchased", "wpjobster" ),
						"description" =>
							"This notification will be received by the user when purchasing a new badge.
							<br /><br />Available shortcodes:
							<br /><br /><strong>##badge_title##<br />##badge_price##<br />##payment_gateway##</strong>",
					],
				],
			],
		];

		$reasons = apply_filters( 'wpjobster_admin_menu_email_templates', $reasons );

		$general_shortcodes = '<strong><br />##receiver_username##<br />##sender_username##<br />##my_account_url##<br />##your_site_name##<br />##your_site_url##</strong>';

		foreach ( $reasons as $r_key => $reason ) {
			foreach ( $reason["items"] as $i_key => $item ) {
				$reasons[$r_key]["items"][$i_key]["description"] .= $general_shortcodes;
			}
		}

		return $reasons;
	}
}