<?php
if ( ! function_exists( 'wpj_get_characters_limit' ) ) {
	function wpj_get_characters_limit( $character_key, $limit_type, $default = '' ) {
		if ( $limit_type == 'min' ) {
			if ( ! $default ) $default = 0;

			$character_limit = ! empty( wpj_get_option( 'wpj_' . $character_key . '_character_limits' ) ) ? wpj_get_option( 'wpj_' . $character_key . '_character_limits' )[1] : '';

			if ( ! $character_limit || ! is_numeric( $character_limit ) ) $character_limit = $default;

		} else {
			if ( ! $default ) $default = 80;

			$character_limit = ! empty( wpj_get_option( 'wpj_' . $character_key . '_character_limits' ) ) ? wpj_get_option( 'wpj_' . $character_key . '_character_limits' )[2] : '';

			if ( ! $character_limit || ! is_numeric( $character_limit ) || $character_limit < 1 ) $character_limit = $default;
		}

		return $character_limit;
	}
}

if ( ! function_exists( 'wpj_get_allowed_html_tags_for_wysiwyg' ) ) {
	function wpj_get_allowed_html_tags_for_wysiwyg( $desc ) {
		$description = trim( wp_kses( $desc, [
			'br'     => [],
			'b'      => [],
			'i'      => [],
			'u'      => [],
			'ul'     => [],
			'ol'     => [],
			'strong' => [],
			'em'     => [],
			'p'      => [],
			'span'   => [],
			'li'     => [],
		] ) );

		return wpj_stripslashes( $description );
	}
}

/* Categories available for $category param:
 * privatemessages
 * transactionpages
 * joblistings
 * requestlistings
 * userprofiles
 */
if ( ! function_exists( 'wpj_filter_string' ) ) {
	function wpj_filter_string( $message, $replace = true, $category = '' ) {
		$validation_errors = [];

		$message = wpj_stripslashes( $message );

		if ( wpj_get_option( 'wpjobster_disable_filters' ) != 'yes' ) {

			// Filter Emails
			if ( is_array( wpj_get_option( 'wpj_filter_emails' ) ) ) {
				if ( in_array( $category, wpj_get_option( 'wpj_filter_emails' ) ) ) {
					list( $message, $status ) = wpj_filter_emails( $message, $replace );

					if ( $status == 1 ) {
						if ( wpj_get_option( 'wpjobster_blacklisted_email' ) ) {
							array_push( $validation_errors, wpj_get_option( 'wpjobster_blacklisted_email' ) );
						}
					}
				}
			}

			// Filter Phone Numbers
			if ( is_array( wpj_get_option( 'wpj_filter_phone_numbers' ) ) ) {
				if ( in_array( $category, wpj_get_option( 'wpj_filter_phone_numbers' ) ) ) {
					list( $message, $status ) = wpj_filter_phone_numbers( $message, $replace );

					if ( $status == 1 ) {
						if ( wpj_get_option( 'wpjobster_blacklisted_phone' ) ) {
							array_push( $validation_errors, wpj_get_option( 'wpjobster_blacklisted_phone' ) );
						}
					}
				}
			}

			// Filter Words 1
			if ( is_array( wpj_get_option( 'wpj_filter_words1' ) ) ) {
				if ( wpj_get_option( 'wpjobster_blacklisted_words_pm' ) && in_array( $category, wpj_get_option( 'wpj_filter_words1' ) ) ) {
					$wpjobster_blacklisted_words_pm = wpj_get_option( 'wpjobster_blacklisted_words_pm' );

					$blacklisted_words_pm = str_replace( "\r", "\n", $wpjobster_blacklisted_words_pm );
					$blacklisted_words_pm = explode( "\n", $blacklisted_words_pm );
					$blacklisted_words_clean = [];

					foreach ( $blacklisted_words_pm as $word ) {
						$word = trim( $word );

						if ( $word ) {
							array_push( $blacklisted_words_clean, $word );
						}
					}

					if ( $blacklisted_words_clean ) {
						list( $message, $status ) = wpj_filter_words( $message, $blacklisted_words_clean, $replace );

						if ( $status == 1 ) {
							if ( wpj_get_option( 'wpjobster_blacklisted_words_pm_err' ) ) {
								array_push( $validation_errors, wpj_get_option( 'wpjobster_blacklisted_words_pm_err' ) );
							}
						}
					}
				}
			}

			// Filter Words 2
			if ( is_array( wpj_get_option( 'wpj_filter_words2' ) ) ) {
				if ( wpj_get_option( 'wpjobster_blacklisted_words2_pm' ) && in_array( $category, wpj_get_option( 'wpj_filter_words2' ) ) ) {
					$wpjobster_blacklisted_words2_pm = wpj_get_option( 'wpjobster_blacklisted_words2_pm' );

					$blacklisted_words2_pm = str_replace( "\r", "\n", $wpjobster_blacklisted_words2_pm );
					$blacklisted_words2_pm = explode( "\n", $blacklisted_words2_pm );
					$blacklisted_words2_clean = [];

					foreach ( $blacklisted_words2_pm as $word ) {
						$word = trim( $word );

						if ( $word ) {
							array_push( $blacklisted_words2_clean, $word );
						}
					}

					if ( $blacklisted_words2_clean ) {
						list( $message, $status ) = wpj_filter_words( $message, $blacklisted_words2_clean, $replace );

						if ( $status == 1 ) {
							if ( wpj_get_option( 'wpjobster_blacklisted_words2_pm_err' ) ) {
								array_push( $validation_errors, wpj_get_option( 'wpjobster_blacklisted_words2_pm_err' ) );
							}
						}
					}
				}
			}

			// Filter Words 3
			if ( is_array( wpj_get_option( 'wpj_filter_words3' ) ) ) {
				if ( wpj_get_option( 'wpjobster_blacklisted_words3_pm' ) && in_array( $category, wpj_get_option( 'wpj_filter_words3' ) ) ) {
					$wpjobster_blacklisted_words3_pm = wpj_get_option( 'wpjobster_blacklisted_words3_pm' );

					$blacklisted_words3_pm = str_replace( "\r", "\n", $wpjobster_blacklisted_words3_pm );
					$blacklisted_words3_pm = explode( "\n", $blacklisted_words3_pm );
					$blacklisted_words3_clean = [];

					foreach ( $blacklisted_words3_pm as $word ) {
						$word = trim( $word );

						if ( $word ) {
							array_push( $blacklisted_words3_clean, $word );
						}
					}

					if ( $blacklisted_words3_clean ) {
						list( $message, $status ) = wpj_filter_words( $message, $blacklisted_words3_clean, $replace );

						if ( $status == 1 ) {
							if ( wpj_get_option( 'wpjobster_blacklisted_words3_pm_err' ) ) {
								array_push( $validation_errors, wpj_get_option( 'wpjobster_blacklisted_words3_pm_err'  ));
							}
						}
					}
				}
			}

		}

		return [$message, $validation_errors];
	}
}

if ( ! function_exists( 'wpj_apply_filter_to_string' ) ) {
	function wpj_apply_filter_to_string( $string = '', $include_warning = false, $category = '' ) {
		list( $string, $validation_errors ) = wpj_filter_string( $string, true, $category );

		if ( $include_warning ) {
			ob_start();

			wpj_display_filter_warning( $validation_errors );

			$string .= ob_get_contents();

			ob_end_clean();
		}

		return $string;
	}
}

if ( ! function_exists( 'wpj_wrap_title' ) ) {
	function wpj_wrap_title( $title = '', $pid = '' ) {
		return $title;
	}
}

if ( ! function_exists( 'wpj_add_three_dots_excerpt' ) ) {
	function wpj_add_three_dots_excerpt( $more ) {
		return '...';
	}
}

if ( ! function_exists( 'wpj_encode_emoji' ) ) {
	function wpj_encode_emoji( $string ) {
		if ( function_exists( 'wp_encode_emoji' ) && function_exists( 'mb_convert_encoding' ) ) {
			$string = wp_encode_emoji( $string );
		}

		return $string;
	}
}

if ( ! function_exists( 'wpj_get_title_by_payment_type' ) ) {
	function wpj_get_title_by_payment_type( $payment_type, $order_details ) {
		if ( is_object( $order_details ) )
			$order_details = wpj_json_decode( json_encode( $order_details ), true );

		if ( $payment_type == 'feature' ) {
			$title = wpj_get_feature_title_by_pages( $order_details['feature_pages'] );

		} elseif ( $payment_type == 'topup' ) {
			$title = __( 'Topup user account', 'wpjobster' );

		} elseif ( $payment_type == 'job_purchase' || $payment_type == 'custom_extra' || $payment_type == 'tips' ) {
			if ( $payment_type == 'job_purchase' ) $pid = $order_details['pid'];
			else $pid = wpj_get_job_order_by_id( $order_details['order_id'], 'pid' );

			$post  = get_post( $pid );
			$title = ! empty( $post->post_title ) ? $post->post_title : ucfirst( $payment_type );

		} elseif ( $payment_type == 'subscription' ) {
			$title = wpj_get_subscription_plan_name_by_level( $order_details['level'] );

		} elseif ( $payment_type == 'badge' ) {
			$title = sprintf( __( 'Badge: %s', 'wpjobster' ), $order_details['description'] );

		} else {
			$title = __( 'No titles found', 'wpjobster' );

		}

		return $title;
	}
}

if ( ! function_exists( 'wpj_get_sliders_dummy_content' ) ) {
	function wpj_get_sliders_dummy_content() {
		$sliders_info = [
			'1' => [
				'image'              => get_template_directory_uri() . '/assets/images/homepage/slide1.webp',
				'title'              => __( 'Service Marketplace Theme', 'wpjobster' ),
				'content'            => __( 'Jobster is the most advanced and feature rich WordPress Service Marketplace Theme. Developed and maintained by the people who run a successful marketplace of their own.', 'wpjobster' ),
				'employer_name'      => __( 'John Smith', 'wpjobster' ),
				'employer_image'     => get_template_directory_uri() . '/assets/images/dummy/user2.webp',
				'employer_message'   => __( 'Hi! I need you for this job. When can we start?', 'wpjobster' ),
				'reviewer_name'      => __( 'Marsha Fox', 'wpjobster' ),
				'reviewer_image'     => get_template_directory_uri() . '/assets/images/dummy/user1.webp',
				'reviewer_message'   => __( '“The work has been done in the desired timeline! Great job!”', 'wpjobster' ),
				'reviewer_ocupation' => __( 'UI/UX Designer', 'wpjobster' ),
				'reviewer_stars'     => 5,
				'category_name'      => __( 'Programming & IT', 'wpjobster' ),
				'category_job_name'  => __( 'MySQL database design services', 'wpjobster' )
			],
			'2' => [
				'image'              => get_template_directory_uri() . '/assets/images/homepage/slide2.webp',
				'title'              => __( 'Suitable for any Niche', 'wpjobster' ),
				'content'            => __( 'No matter the niche you are looking to get into, Jobster Service Marketplace Theme will be your shortest path to validating your business idea without braking your bank.', 'wpjobster' ),
				'employer_name'      => __( 'Jonathan Farmer', 'wpjobster' ),
				'employer_image'     => get_template_directory_uri() . '/assets/images/dummy/user2.webp',
				'employer_message'   => __( 'Interior designer needed for logo!', 'wpjobster' ),
				'reviewer_name'      => __( 'James Boyd', 'wpjobster' ),
				'reviewer_image'     => get_template_directory_uri() . '/assets/images/dummy/user2.webp',
				'reviewer_message'   => __( '“Thanks for discount. Great job!”', 'wpjobster' ),
				'reviewer_ocupation' => __( 'Human Resource Specialist', 'wpjobster' ),
				'reviewer_stars'     => 5,
				'category_name'      => __( 'Lifestyle', 'wpjobster' ),
				'category_job_name'  => __( 'I will dance at your next party', 'wpjobster' )
			],
			'3' => [
				'image'              => get_template_directory_uri() . '/assets/images/homepage/slide3.webp',
				'title'              => __( 'iOS and Android apps', 'wpjobster' ),
				'content'            => __( 'Start off like a pro! It’s hard enough as it is to compete with the big guys considering their high marketing budgets. But, the platform you do business on will be on par!', 'wpjobster' ),
				'employer_name'      => __( 'Wilbur Speights', 'wpjobster' ),
				'employer_image'     => get_template_directory_uri() . '/assets/images/dummy/user2.webp',
				'employer_message'   => __( 'I need a english teacher', 'wpjobster' ),
				'reviewer_name'      => __( 'Angeline Cherry', 'wpjobster' ),
				'reviewer_image'     => get_template_directory_uri() . '/assets/images/dummy/user1.webp',
				'reviewer_message'   => __( '“Thank you very much for your wonderful service. A experience!”', 'wpjobster' ),
				'reviewer_ocupation' => __( 'Translator', 'wpjobster' ),
				'reviewer_stars'     => 5,
				'category_name'      => __( 'Marketing', 'wpjobster' ),
				'category_job_name'  => __( 'SEO master professional', 'wpjobster' )
			],
			'4' => [
				'image'              => get_template_directory_uri() . '/assets/images/homepage/slide4.webp',
				'title'              => __( 'Partner with the Best', 'wpjobster' ),
				'content'            => __( 'We are sure our competitors are offering solid solutions as well.<br>However, very few, if any, can display 4 years of impeccable track record backed up by changelog history since 2015.', 'wpjobster' ),
				'employer_name'      => __( 'Erika Scott', 'wpjobster' ),
				'employer_image'     => get_template_directory_uri() . '/assets/images/dummy/user1.webp',
				'employer_message'   => __( 'I need a customized eCommerce website!', 'wpjobster' ),
				'reviewer_name'      => __( 'Brenda Banks', 'wpjobster' ),
				'reviewer_image'     => get_template_directory_uri() . '/assets/images/dummy/user1.webp',
				'reviewer_message'   => __( '“You made my job easy by provide me all needed requirement. Thanks, looking forward to work with you again!”', 'wpjobster' ),
				'reviewer_ocupation' => __( 'UI/UX Designer', 'wpjobster' ),
				'reviewer_stars'     => 5,
				'category_name'      => __( 'Software Developer', 'wpjobster' ),
				'category_job_name'  => __( 'Wonderful landscape pictures', 'wpjobster' )
			]
		];

		return apply_filters( 'wpj_homepage_hero_slider_content_filter', $sliders_info );
	}
}