<?php
/* Insert topup order */
if ( ! function_exists( 'wpj_insert_topup_purchase_order' ) ) {
	function wpj_insert_topup_purchase_order( $args = [] ) {
		// Package info
		$package_id = ! empty( $args['package_id'] ) ? $args['package_id'] : WPJ_Form::get( 'package_id' );

		// User info
		$user_id = ! empty( $args['user_id'] ) ? $args['user_id'] : get_current_user_id();

		// Date info
		$added_on = ! empty( $args['added_on'] ) ? $args['added_on'] : current_time( 'timestamp', 1 );

		// Payment info
		$payment_status  = ! empty( $args['payment_status'] ) ? $args['payment_status'] : 'pending';
		$payment_gateway = ! empty( $args['payment_gateway'] ) ? $args['payment_gateway'] : WPJ_Form::get( 'pay_for_item' );

		// Tax
		$tax = ! empty( $args['tax'] ) ? $args['tax'] : 0;

		// Currency
		$currency = ! empty( $args['currency'] ) ? $args['currency'] : apply_filters( 'wpjobster_take_allowed_currency_' . $payment_gateway, '' );

		if ( empty( $currency ) ) $currency = wpj_get_site_currency();

		// Final order price
		if ( $currency )
			$payable_amount_exchanged = wpj_number_format_special_exchange( wpj_get_topup_amount_by_package( $package_id, 'cost' ), '1', $currency );
		else
			$payable_amount_exchanged = wpj_number_format_special_exchange( wpj_get_topup_amount_by_package( $package_id, 'cost' ) );

		// Insert order to database
		$orderid = wpj_insert_topup_order(
			[
				'package_id'                 => $package_id,
				'user_id'                    => $user_id,
				'package_amount'             => wpj_get_topup_amount_by_package( $package_id, 'cost' ),
				'added_on'                   => $added_on,
				'payment_status'             => $payment_status,
				'payment_gateway_name'       => $payment_gateway,
				'tax'                        => $tax,
				'package_cost_without_tax'   => wpj_number_format_special_exchange( wpj_get_topup_amount_by_package( $package_id, 'cost' ), '1', $currency ),
				'package_credit_without_tax' => wpj_number_format_special_exchange( wpj_get_topup_amount_by_package( $package_id, 'credit' ), '1', $currency ),
				'currency'                   => $currency,
			],
			[ '%d', '%d', '%f', '%d', '%s', '%s', '%f', '%f', '%f', '%s' ]
		);

		do_action( 'wpj_after_insert_topup_order', $orderid );

		// Insert payment to database
		wpj_insert_payment(
			[
				'payment_status'         => $payment_status == 'completed' ? 1 : 0,
				'payment_gateway'        => $payment_gateway,
				'payment_type'           => 'topup',
				'payment_type_id'        => $orderid,
				'fees'                   => 0,
				'amount'                 => wpj_get_topup_amount_by_package( $package_id, 'cost' ),
				'datemade'               => current_time( 'timestamp', 1 ),
				'tax'                    => 0,
				'currency'               => wpj_get_site_default_currency(),
				'final_amount'           => wpj_get_topup_amount_by_package( $package_id, 'cost' ),
				'final_amount_exchanged' => $payable_amount_exchanged,
				'final_amount_currency'  => $currency,
			],
			[ '%d', '%s', '%s', '%d', '%f', '%f', '%d', '%f', '%s', '%f', '%f', '%s' ]
		);

		return $orderid;
	}
}

/* Get topup order details */
if ( ! function_exists( 'wpj_get_topup_order_details' ) ) {
	function wpj_get_topup_order_details( $ret = '', $orderid = '' ) {
		if ( empty( $orderid ) ) {
			global $wp_query;

			if ( ! empty( $wp_query->query_vars['oid'] ) ) {
				$orderid = $wp_query->query_vars['oid'];
			}
		}

		$order = wpj_get_topup_order( 'DISTINCT *', ['id' => $orderid], 'row' );

		if ( ! empty( $order ) && $order->payment_status == 'pending' ) {
			$order_status_class = 'pending';
			$order_status_lbl   = __( 'Deposit Waiting', 'wpjobster' );
			$order_status_desc  = __( 'The transaction will start as soon as you complete the payment process.', 'wpjobster' );

		} elseif ( ! empty( $order ) && $order->payment_status == 'failed' ) {
			$order_status_class = 'failed';
			$order_status_lbl   = __( 'Failed', 'wpjobster' );
			$order_status_desc  = __( 'An error occurred while making the payment. If you want to resume payment, you will need to create a new order.', 'wpjobster' );

		} elseif ( ! empty( $order ) && $order->payment_status == 'cancelled' ) {
			$order_status_class = 'cancelled';
			$order_status_lbl   = __( 'Cancelled Pending Order', 'wpjobster' );
			$order_status_desc  = __( 'You have canceled the payment for this order. If you want to resume payment, you will need to create a new order.', 'wpjobster' );

		} elseif ( ! empty( $order ) && $order->payment_status == 'completed' ) {
			$order_status_class = '';
			$order_status_lbl   = __( 'Deposit Completed', 'wpjobster' );
			$order_status_desc  = __( 'Thank you for the payment.', 'wpjobster' );

		} else {
			$order_status_class = '';
			$order_status_lbl   = ! empty( $order->payment_status ) ? wpj_translate_string( $order->payment_status ) : __( 'Unknown Status', 'wpjobster' );
			$order_status_desc  = __( 'Unknown Description', 'wpjobster' );

		}

		$payment_method = ! empty( $order->payment_gateway_name ) ? wpj_translate_string( $order->payment_gateway_name ) : __( 'Unknown Payment Method', 'wpjobster' );

		$data = [
			'orderid'            => $orderid,
			'payment_type'       => 'topup',
			'current_order'      => ! empty( $order ) ? $order : '',
			'date_made'          => ! empty( $order ) ? $order->added_on : '',
			'uid'                => ! empty( $order ) ? $order->user_id : '',
			'order_status_class' => $order_status_class,
			'order_status_lbl'   => $order_status_lbl,
			'order_status_desc'  => '<span class="js-package-id" data-package-id="' . ( isset( $order->package_id ) ? $order->package_id : '' ) . '">' . $order_status_desc . '</span>',
			'payment_method'     => '<span class="js-payment-method" data-method="' . ( isset( $order->payment_gateway_name ) ? $order->payment_gateway_name : '' ) . '">' . ucfirst( $payment_method ) . '</span>'
		];


		if ( $ret && ! empty( $data[$ret] ) )
			return $data[$ret];

		return $data;
	}
}

/* Get topup package */
if ( ! function_exists( 'wpj_get_topup_amount_by_package' ) ) {
	function wpj_get_topup_amount_by_package( $package_id, $return = '' ) {
		$topup_packages = wpj_get_option( 'topup-packages-settings' );

		$package_cost   = ! empty( $topup_packages['topup_cost'][$package_id] ) ? $topup_packages['topup_cost'][$package_id] : 0;
		$package_credit = ! empty( $topup_packages['topup_credit'][$package_id] ) ? $topup_packages['topup_credit'][$package_id] : 0;

		if ( $return == 'cost' )
			return $package_cost;

		if ( $return == 'credit' )
			return $package_credit;

		return [ 'cost' => $package_cost, 'credit' => $package_credit ];
	}
}

/* Cancel topup pending order */
if ( ! function_exists( 'wpj_cancel_topup_pending_order' ) ) {
	function wpj_cancel_topup_pending_order( $order_id = '', $payment_gateway = '' ) {
		if ( ! $order_id )
			$order_id = $_REQUEST['order_id'];

		if ( ! $payment_gateway )
			$payment_gateway = $_REQUEST['payment_gateway'];

		wpj_update_topup_order(
			['payment_status' => 'cancelled'],
			['id' => $order_id, 'payment_gateway_name' => $payment_gateway, 'user_id' => get_current_user_id()]
		);

		do_action( 'wpj_after_order_is_cancelled', $order_id, 'topup' );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}