<?php
if ( ! function_exists( 'wpj_get_user_earned_amount' ) ) {
	function wpj_get_user_earned_amount( $uid ) {
		if ( ! $uid ) $uid = get_current_user_id();

		$query_where = ['p.post_author' => $uid, 'o.payment_status' => 'completed', 'o.seller_confirmation' => 1, 'o.clearing_period' => 1];

		$orders = wpj_get_job_order_post( '*', $query_where, 'results' );

		$gross_value = 0;

		if ( $orders ) {
			foreach ( $orders as $key => $row ) {
				$gross_value += apply_filters( 'wpj_total_gross_sales_filter', wpj_get_order_total_price( $row )['amount'], $row, 'gross' );
			}
		}

		$net_value = 0;

		if ( $orders ) {
			foreach ( $orders as $key => $row ) {
				$net_value += apply_filters( 'wpj_total_net_sales_filter', wpj_get_order_total_price( $row )['seller_commission'], $row, 'net' );
			}
		}

		return ['gross' => $gross_value, 'net' => $net_value];
	}
}

if ( ! function_exists( 'wpj_get_withdrawal_amount' ) ) {
	function wpj_get_withdrawal_amount( $uid = '' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		$amount = wpj_get_withdrawal_order( 'SUM(amount)', ['uid' => $uid, 'done' => 1], 'var' );

		if ( ! $amount || $amount < 0 ) {
			$amount = '0';
		}

		return wpj_show_price( $amount );
	}
}

if ( ! function_exists( 'wpj_get_pending_clearance_amount' ) ) {
	function wpj_get_pending_clearance_amount( $uid = '' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		$query_where = ['p.post_author' => $uid, 'o.done_seller' => 1, 'o.done_buyer' => 1, 'o.completed' => 1, 'o.closed' => 0, 'o.clearing_period' => 2];

		$orders = wpj_get_job_order_post( 'o.id, o.mc_gross, o.custom_extras, tips', $query_where, 'results' );

		$pending_clearance = 0;

		foreach ( $orders as $gpc ) {
			$total_pending_clearance = apply_filters( 'wpj_pending_clearance_seller_update_filter', $gpc->mc_gross, $gpc );

			// custom extras total
			$total_custom_extras = 0;
			$custom_extras       = wpj_json_decode( wpj_stripslashes( $gpc->custom_extras ) );

			if ( $custom_extras ) { $i = 0;
				foreach ( $custom_extras as $custom_extra ) {
					if ( $custom_extra->paid ) {
						$custom_extra_ord = wpj_get_custom_extra_order( '*', ['order_id' => $gpc->id, 'custom_extra_id' => $i], 'row' );

						if ( isset( $custom_extra_ord->id ) ) {
							$custom_extra_payment = wpj_get_payment([
								'payment_type'    => 'custom_extra',
								'payment_type_id' => $custom_extra_ord->id
							]);

							$total_custom_extras += $custom_extra_payment->amount;
						}
					} $i++;
				}
			}

			// tips
			$total_tips = 0;
			$tips       = wpj_json_decode( wpj_stripslashes( $gpc->tips ) );

			if ( $tips ) { $i = 0;
				foreach ( $tips as $tip ) {
					if ( $tip->paid ) {
						$tips_ord     = wpj_get_tips_order( '*', ['order_id' => $gpc->id, 'tips_id' => $i], 'row' );
						$tips_payment = wpj_get_payment([
							'payment_type'    => 'tips',
							'payment_type_id' => $tips_ord->id,
						]);

						$total_tips += $tips_payment->amount;
					} $i++;
				}
			}

			$total_amount      = $total_pending_clearance + $total_custom_extras + $total_tips;
			$pending_clearance += ( $total_amount - wpj_get_site_fee_by_amount( $total_amount, $gpc->id, $uid ) );
		}

		return $pending_clearance > 0 ? wpj_show_price( $pending_clearance ) : '0';
	}
}

if ( ! function_exists( 'wpj_get_active_orders_price' ) ) {
	function wpj_get_active_orders_price( $uid = '' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		$amount = wpj_get_job_order( 'SUM(mc_gross)', ['uid' => $uid, 'done_seller' => 0, 'done_buyer' => 0, 'closed' => 0], 'var' );

		if ( ! $amount || $amount < 0 ) {
			$amount = '0';
		}

		return wpj_show_price( $amount );
	}
}

if ( ! function_exists( 'wpj_get_ongoing_jobs_count' ) ) {
	function wpj_get_ongoing_jobs_count( $ret = '', $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$is_seller = apply_filters( 'hide_for_buyers', true, $uid );

		$as_seller = wpj_get_sales_orders( $uid, 'active' ) ? intval( wpj_get_sales_orders( $uid, 'active' ) ) : __( 'None', 'wpjobster' );
		$as_buyer  = wpj_get_shopping_orders( $uid, 'active' ) ? intval( wpj_get_shopping_orders( $uid, 'active' ) ) : __( 'None', 'wpjobster' );

		$value = intval( wpj_get_sales_orders( $uid, 'active' ) ) + intval( wpj_get_shopping_orders( $uid, 'active' ) );

		if ( ! $value ) { $value = __( 'None', 'wpjobster' ); }

		$tooltip = sprintf( __( 'As buyer: %s', 'wpjobster' ), $as_buyer );

		if ( $is_seller ) {
			$tooltip .= '<br>';
			$tooltip .= sprintf( __( 'As seller: %s', 'wpjobster' ), $as_seller );
		}

		$args = [
			'as_seller' => $as_seller,
			'as_buyer'  => $as_buyer,
			'total'     => $value,
			'tooltip'   => $tooltip
		];

		return $ret && isset( $args[$ret] ) ? $args[$ret] : $args;
	}
}

if ( ! function_exists( 'wpj_get_completed_jobs_count' ) ) {
	function wpj_get_completed_jobs_count( $ret = '', $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$is_seller = apply_filters( 'hide_for_buyers', true, $uid );

		$as_seller = wpj_get_sales_orders( $uid, 'completed' ) ? intval( wpj_get_sales_orders( $uid, 'completed' ) ) : __( 'None', 'wpjobster' );
		$as_buyer  = wpj_get_shopping_orders( $uid, 'completed' ) ? intval( wpj_get_shopping_orders( $uid, 'completed' ) ) : __( 'None', 'wpjobster' );

		$value = intval( wpj_get_sales_orders( $uid, 'completed' ) ) + intval( wpj_get_shopping_orders( $uid, 'completed' ) );

		if ( ! $value ) { $value = __( 'None', 'wpjobster' ); }

		$tooltip = sprintf( __( 'As buyer: %s', 'wpjobster' ), $as_buyer );

		if ( $is_seller ) {
			$tooltip .= '<br>';
			$tooltip .= sprintf( __( 'As seller: %s', 'wpjobster' ), $as_seller );
		}

		$args = [
			'as_seller' => $as_seller,
			'as_buyer'  => $as_buyer,
			'total'     => $value,
			'tooltip'   => $tooltip
		];

		return $ret && isset( $args[$ret] ) ? $args[$ret] : $args;
	}
}

if ( ! function_exists( 'wpj_get_cancelled_jobs_count' ) ) {
	function wpj_get_cancelled_jobs_count( $ret = '', $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$is_seller = apply_filters( 'hide_for_buyers', true, $uid );

		$as_seller = wpj_get_sales_orders( $uid, 'cancelled' ) ? intval( wpj_get_sales_orders( $uid, 'cancelled' ) ) : __( 'None', 'wpjobster' );
		$as_buyer  = wpj_get_shopping_orders( $uid, 'cancelled' ) ? intval( wpj_get_shopping_orders( $uid, 'cancelled' ) ) : __( 'None', 'wpjobster' );

		$value = intval( wpj_get_sales_orders( $uid, 'cancelled' ) ) + intval( wpj_get_shopping_orders( $uid, 'cancelled' ) );

		if ( ! $value ) { $value = __( 'None', 'wpjobster' ); }

		$tooltip = sprintf( __( 'As buyer: %s', 'wpjobster' ), $as_buyer );

		if ( $is_seller ) {
			$tooltip .= '<br>';
			$tooltip .= sprintf( __( 'As seller: %s', 'wpjobster' ), $as_seller );
		}

		$args = [
			'as_seller' => $as_seller,
			'as_buyer'  => $as_buyer,
			'total'     => $value,
			'tooltip'   => $tooltip
		];

		return $ret && isset( $args[$ret] ) ? $args[$ret] : $args;
	}
}

if ( ! function_exists( 'wpj_get_posted_jobs_count' ) ) {
	function wpj_get_posted_jobs_count( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$posted_jobs_section = apply_filters( 'hide_for_buyers', true, $uid );

		if ( $posted_jobs_section ) {
			$value = wpj_get_user_jobs_count( $uid, 'active' ) ? intval( wpj_get_user_jobs_count( $uid, 'active' ) ) : __( 'None', 'wpjobster' );

		} else {
			$value = __( 'None', 'wpjobster' );

		}

		return $value;
	}
}

if ( ! function_exists( 'wpj_get_ongoing_requests_count' ) ) {
	function wpj_get_ongoing_requests_count( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		return wpj_get_shopping_orders( $uid, 'active_custom_offer' ) ? intval( wpj_get_shopping_orders( $uid, 'active_custom_offer' ) ) : __( 'None', 'wpjobster' );
	}
}

if ( ! function_exists( 'wpj_get_completed_requests_count' ) ) {
	function wpj_get_completed_requests_count( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		return wpj_get_shopping_orders( $uid, 'completed_custom_offer' ) ? intval( wpj_get_shopping_orders( $uid, 'completed_custom_offer' ) ) : __( 'None', 'wpjobster' );
	}
}

if ( ! function_exists( 'wpj_get_cancelled_requests_count' ) ) {
	function wpj_get_cancelled_requests_count( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		return wpj_get_shopping_orders( $uid, 'cancelled_custom_offer' ) ? intval( wpj_get_shopping_orders( $uid, 'cancelled_custom_offer' ) ) : __( 'None', 'wpjobster' );
	}
}

if ( ! function_exists( 'wpj_get_posted_requests_count' ) ) {
	function wpj_get_posted_requests_count( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		return wpj_get_user_requests( $uid, 'active', 'count' ) ? intval( wpj_get_user_requests( $uid, 'active', 'count' ) ) : __( 'None', 'wpjobster' );
	}
}