<?php
if ( ! function_exists( 'wpj_get_user_id' ) ) {
	function wpj_get_user_id( $uid = '' ) {
		if ( $uid && is_numeric( $uid ) ) return $uid;

		if ( ! $uid ) {
			global $wp_query;

			if ( ! empty ( $wp_query->query_vars['username'] ) ) {
				$user = get_user_by( 'login', $wp_query->query_vars['username'] );

				if ( isset( $user->ID ) ) $uid = $user->ID;
			}
		}

		if ( ! $uid ) $uid = wpj_get_pm_interlocutor_from_url( 'id' );

		if ( ! $uid ) {
			$pid = wpj_get_post_id();

			if ( $pid && ( get_post_type( $pid ) == 'job' || get_post_type( $pid ) == 'request' ) ) {
				$uid = get_post_field( 'post_author', $pid );
			}
		}

		if ( ! $uid ) $uid = get_current_user_id();

		return $uid;
	}
}

if ( ! function_exists( 'wpj_get_userdata' ) ) {
	function wpj_get_userdata( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		$user_data = get_userdata( $uid );

		if ( ! is_object( $user_data ) ) {
			$user_data = new stdClass();

			$user_data->ID            = $uid;
			$user_data->first_name    = __( 'Deleted', 'wpjobster' );
			$user_data->last_name     = __( 'User', 'wpjobster' );
			$user_data->user_login    = __( 'Deleted User', 'wpjobster' );
			$user_data->user_nicename = __( 'Deleted User', 'wpjobster' );
			$user_data->display_name  = __( 'Deleted User', 'wpjobster' );
			$user_data->user_email    = '';
		}

		return $user_data;
	}
}

if ( ! function_exists( 'wpj_user' ) ) {
	function wpj_user( $user_id = '', $meta_name = 'ID', $meta_value = [] ) {
		if ( ! $user_id ) $user_id = wpj_get_user_id();

		$accepted_metas = [
			'Full texts',
			'ID',
			'user_login',
			'user_pass',
			'user_nicename',
			'user_email',
			'user_url',
			'user_registered',
			'user_activation_key',
			'user_status',
			'display_name'
		];

		if ( ! in_array( $meta_name, $accepted_metas ) ) {
			if ( isset( $meta_value ) && is_array( $meta_value ) ) {
				if ( is_array( get_user_meta( $user_id, $meta_name, 1 ) ) ) {
					return get_user_meta( $user_id, $meta_name, 1 );

				} else {
					return str_replace( '<br />', '', htmlspecialchars_decode( get_user_meta( $user_id, $meta_name, 1 ) ) );

				}

			} else {
				update_user_meta( $user_id, $meta_name, $meta_value );

			}

		} else {
			if ( isset( $meta_value ) && is_array( $meta_value ) ) {
				$user_info = get_userdata( $user_id );

				return is_object( $user_info ) ? str_replace( '<br />', '', htmlspecialchars_decode ( $user_info->$meta_name ) ) : '';

			} else {
				wp_update_user( ['ID' => $user_id, $meta_name => $meta_value] );

			}

		}

		return true;
	}
}

if ( ! function_exists( 'wpj_get_user_id_by_IP' ) ) {
	function wpj_get_user_id_by_IP( $ip = '', $ret_type = 'first' ) {
		if ( ! $ip ) $ip = wpj_get_user_ip();

		if ( $ip ) {
			$users = get_users( ['meta_key' => 'ip_reg', 'meta_value' => $ip] );

			if ( $users && $ret_type == 'all' ) return $users;

			if ( isset( $users[0]->ID ) ) return $users[0]->ID;
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_export_user_transactions' ) ) {
	function wpj_export_user_transactions( $uid = '', $start_date = '', $end_date = '' ) {
		$uid = WPJ_Form::post( 'uid', $uid );

		if ( ! $uid ) $uid = get_current_user_id();

		$start_date = WPJ_Form::post( 'start_date', $start_date );
		$end_date   = WPJ_Form::post( 'end_date', $end_date );

		$between = ['column' => 'datemade', 'date_min' => $start_date, 'date_max' => $end_date];

		$results = wpj_get_payment_transaction( '*', ['uid' => $uid], 'results', $between );

		if ( $results ) {
			$user_info = get_userdata( $uid );

			// Set CSV Separator
			$delimiter = ',';

			// Create a file pointer
			$f = fopen( 'php://memory', 'w' );

			// Set column headers
			$fields = [ 'ID', 'TRANSACTION ID', 'ORDER ID', 'DESCRIPTION', 'DATE', 'AMOUNT', 'CURRENCY' ];

			fputcsv( $f, $fields, $delimiter );

			// Output each row of the data, format line as csv and write to file pointer
			$id = 0;
			foreach ( $results as $key => $row ) { $id++;
				if ( $row->tp == 0 ) $sign = '-';
				elseif ( $row->tp == 1 ) $sign = '+';
				else $sign = '';

				$reason = wpj_stripslashes( $row->reason );

				preg_match_all( '/<a[^>]+href=([\'"])(?<href>.+?)\1[^>]*>/i', $reason, $order_url );

				$lineData = [
					$id,
					$row->id,
					$row->oid . ' (#' . wpj_camouflage_oid( $row->oid, $row->datemade ) . ')' ,
					isset( $order_url['href'][0] ) ? '=HYPERLINK("' . $order_url['href'][0] . '", "' . strip_tags( $row->reason ) . '")' : strip_tags( $row->reason ),
					wpj_date( wpj_get_option( 'date_format' ) . ' - ' . wpj_get_option( 'time_format' ), $row->datemade ),
					$sign . wpj_show_price_classic( $row->amount ),
					$sign . wpj_deciphere_amount_classic( $row->payedamount )
				];

				fputcsv( $f, $lineData, $delimiter );
			}

			// Move back to beginning of file
			fseek( $f, 0 );

			// Set headers to download file rather than displayed
			$filename = $user_info->user_login . '-transactions-' . date( 'Y-m-d' ) . '.csv';

			header( 'Content-Type: text/csv' );
			header( 'Content-Disposition: attachment; filename="' . apply_filters( 'wpj_export_user_transactions_filename_filter', $filename, $user_info->user_login ) . '";' );

			// Output all remaining data on a file pointer
			fpassthru( $f );

		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

// UPDATE

if ( ! function_exists( 'wpj_save_user_registration_information' ) ) {
	function wpj_save_user_registration_information( $user_id ) {
		// Social login avatar
		update_user_meta( $user_id, 'wsl_photo_updated', '0' );

		// Save phone number and country number
		if ( wpj_get_option( 'wpjobster_enable_phone_number' ) == 'yes' ) {
			update_user_meta( $user_id, 'cell_number', $_POST['cell_number'] );
		}

		// Save user company
		if ( wpj_get_option( 'wpjobster_enable_user_company' ) == 'yes' ) {
			update_user_meta( $user_id, 'user_company', $_POST['user_company'] );
		}

		// Save agree tos and privacy
		if ( wpj_get_option( 'wpjobster_register_tos_and_privacy' ) == 'text' ) {
			update_user_meta( $user_id, 'wpj_agree_tos_privacy', 1 );

		} elseif ( wpj_get_option( 'wpjobster_register_tos_and_privacy' ) == 'checkbox' ) {
			if ( isset( $_POST['wpj_agree_tos_privacy'] ) ) {
				update_user_meta( $user_id, 'wpj_agree_tos_privacy', 1 );
			}

		}

		// Set role
		if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
		}

		if ( is_plugin_active( 'di-aiosc/di-aiosc.php' ) ) {
			$user = new WP_User( $user_id );

			global $aiosc_settings;

			$role = $aiosc_settings->get( 'default_role' );

			$user->add_cap( $role );
		}

		// Email verification
		$user_data = get_userdata( $user_id );

		$email_key_generated = hash( 'sha256', rand( 0, 1000000 ), false );

		update_user_meta( $user_id, 'uz_email_verification_key', $email_key_generated );
		update_user_meta( $user_id, 'uz_email_verification', 0 );

		$email_key           = $email_key_generated;
		$email_key_processed = hash( 'sha256', $user_data->user_nicename . $email_key, false );
		$email_verification  = get_permalink( wpj_get_option( 'wpjobster_verify_email_page_id' ) ) . "?username=" . $user_data->user_nicename . "&key=" . $email_key_processed;

		// User IP
		$ip = wpj_get_user_ip();

		update_user_meta( $user_id, 'ip_reg', $ip );

		// Autodetect details
		$info = wpj_save_autodetected_user_info();

		if ( $info ) {
			if ( ! get_user_meta( $user_id, 'city', true ) && ( isset( $info->city_name ) || isset( $info->cityName ) ) )
				update_user_meta( $user_id, 'city', ( isset( $info->city_name ) ? $info->city_name : $info->cityName ) );

			if ( ! get_user_meta( $user_id, 'zip', true ) && ( isset( $info->zip_code ) || isset( $info->zipCode ) ) )
				update_user_meta( $user_id, 'zip', ( isset( $info->zip_code ) ? $info->zip_code : $info->zipCode ) );

			if ( ! get_user_meta( $user_id, 'state', true ) && ( isset( $info->region_name ) || isset( $info->regionName ) ) )
				update_user_meta( $user_id, 'state', ( isset( $info->region_name ) ? $info->region_name : $info->regionName ) );

			if ( ! get_user_meta( $user_id, 'country', true ) && ( isset( $info->country_name ) || isset( $info->countryName ) ) )
				update_user_meta( $user_id, 'country', ( isset( $info->country_name ) ? $info->country_name : $info->countryName ) );

			if ( ! get_user_meta( $user_id, 'country_code', true ) && ( isset( $info->country_code ) || isset( $info->countryCode ) ) )
				update_user_meta( $user_id, 'country_code', ( isset( $info->country_code ) ? $info->country_code : $info->countryCode ) );

			if ( ! get_user_meta( $user_id, 'wpj_user_latitude', true ) && isset( $info->latitude ) )
				update_user_meta( $user_id, 'wpj_user_latitude', $info->latitude );

			if ( ! get_user_meta( $user_id, 'wpj_user_longitude', true ) && isset( $info->longitude ) )
				update_user_meta( $user_id, 'wpj_user_longitude', $info->longitude );
		}

		// User timezone
		$wpjobster_user_time_zone = wpj_get_option( 'wpjobster_user_time_zone' );

		if ( ! get_user_meta( $user_id, 'timezone_select', true ) ) {
			if ( $wpjobster_user_time_zone != 'autodetect' ) {
				update_user_meta( $user_id, 'timezone_select', $wpjobster_user_time_zone );

			} else {
				$user_country_code = wpj_get_country_code_by_ip( $ip );

				if ( ! $user_country_code || $user_country_code == '-' )
					$user_country_code = get_user_meta( $user_id, 'country_code', true );

				if ( $user_country_code && $user_country_code != '-' ) {
					$timezone = DateTimeZone::listIdentifiers( DateTimeZone::PER_COUNTRY, $user_country_code );

					if ( isset( $timezone[0] ) ) {
						update_user_meta( $user_id, 'timezone_select', $timezone[0] );
					}
				}

			}
		}

		// User level (default)
		$wpjobster_default_level_nr = wpj_get_option( 'wpjobster_default_level_nr' );

		if ( is_numeric( $wpjobster_default_level_nr )
			&& $wpjobster_default_level_nr > 0
			&& $wpjobster_default_level_nr <= 3
		) {
			update_user_meta( $user_id, 'user_level', $wpjobster_default_level_nr );

			if ( $wpjobster_default_level_nr == 3 || $wpjobster_default_level_nr == 2 ) {
				update_user_meta( $user_id, 'date_toclear', strtotime( '+2 month', time() ) );

			} else {
				update_user_meta( $user_id, 'date_toclear', strtotime( '+1 month', time() ) );

			}

		} else {
			update_user_meta( $user_id, 'user_level', "0" );
			update_user_meta( $user_id, 'date_toclear', strtotime( '+1 month', time() ) );

		}

		// Other fields
		if ( $_POST ) {
			$skiped_fields = [ 'cell_number', 'user_company', 'wpj_agree_tos_privacy' ];

			foreach ( $_POST AS $key => $val ) {
				if ( ! in_array( $key, $skiped_fields ) ) {
					if ( is_string( $val ) ) {
						update_user_meta( $user_id, $key, wpj_validate_input_content( $val ) );
					} elseif ( is_array( $val ) ) {
						update_user_meta( $user_id, $key, json_encode( array_values( array_filter( $val ) ) ) );
					} else {
						update_user_meta( $user_id, $key, $val );
					}
				}
			}
		}

		// Create shoutout offer
		if ( wpj_get_option( 'wpjobster_enable_shoutout_offer_number' ) == 'yes' && wpj_get_user_account_type( $user_id ) == 'seller' ) {
			$pid = wpj_get_auto_draft_post( $user_id, 'job' );

			update_user_meta( $user_id, 'first_job', $pid );

			$_POST['aoe_form_submitted']         = true;
			$_POST['post_new_or_edit_job_field'] = true;
			$_POST['pid']                        = $pid;

			$JobsNewEditClass = new WPJJobsNewEdit();
			$JobsNewEditClass->savePostData( $pid, 'new-job', '', true );
		}

		// Send emails
		wpj_notify_user_translated( 'user_new', $user_id, [
			'##username##'           => wpj_get_user_display_type( $user_data->ID ),
			'##email_verification##' => $email_verification,
			'##receiver_email##'     => $user_data->user_email
		] );

		if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
		}

		if ( ! is_plugin_active( 'wpjobster-account-segregation/wpjobster-account-segregation.php' ) ) {
			wpj_notify_user_translated( 'user_admin_new', 'admin', [
				'##username##'   => wpj_get_user_display_type( $user_data->ID ),
				'##user_email##' => $user_data->user_email
			] );
		}
	}
}

if ( ! function_exists( 'wpj_save_user_settings_information' ) ) {
	function wpj_save_user_settings_information() {
		$err_content = '';

		if ( ! is_demo_user() ) {
			$uid = get_current_user_id();

			// Email field
			if ( isset( $_POST['email'] ) ) {
				if ( ! empty( $_POST['email'] ) ) {
					$user_info = get_userdata( $uid );
					$old_email = $user_info->user_email;
					$new_email = trim( $_POST['email'] );

					if ( $old_email != $new_email ) {
						if ( email_exists( $new_email ) ) {
							$err_content = __( 'This email is already registered, please choose another one.', 'wpjobster' );

						} else {
							wp_update_user( ['ID' => $uid, 'user_email' => $new_email] );

							$email_key_generated = hash( 'sha256', rand( 0, 1000000 ), false );

							update_user_meta( $uid, 'uz_email_verification_key', $email_key_generated );
							update_user_meta( $uid, 'uz_email_verification', 0 );

							$email_key           = $email_key_generated;
							$email_key_processed = hash( 'sha256', $user_info->user_nicename . $email_key, false );
							$email_verification  = get_permalink( wpj_get_option( 'wpjobster_verify_email_page_id' ) ) . "?username=" . $user_info->user_nicename . "&key=" . $email_key_processed;

							if ( wpj_get_option( 'wpjobster_verify_email' ) != 'no' ) {
								wpj_notify_user_translated( 'user_verification', $uid, [ '##email_verification##' => $email_verification, '##receiver_email##' => $new_email ] );
							}

							do_action( 'wpj_after_mail_save', $uid );
						}
					}
				}
			}

			// Phone verification
			if ( isset( $_POST['cell_number'] ) ) {
				if ( wpj_user( $uid, 'cell_number' ) != $_POST['cell_number'] ) {
					update_user_meta( $uid, 'uz_phone_verification', 0 );
				}

				update_user_meta( $uid, 'cell_number', wpj_validate_input_content( $_POST['cell_number'] ) );
			}

			// Country field
			if ( isset( $_POST['country_code'] ) ) {
				$country_name = wpj_get_country_name_by_code( wpj_validate_input_content( $_POST['country_code'] ) );

				update_user_meta( $uid, 'country', $country_name );
			}

			// Custom fields
			$custom_field = new WPJ_Custom_Fields( $uid, 'up' );
			$custom_field->saveFieldsContent();

			// Bank fields
			$bank_fields = ['bank_bank_name', 'bank_bank_address', 'bank_account_name', 'bank_account_number', 'bank_account_currency', 'bank_additional_info'];

			foreach ( $bank_fields as $bank_field ) {
				if ( apply_filters( 'wpj_payments_display_' . $bank_field . '_field', true ) ) {
					if ( isset( $_POST[$bank_field] ) ) {
						update_user_meta( $uid, $bank_field, wpj_validate_input_content( $_POST[$bank_field] ) );
					}
				}
			}

			// Social media fileds
			$providers = wpj_get_user_social_media_providers();

			if ( $providers ) {
				foreach ( $providers as $key => $provider ) {
					if ( isset( $_POST['social_media_' . $key] ) ) {
						update_user_meta( $uid, 'social_media_' . $key, preg_replace( "(^https?://)", "", $_POST['social_media_' . $key] ) );
					}
				}
			}

			// Password field
			if ( ! empty( $_POST['current_password'] ) && ! empty( $_POST['password'] ) && ! empty( $_POST['repeat_password'] ) ) {
				$user = get_user_by( 'id', $uid );

				if ( empty( $_POST['current_password'] ) || ! wp_check_password( $_POST['current_password'], $user->data->user_pass, $user->ID ) ) {
					$err_content = __( 'Your old password was incorrectly typed.', 'wpjobster' );

				} elseif ( $_POST['password'] != $_POST['repeat_password'] ) {
					$err_content = __( 'Passwords do not match.', 'wpjobster' );

				} elseif ( $_POST['current_password'] == $_POST['password'] ) {
					$err_content = __( 'Password must differ from old password.', 'wpjobster' );

				} else {
					wp_set_password( $_POST['password'], $uid );

				}
			}

			// Other fields
			if ( $_POST ) {
				$skiped_fields = [ 'email', 'cell_number', 'bank_bank_name', 'bank_bank_address', 'bank_account_name', 'bank_account_number', 'bank_account_currency', 'bank_additional_info', 'current_password', 'password', 'repeat_password' ];

				if ( $providers ) {
					foreach ( $providers as $key => $provider ) {
						$skiped_fields[] = 'social_media_' . $key;
					}
				}

				foreach ( $_POST AS $key => $val ) {
					if ( ! in_array( $key, $skiped_fields ) ) {
						if ( is_string( $val ) )
							update_user_meta( $uid, $key, trim( htmlspecialchars( wpj_validate_input_content( $val ) ) ) );

						elseif ( is_array( $val ) )
							update_user_meta( $uid, $key, json_encode( array_values( array_filter( $val ) ) ) );

						else
							update_user_meta( $uid, $key, $val );
					}
				}
			}

			do_action( 'wpj_after_personal_info_update', $uid );
		}

		if ( wpj_is_ajax_call() ) {
			if ( $err_content )
				echo json_encode( [ 'status' => 'error', 'error' => $err_content ] );

			else
				echo json_encode( [ 'status' => 'success' ] );

			wp_die();
		}
	}
}

if ( ! function_exists( 'wpj_save_autodetected_user_info' ) ) {
	function wpj_save_autodetected_user_info() {
		$ip = wpj_get_user_ip();

		if ( wpj_ipcache_table_exist() ) {
			$row = wpj_get_ip( 'info', ['ipnr' => $ip], 'row' );

			if ( ! $row ) {
				$user_info        = wpj_get_autodetected_user_info();
				$ip2location_data = json_encode( $user_info );

				if ( isset( $user_info->country_code ) || isset( $user_info->countryCode ) ) {
					$country_code = isset( $user_info->country_code ) ? $user_info->country_code : $user_info->countryCode;

					wpj_insert_ip(
						['ipnr' => $ip, 'country' => $country_code, 'info' => $ip2location_data],
						['%s', '%s', '%s']
					);

					return $user_info;
				}

			} elseif ( isset( $row->info ) ) {
				$user_info_row = wpj_json_decode( $row->info );

				if ( isset( $row->country ) ) return $user_info_row;

				else {
					wpj_delete_ip( $ip );

					$user_info        = wpj_get_autodetected_user_info();
					$ip2location_data = json_encode( $user_info );

					if ( isset( $user_info->country_code ) || isset( $user_info->countryCode ) ) {
						$country_code = isset( $user_info->country_code ) ? $user_info->country_code : $user_info->countryCode;

						wpj_insert_ip(
							['ipnr' => $ip, 'country' => $country_code, 'info' => $ip2location_data],
							['%s', '%s', '%s']
						);

						return $user_info;
					}
				}
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_delete_user_account' ) ) {
	function wpj_delete_user_account( $uid = '' ) {
		if ( ! $uid && isset( $_REQUEST['uid'] ) ) {
			$uid = $_REQUEST['uid'];
		}

		if ( wpj_get_sales_orders( $uid, 'active', 'count' ) <= 0 ) {
			wpj_delete_user_info( $uid );

			$user_posts = get_posts( ['numberposts' => -1, 'post_type' => 'any', 'author' => $uid] );

			if ( $user_posts ) {
				foreach ( $user_posts as $user_post ) {
					wp_delete_post( $user_post->ID, true );
				}
			}

			$user_attachments = get_posts( ['numberposts' => -1, 'post_type' => 'attachment', 'author' => $uid] );

			if ( $user_attachments ) {
				foreach ( $user_attachments as $user_attachment ) {
					wp_delete_attachment( $user_attachment->ID, true );
				}
			}

			wp_delete_user( $uid );

		} else {
			if ( wpj_is_ajax_call() ) echo 'not_allowed';
			else return false;

		}

		if ( wpj_is_ajax_call() ) wp_die();
		else return true;
	}
}

// GET

if ( ! function_exists( 'wpj_get_autodetected_user_info' ) ) {
	function wpj_get_autodetected_user_info() {
		$ip        = wpj_get_user_ip();
		$ipLiteKey = wpj_get_option( 'wpjobster_ip_key_db' );

		$url = "https://api.ip2location.io/?ip=$ip&key=$ipLiteKey";
		$ip2location_data = wpj_get_data_with_cURL( $url );
		$decoded_data = wpj_json_decode( $ip2location_data );

		if ( isset( $decoded_data->error->error_code ) ) {
			$url = "http://api.ipinfodb.com/v3/ip-city/?key=$ipLiteKey&ip=$ip&format=json";
			$ip2location_data = wpj_get_data_with_cURL( $url );
			$decoded_data = wpj_json_decode( $ip2location_data );
		}

		return $decoded_data;
	}
}

if ( ! function_exists( 'wpj_get_user_account_type' ) ) {
	function wpj_get_user_account_type( $uid = '' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		if ( ! function_exists( 'is_plugin_active' ) ) {
			include_once ( ABSPATH . 'wp-admin/includes/plugin.php' );
		}

		if ( $uid ) {
			if ( is_plugin_active( 'wpjobster-account-segregation/wpjobster-account-segregation.php' ) ) {
				if (
					get_user_meta( $uid, 'wpjobster_user_type', true ) == 'buyer'
					|| get_user_meta( $uid, 'wpjobster_user_type', true ) == 'none'
					|| ! get_user_meta( $uid, 'wpjobster_user_type', true )
					|| get_user_meta( $uid, 'wpjobster_temp_user_type', true )
				)
					return 'buyer';

				else
					return 'seller';

			} else
				return 'seller';

		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_user_name_by_id' ) ) {
	function wpj_get_user_name_by_id( $user = '', $return = '' ) {
		if ( ! $user ) $user = wpj_get_user_id();

		if ( $user ) {

			if ( is_object( $user ) && isset( $user->ID ) ) {
				$user_arr = $user;

			} else {
				$user_arr = get_userdata( $user );

			}

			if ( ! empty( $user_arr->user_login ) ) {

				if ( $user_arr->first_name && $user_arr->last_name ) {
					$name = $user_arr->first_name . ' ' . $user_arr->last_name;

				} else if ( $user_arr->last_name ) {
					$name = $user_arr->last_name;

				} else if ( $user_arr->first_name ) {
					$name = $user_arr->first_name;

				} else {
					$name = $user_arr->user_login;

				}

				if ( $return ) {
					if ( $return == 'first_name' && $user_arr->first_name ) {
						$name = $user_arr->first_name;

					} elseif ( $return == 'last_name' && $user_arr->last_name ) {
						$name = $user_arr->last_name;

					} elseif ( $return == 'full_name' && $user_arr->first_name && $user_arr->last_name ) {
						$name = $user_arr->first_name . ' ' . $user_arr->last_name;

					} elseif ( $return == 'full_name_inverted' && $user_arr->last_name && $user_arr->first_name ) {
						$name = $user_arr->last_name . ' ' . $user_arr->first_name;

					} elseif ( $return == 'username' && $user_arr->user_login ) {
						$name = $user_arr->user_login;

					} elseif ( $return == 'display_name' && $user_arr->display_name ) {
						$name = $user_arr->display_name;

					} else {
						$name = $user_arr->user_login;

					}
				}

				return $name;

			} else {
				return sprintf( __( 'Deleted User (ID: %d)', 'wpjobster' ), $user );

			}

		}

		return __( 'No name', 'wpjobster' );
	}
}

if ( ! function_exists( 'wpj_get_user_display_type' ) ) {
	function wpj_get_user_display_type( $uid = '' ) {
		$op_type = wpj_get_option( 'wpjobster_display_name_publicly' );

		if ( $op_type == 'first_name' ) {
			$ret = wpj_get_user_name_by_id( $uid, 'first_name' );

		} elseif ( $op_type == 'last_name' ) {
			$ret = wpj_get_user_name_by_id( $uid, 'last_name' );

		} elseif ( $op_type == 'display_name' ) {
			$ret = wpj_get_user_name_by_id( $uid, 'display_name' );

		} elseif ( $op_type == 'first_last_name' ) {
			$ret = wpj_get_user_name_by_id( $uid, 'full_name' );

		} elseif ( $op_type == 'last_first_name' ) {
			$ret = wpj_get_user_name_by_id( $uid, 'full_name_inverted' );

		}

		if ( empty( $ret ) ) {
			$ret = wpj_get_user_name_by_id( $uid, 'username' );

		}

		return apply_filters( 'wpj_display_name_publicly_filter', $ret, $uid );
	}
}

if ( ! function_exists( 'wpj_get_user_social_media_providers' ) ) {
	function wpj_get_user_social_media_providers() {
		$providers = [
			'dribbble'      => [ 'name' => __( 'Dribbble', 'wpjobster' ),      'icon' => 'dribbble' ],
			'facebook'      => [ 'name' => __( 'Facebook', 'wpjobster' ),      'icon' => 'facebook f' ],
			'github'        => [ 'name' => __( 'Github', 'wpjobster' ),        'icon' => 'github' ],
			'google'        => [ 'name' => __( 'Google', 'wpjobster' ),        'icon' => 'google' ],
			'instagram'     => [ 'name' => __( 'Instagram', 'wpjobster' ),     'icon' => 'instagram' ],
			'linkedin'      => [ 'name' => __( 'Linkedin', 'wpjobster' ),      'icon' => 'linkedin' ],
			'stackoverflow' => [ 'name' => __( 'Stackoverflow', 'wpjobster' ), 'icon' => 'stack overflow' ],
			'tumblr'        => [ 'name' => __( 'Tumblr', 'wpjobster' ),        'icon' => 'tumblr' ],
			'twitter'       => [ 'name' => __( 'Twitter', 'wpjobster' ),       'icon' => 'twitter' ],
		];

		return apply_filters( 'user_social_media_providers_filter', $providers );
	}
}

if ( ! function_exists( 'wpj_get_URL_user' ) ) {
	function wpj_get_URL_user( $type = 'all' ) {
		global $wp_query;

		// Current User
		$current_user    = wp_get_current_user();
		$username_curent = $current_user->user_login;

		// Username from URL
		$username_from_url = isset( $wp_query->query_vars['username'] ) ? urldecode( $wp_query->query_vars['username'] ) : '';

		// Generate User ID
		$username = $username_from_url ? $username_from_url : $username_curent;
		$user     = $username ? get_user_by( 'login', $username ) : '';
		$uid      = isset( $user->ID ) ? $user->ID : '';

		if ( $uid && $type == 'userid' ) {
			return $uid;

		} elseif ( $username && $type == 'username' ) {
			return $username;

		} elseif ( $user && $type == 'userdata' ) {
			return $user;

		} else {
			if ( ! $uid ) return false;

			return [
				'userdata' => $user,
				'username' => $username,
				'userid'   => $uid
			];

		}
	}
}

if ( ! function_exists( 'wpj_get_current_user_role' ) ) {
	function wpj_get_current_user_role() {
		global $current_user;

		if ( isset( $current_user->roles ) ) {
			$user_roles = $current_user->roles;

			if ( isset( $user_roles[0] ) ) {
				return $user_roles[0];
			}
		}

		return false;
	}
}

if ( ! function_exists( 'wpj_get_total_site_users' ) ) {
	function wpj_get_total_site_users( $rated_type = '', $user_type = '' ) {
		if ( ! $rated_type && ! $user_type ) {
			$users = count_users();

			return $users['total_users'];
		}

		$rated_type = strtolower( $rated_type );
		$user_type  = strtolower( $user_type );

		$user_type_cnt       = 0;
		$user_level_cnt      = 0;
		$user_type_level_cnt = 0;

		// user level
		if ( $rated_type == 1 || $rated_type == 'rookie' ) $user_level = 1;
		elseif ( $rated_type == 2 || $rated_type == 'master' ) $user_level = 2;
		elseif ( $rated_type == 3 || $rated_type == 'top_rated' ) $user_level = 3;
		else $user_level = 0;

		$all_users_sql = wpj_get_user( 'ID', '', 'results' );

		if ( $all_users_sql ) {
			foreach ( $all_users_sql as $key => $user ) {

				// user type
				if ( $user_type && wpj_get_user_account_type( $user->ID ) == strtolower( $user_type ) ) {
					$user_type_cnt++;
				}

				if (
					$rated_type
					&& wpj_get_user_level( $user->ID ) == $user_level
				) {
					$user_level_cnt++;
				}

				// user type && user level
				if (
					$user_type && $rated_type
					&& wpj_get_user_account_type( $user->ID ) == strtolower( $user_type )
					&& wpj_get_user_level( $user->ID ) == $user_level
				) {
					$user_type_level_cnt++;
				}
			}
		}

		$users_count = 0;

		if ( $user_type && $rated_type ) {
			$users_count = $user_type_level_cnt;

		} elseif ( $user_type ) {
			$users_count = $user_type_cnt;

		} elseif ( $rated_type ) {
			$users_count = $user_level_cnt;

		}

		return $users_count;
	}
}

if ( ! function_exists( 'wpj_get_up_custom_fields_content' ) ) {
	function wpj_get_up_custom_fields_content() {
		$user_page_id = wpj_get_option( 'wpjobster_user_profile_page_id' );

		$white = [];

		if ( function_exists( 'get_field' ) && function_exists( 'have_rows' ) ) {
			$white_sidebar = get_field( 'white_sidebar', $user_page_id );

			if ( have_rows( 'white_sidebar', $user_page_id ) ) {
				foreach ( $white_sidebar as $w_key => $w_value ) {
					if ( strpos( $w_value['acf_fc_layout'], 'custom_field' ) !== false ) {
						$white[] = $w_value;
					}
				}
			}
		}

		$transparent = [];

		if ( function_exists( 'get_field' ) && function_exists( 'have_rows' ) ) {
			$transparent_sidebar = get_field( 'transparent_sidebar', $user_page_id );

			if ( have_rows( 'transparent_sidebar', $user_page_id ) ) {
				foreach ( $transparent_sidebar as $t_key => $t_value ) {
					if ( strpos( $t_value['acf_fc_layout'], 'custom_field' ) !== false ) {
						$transparent[] = $t_value;
					}
				}
			}
		}

		$main = [];

		if ( function_exists( 'get_field' ) && function_exists( 'have_rows' ) ) {
			$main_content = get_field( 'main_content', $user_page_id );

			if ( have_rows( 'main_content', $user_page_id ) ) {
				foreach ( $main_content as $m_key => $m_value ) {
					if ( strpos( $m_value['acf_fc_layout'], 'custom_field' ) !== false ) {
						$main[] = $m_value;
					}
				}
			}
		}

		return array_merge( $white, $transparent, $main );
	}
}

if ( ! function_exists( 'wpj_get_users_skills_list' ) ) {
	function wpj_get_users_skills_list( $skill_slug = '' ) {
		$user_skills = [];

		$users = get_users( ['meta_key' => 'user_skills'] );

		foreach ( $users as $user ) {
			$skills = get_user_meta( $user->ID, 'user_skills', true );

			foreach ( $skills as $skill ) {
				$user_skills[$skill['slug']] = $skill['name'];
			}
		}

		if ( $skill_slug ) {
			return $user_skills[$skill_slug];

		} else {
			return $user_skills;

		}
	}
}

if ( ! function_exists( 'wpj_get_users_levels_list' ) ) {
	function wpj_get_users_levels_list( $level = '' ) {
		$user_levels_arr = [
			'0' => __( 'New Arrival', 'wpjobster' ),
			'1' => __( 'Rookie Seller', 'wpjobster' ),
			'2' => __( 'Master Seller', 'wpjobster' ),
			'3' => __( 'Top Rated Seller', 'wpjobster' )
		];

		if ( $level || $level == 0 ) {
			return $user_levels_arr[$level];

		} else {
			return $user_levels_arr;

		}
	}
}

// IS

if ( ! function_exists( 'is_demo_user' ) ) {
	function is_demo_user() {
		if ( wpj_get_current_user_role() == "demo_user" ) {
			return 1;
		}

		return 0;
	}
}

if ( ! function_exists( 'is_demo_admin' ) ) {
	function is_demo_admin() {
		if ( wpj_get_current_user_role() == "demo_admin" ) {
			return 1;
		}

		return 0;
	}
}

if ( ! function_exists( 'wpj_is_user_allowed_post_job' ) ) {
	function wpj_is_user_allowed_post_job( $uid = '', $job_price = 0 ) {
		if ( ! $uid ) $uid = get_current_user_id();

		$is_allowed = true;

		if ( wpj_get_option( 'wpjobster_cod_enable' ) == 'yes' && wpj_is_COD_only_payment() ) {
			if ( number_format( wpj_get_user_credit( $uid ), 2 ) < wpj_get_site_fee_by_amount( $job_price, '', $uid ) ) {
				$is_allowed = false;
			}
		}

		return apply_filters( 'wpj_is_user_allowed_post_job_filter', $is_allowed, $uid, $job_price );
	}
}

if ( ! function_exists( 'wpj_is_seller' ) ) {
	function wpj_is_seller( $user_id = '' ) {
		$user_id = $user_id ? $user_id : get_current_user_id();

		if ( function_exists( 'wpjobster_user_type_allowed' ) ) {
			if (
				wpjobster_user_type_allowed( $user_id ) == 'seller'
				|| ( wpjobster_user_type_allowed( $user_id ) == 'buyer' && wpj_get_option( 'wpj_as_hide_menu' ) != 'yes' )
			) {
				return true;

			} else {
				return false;

			}

		} else {
			return true;

		}
	}
}

// HAS

if ( ! function_exists( 'wpj_user_profile_has_icons' ) ) {
	function wpj_user_profile_has_icons( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		if ( function_exists( 'get_field' ) && function_exists( 'have_rows' ) ) {
			if ( have_rows( 'icons', wpj_get_option( 'wpjobster_user_profile_page_id' ) ) ) {
				foreach ( get_field( 'icons', wpj_get_option( 'wpjobster_user_profile_page_id' ) ) as $ws_key => $ws_value ) {

					if ( $ws_value['display_location'] == '' )
						return true;

					if ( $ws_value['display_location'] == 'both_users' )
						return true;

					if ( $uid == get_current_user_id() && $ws_value['display_location'] == 'current_user' )
						return true;

					if ( $uid != get_current_user_id() && $ws_value['display_location'] == 'other_user' )
						return true;
				}
			}
		}

		return false;
	}
}