<?php
if ( ! function_exists( 'wpj_get_vacation_reason' ) ) {
	function wpj_get_vacation_reason( $reason_id = false ) {
		$reasons = [
			1 => __( 'I\'m overbooked', 'wpjobster' ),
			2 => __( 'I\'ll be back soon', 'wpjobster' ),
			3 => __( 'I\'m on vacation', 'wpjobster' ),
		];

		if ( $reason_id === false ) {
			return $reasons;
		}

		return isset( $reasons[$reason_id] ) ? $reasons[$reason_id] : '';
	}
}

if ( ! function_exists( 'wpj_get_user_vacation' ) ) {
	function wpj_get_user_vacation( $uid = 0 ) {
		if ( ! $uid ) $uid = get_current_user_id();

		if ( ! $uid ) return false;

		$vacation = wpj_get_vacation( 'away_reason, duration_start_ts, duration_end_ts, vacation_mode', ['user_id' => $uid, 'duration_end_actual_ts' => 0], 'row' );

		if ( $vacation ) {
			return [
				'reason' => wpj_get_vacation_reason( $vacation->away_reason ),
				'start'  => $vacation->duration_start_ts,
				'end'    => $vacation->duration_end_ts,
				'mode'   => $vacation->vacation_mode,
			];
		}

		return false;
	}
}

// get start date for last x months of active period, without vacations
if ( ! function_exists( 'wpj_get_start_date_for_active_period' ) ) {
	function wpj_get_start_date_for_active_period( $user_id, $months ) {
		$vacations = wpj_get_vacation( 'id', ['user_id' => $user_id], 'results' );

		$today            = current_time( 'timestamp', 1 );
		$start_date       = strtotime( '- ' . $months . ' months', $today );
		$period_wanted    = $today - $start_date; // in seconds
		$vacations_number = count( $vacations );

		if ( $vacations_number > 0 ) {
			// recalculate $start_date if we have at least one vacation
			$i              = $vacations_number - 1; // keys start from 0
			$period_between = 0;
			$i_day          = $today; // index/pointer day

			while ( ( $period_between < $period_wanted ) && ( $i >= 0 ) ) {
				// reverse cycle through vacations
				// stop when we get enough period between vacations
				// stop when we don't have more vacations
				$v_start = $vacations[$i]->duration_start_ts;
				$v_end   = $vacations[$i]->duration_end_actual_ts;

				if ( ! $v_end ) {
					$v_end = $vacations[$i]->duration_end_ts;
				}

				if ( $i_day > $v_end ) {
					$period_between = $period_between + ( $i_day - $v_end );
				}

				$i_day = $v_start; // how far we got with checking

				$i--;
			}

			$start_date = $i_day - $period_wanted + $period_between;
		}

		return $start_date;
	}
}

if ( ! function_exists( 'wpj_vacation_mode_activate' ) ) {
	function wpj_vacation_mode_activate() {
		$duration_start    = WPJ_Form::post( 'start_date' );
		$duration_start_ts = WPJ_Form::post( 'start_date_timestamp' );
		$duration_end      = WPJ_Form::post( 'end_date' );
		$duration_end_ts   = WPJ_Form::post( 'end_date_timestamp' );
		$away_reason       = WPJ_Form::post( 'away_reason', 0 );

		if ( $away_reason == 0 ) {
			$away_reason = 3;
		}

		if ( $duration_start_ts ) {
			$duration_start_ts = DateTime::createFromFormat( 'Y-m-d H:i:s', ( new DateTime() )->setTimestamp( $duration_start_ts )->format( 'Y-m-d 00:00:00' ) )->getTimestamp();
		}

		if ( $duration_end_ts ) {
			$duration_end_ts = DateTime::createFromFormat( 'Y-m-d H:i:s', ( new DateTime() )->setTimestamp( $duration_end_ts )->format( 'Y-m-d 23:59:59' ) )->getTimestamp();
		}

		$user_vacation = wpj_get_user_vacation( get_current_user_id() );

		if ( $user_vacation ) {
			echo 'err_already_in_vacation';

		} elseif ( $duration_start_ts == '' ) {
			echo 'err_empty_start_date';

		} elseif ( $duration_start_ts < strtotime( "today", current_time( 'timestamp', 1 ) ) ) {
			echo 'err_small_start_date';

		} elseif ( $duration_end_ts == '' ) {
			echo 'err_empty_end_date';

		} elseif ( $duration_end_ts <= $duration_start_ts ) {
			echo 'err_small_end_date';

		} else {
			$vacation_mode = $duration_start_ts <= time() ? 1 : 0;

			wpj_insert_vacation(
				[
					'user_id'           => get_current_user_id(),
					'away_reason'       => $away_reason,
					'duration_start'    => $duration_start,
					'duration_start_ts' => $duration_start_ts,
					'duration_end'      => $duration_end,
					'duration_end_ts'   => $duration_end_ts,
					'vacation_mode'     => $vacation_mode
				],
				['%d', '%d', '%s', '%d', '%s', '%d', '%d']
			);

			echo 'success';
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_vacation_mode_deactivate' ) ) {
	function wpj_vacation_mode_deactivate() {
		wpj_update_vacation(
			['duration_end_actual' => date( 'Y-m-d' ), 'duration_end_actual_ts' => current_time( 'timestamp', 1 ), 'vacation_mode' => 0],
			['user_id' => get_current_user_id(), 'duration_end_actual_ts' => 0]
		);

		echo 'success';

		if ( wpj_is_ajax_call() ) wp_die();
	}
}