<?php
if ( ! function_exists( 'wpj_save_last_viewed_job' ) ) {
	function wpj_save_last_viewed_job( $pid = '', $uid = '' ) {
		if ( is_user_logged_in() ) {
			if ( ! $uid ) $uid = get_current_user_id();

			$last_viewed = get_user_meta( $uid, 'last_viewed', true );

			if ( ! is_array( $last_viewed ) ) $last_viewed = [];

			$last_viewed = array_diff( $last_viewed, [ $pid ] );

			array_unshift( $last_viewed, $pid );
			array_splice( $last_viewed, 10 );

			update_user_meta( $uid, 'last_viewed', $last_viewed );
			update_post_meta( $pid, 'buyer_cart_notify_number_' . $uid, 0 );
		}
	}
}

if ( ! function_exists( 'wpj_update_last_checkout_viewed' ) ) {
	function wpj_update_last_checkout_viewed( $pid = '', $uid = '', $action = '' ) {
		if ( ! $pid ) $pid = wpj_get_payment_info_by_url( 'pid' );
		if ( ! $uid ) $uid = get_current_user_id();

		$last_viewed = get_user_meta( $uid, 'last_checkout_viewed', true );

		if ( ! is_array( $last_viewed ) ) $last_viewed = [];

		$last_viewed = array_diff( $last_viewed, [ $pid ] );

		if ( $action != 'remove' ) array_unshift( $last_viewed, $pid );

		array_splice( $last_viewed, 10 );

		update_user_meta( $uid, 'last_checkout_viewed', $last_viewed );
	}
}

if ( ! function_exists( 'wpj_remove_last_checkout_viewed' ) ) {
	function wpj_remove_last_checkout_viewed( $oid ) {
		$order = wpj_get_job_order_by_id( $oid );

		wpj_update_last_checkout_viewed( $order->pid, get_current_user_id(), 'remove' );
	}
}

if ( ! function_exists( 'wpj_job_view_counter' ) ) {
	function wpj_job_view_counter( $pid = '' ) {
		$pid  = wpj_get_post_id( $pid );

		$interval_number = is_numeric( wpj_get_option( 'wpjobster_job_view_interval_number' ) ) ? wpj_get_option( 'wpjobster_job_view_interval_number' ) : 5;
		$interval_type   = wpj_get_option( 'wpjobster_job_view_interval_type' ) ? wpj_get_option( 'wpjobster_job_view_interval_type' ) : 'minutes';

		if ( $interval_type == 'minutes' )
			$counter_interval = $interval_number * 60;

		elseif ( $interval_type == 'hours' )
			$counter_interval = $interval_number * 60 * 60;

		elseif ( $interval_type == 'days' )
			$counter_interval = $interval_number * 60 * 60 * 24;

		elseif ( $interval_type == 'weeks' )
			$counter_interval = $interval_number * 60 * 60 * 24 * 7;

		elseif ( $interval_type == 'months' )
			$counter_interval = $interval_number * 60 * 60 * 24 * 30;

		elseif ( $interval_type == 'years' )
			$counter_interval = $interval_number * 60 * 60 * 24 * 365;

		else
			$counter_interval = 300;

		$uid = is_user_logged_in() ? get_current_user_id() : preg_replace( "/\./", "_", wpj_get_user_ip() );

		if ( $uid != get_post_field( 'post_author', $pid ) ) {
			$job_views = get_post_meta( $pid, 'job_views', true );

			if ( $job_views && is_array( $job_views ) ) {
				$last_visit = isset( $job_views[$uid]['date'] ) ? $job_views[$uid]['date'] : false;

				if ( $last_visit ) {
					if ( time() - $last_visit > $counter_interval ) $update = true;

				} else $update = true;

				if ( isset( $update ) ) {
					$job_views[$uid]['date']    = current_time( 'timestamp', 1 );
					$job_views[$uid]['counter'] = isset( $job_views[$uid]['counter'] ) ? $job_views[$uid]['counter'] + 1 : 1;

					update_post_meta( $pid, 'job_views', $job_views );
				}

			} else {
				update_post_meta( $pid, 'job_views', [ $uid => [ 'date' => time(), 'counter' => 1 ] ] );

			}
		}

		$job_views_arr = get_post_meta( $pid, 'job_views', true );

		$total_views = 0;

		if ( is_array( $job_views_arr ) ) {
			foreach ( $job_views_arr as $key => $value ) {
				$total_views += $value['counter'];
			}
		}

		update_post_meta( $pid, 'job_views_counter', $total_views );

		return $total_views;
	}
}

if ( ! function_exists( 'wpj_get_last_visit' ) ) {
	function wpj_get_last_visit( $user_id ) {
		if ( get_user_meta( $user_id, 'last_user_login', true ) ) {
			$time_elapsed = time() - ( get_user_meta( $user_id, 'last_user_login', true ) ?: 60000 );

			if ( $time_elapsed <= 359 ) return __( 'Active now', 'wpjobster' );

			return wpj_seconds_to_words( $time_elapsed, false, true );
		}

		return __( 'Unknown', 'wpjobster' );
	}
}