<?php
/** AJAX ACTIONS **/

	// Get subcategories by category
	add_action( 'wp_ajax_load_subcategories_by_categories_action'       , 'wpj_display_subcategories_select' );
	add_action( 'wp_ajax_nopriv_load_subcategories_by_categories_action', 'wpj_display_subcategories_select' );

	// Set authentication token transient
	add_action( 'wp_ajax_save_auth_token_transient_action'              , 'wpj_save_auth_token_transient' );
	add_action( 'wp_ajax_nopriv_save_auth_token_transient_action'       , 'wpj_save_auth_token_transient' );

	// Validate user login form
	add_action( 'wp_ajax_validate_login_form'                           , 'wpj_validate_user_login_form' );
	add_action( 'wp_ajax_nopriv_validate_login_form'                    , 'wpj_validate_user_login_form' );

	// Validate register form
	add_action( 'wp_ajax_validate_register_form'                        , 'wpj_validate_user_register_form' );
	add_action( 'wp_ajax_nopriv_validate_register_form'                 , 'wpj_validate_user_register_form' );

	// Validate lostpassword form
	add_action( 'wp_ajax_validate_lostpassword_form'                    , 'wpj_validate_user_lostpassword_form' );
	add_action( 'wp_ajax_nopriv_validate_lostpassword_form'             , 'wpj_validate_user_lostpassword_form' );

	// Exchange rates
	add_action( 'wp_ajax_exchange_rates_action'                         , 'wpj_display_exchange_rates_json' );
	add_action( 'wp_ajax_nopriv_exchange_rates_action'                  , 'wpj_display_exchange_rates_json' );

	// Day translation
	add_action( 'wp_ajax_day_translation_action'                        , 'wpj_get_day_translation' );
	add_action( 'wp_ajax_nopriv_day_translation_action'                 , 'wpj_get_day_translation' );

	// Search - autosuggest
	add_action( 'wp_ajax_autosuggest_action'                            , 'wpj_autosuggest_it' );
	add_action( 'wp_ajax_nopriv_autosuggest_action'                     , 'wpj_autosuggest_it' );

	// Search - autocomplete
	add_action( 'wp_ajax_search_autocomplete_action'                    , 'wpj_search_autocomplete_ajax' );
	add_action( 'wp_ajax_nopriv_search_autocomplete_action'             , 'wpj_search_autocomplete_ajax' );

	// Search user
	add_action( 'wp_ajax_search_users_action'                           , 'wpj_display_users_list' );
	add_action( 'wp_ajax_nopriv_search_users_action'                    , 'wpj_display_users_list' );

	// Order
	add_action( 'wp_ajax_accept_order_action'                           , 'wpj_mark_order_as_accepted' );               // Accept order
	add_action( 'wp_ajax_deny_order_action'                             , 'wpj_mark_order_as_rejected' );               // Reject order

	add_action( 'wp_ajax_mark_order_delivered_action'                   , 'wpj_mark_order_as_delivered' );              // Mark order as delivered
	add_action( 'wp_ajax_mark_order_completed_action'                   , 'wpj_mark_order_as_completed' );              // Mark order as completed

	add_action( 'wp_ajax_request_arbitration_action'                    , 'wpj_request_arbitration' );                  // Request arbitration
	add_action( 'wp_ajax_abort_arbitration_action'                      , 'wpj_abort_arbitration' );                    // Abort arbitration

	add_action( 'wp_ajax_request_cancellation_action'                   , 'wpj_request_mutual_cancelation' );           // Request mutual cancellation
	add_action( 'wp_ajax_abort_cancellation_action'                     , 'wpj_abort_mutual_cancelation' );             // Abort mutual cancellation
	add_action( 'wp_ajax_accept_cancellation_action'                    , 'wpj_answer_mutual_cancellation' );           // Accept mutual cancellation
	add_action( 'wp_ajax_deny_cancellation_action'                      , 'wpj_answer_mutual_cancellation' );           // Deny mutual cancellation

	add_action( 'wp_ajax_cancel_expired_order_action'                   , 'wpj_cancel_expired_order' );                 // Order cancellation action when the time expire

	add_action( 'wp_ajax_request_modification_action'                   , 'wpj_request_modification' );                 // Request modification

	add_action( 'wp_ajax_accept_custom_extra_action'                    , 'wpj_accept_custom_extra' );                  // Accept custom extra
	add_action( 'wp_ajax_request_custom_offer_action'                   , 'wpj_request_custom_offer' );                 // Request custom offer
	add_action( 'wp_ajax_send_custom_offer_action'                      , 'wpj_send_custom_offer' );                    // Send custom offer/extra
	add_action( 'wp_ajax_decline_custom_offer_action'                   , 'wpj_decline_custom_offer' );                 // Decline custom offer
	add_action( 'wp_ajax_withdraw_custom_offer_action'                  , 'wpj_withdraw_custom_offer' );                // Withdraw custom offer

	add_action( 'wp_ajax_decline_custom_extra_action'                   , 'wpj_deny_custom_extra' );                    // Deny custom extra
	add_action( 'wp_ajax_cancel_custom_extra_action'                    , 'wpj_cancel_custom_extra' );                  // Cancel Custom Extra

	add_action( 'wp_ajax_new_tip_action'                                , 'wpj_add_new_tip' );                          // Add new tip
	add_action( 'wp_ajax_cancel_tip_action'                             , 'wpj_cancel_tips' );                          // Cancel tips

	add_action( 'wp_ajax_request_extended_delivery_time_action'         , 'wpj_request_extend_order_delivery_time' );   // Request extend delivery
	add_action( 'wp_ajax_abort_extended_delivery_time_action'           , 'wpj_abort_extend_delivery_time' );           // Abort extend delivery
	add_action( 'wp_ajax_accept_extended_delivery_time_action'          , 'wpj_accept_extend_delivery_time' );          // Accept extend delivery
	add_action( 'wp_ajax_deny_extended_delivery_time_action'            , 'wpj_deny_extend_delivery_time' );            // Deny extend delivery

	add_action( 'wp_ajax_send_transaction_message_action'               , 'wpj_send_transaction_message' );             // Send transaction message

	add_action( 'wp_ajax_save_bank_job_proof_of_payment_action'         , 'wpj_save_bank_job_proof_of_payment_action' );// Save  bank proof of payment

	add_action( 'wp_ajax_cancel_featured_order_action'                  , 'wpj_cancel_featured_order' );                // Cancel featured order
	add_action( 'wp_ajax_cancel_topup_pending_order_action'             , 'wpj_cancel_topup_pending_order' );           // Cancel topup pending order
	add_action( 'wp_ajax_cancel_job_pending_order_action'               , 'wpj_cancel_pending_order' );                 // Cancel job pending order

	add_action( 'wp_ajax_request_withdrawal_action'                     , 'wpj_save_withdrawal_request' );              // Request withdrawal
	add_action( 'wp_ajax_resend_withdrawal_confirmation_email_action'   , 'wpj_resend_withdrawal_confirmation_email' ); // Resend withdrawal confirmation email

	// Media
	add_action( 'wp_ajax_delete_attachment_action'                      , 'wpj_delete_attachments' );                   // Delete media file
	add_action( 'wp_ajax_sort_attachment_action'                        , 'wpj_sort_attachments' );                     // Sort media files
	add_action( 'wp_ajax_load_tinyMCE_textarea_action'                  , 'wpj_display_tinyMCE_textarea' );             // Load tinyMCE textarea

	// Notify
	add_action( 'wp_ajax_check_live_site_changes_action'                , 'wpj_check_site_changes' );                   // Load new messages and notifications
	add_action( 'wp_ajax_mark_notification_as_read_action'              , 'wpj_mark_notification_as_read' );            // Mark single notification as read
	add_action( 'wp_ajax_mark_all_notifications_as_read_action'         , 'wpj_mark_all_notifications_as_read' );       // Mark all notifications as read
	add_action( 'wp_ajax_load_preview_notification_list_action'         , 'wpj_display_preview_notification_list' );    // Load notification preview list
	add_action( 'wp_ajax_search_conversation_action'                    , 'wpj_display_conversations_by_username' );    // Display conversations by typed username
	add_action( 'wp_ajax_search_message_action'                         , 'wpj_display_messages_by_keywords' );         // Display messages by typed keywords
	add_action( 'wp_ajax_search_message_result_action'                  , 'wpj_display_message_by_search_result' );     // Display message by clicked result
	add_action( 'wp_ajax_save_pm_enter_key_action'                      , 'wpj_save_pm_enter_key' );                    // Save message send with ENTER key option
	add_action( 'wp_ajax_load_preview_pm_list_action'                   , 'wpj_display_preview_pm_list' );              // Load message preview list
	add_action( 'wp_ajax_send_message_action'                           , 'wpj_send_message' );                         // Send new message
	add_action( 'wp_ajax_display_box_content_action'                    , 'wpj_display_chat_messagebox' );              // Display chat messagebox content
	add_action( 'wp_ajax_receive_live_messages_action'                  , 'wpj_display_user_new_messages' );            // Display user new messages
	add_action( 'wp_ajax_delete_quick_response_action'                  , 'wpj_delete_quick_response' );                // Delete quick response
	add_action( 'wp_ajax_delete_quick_responses_action'                 , 'wpj_delete_all_quick_responses' );           // Delete all quick responses
	add_action( 'wp_ajax_save_quick_response_action'                    , 'wpj_save_quick_response' );                  // Save quick response
	add_action( 'wp_ajax_save_user_selected_notifications_action'       , 'wpj_save_user_subscribed_notifications' );   // Save email & sms user preferences
	add_action( 'wp_ajax_filter_message_action'                         , 'wpj_filter_message' );                       // Filter the message
	add_action( 'wp_ajax_archive_conversation_action'                   , 'wpj_archive_conversation' );                 // Archive conversation
	add_action( 'wp_ajax_unarchive_conversation_action'                 , 'wpj_unarchive_conversation' );               // Unarchive conversation
	add_action( 'wp_ajax_delete_conversation_action'                    , 'wpj_delete_conversation' );                  // Delete conversation
	add_action( 'wp_ajax_delete_message_action'                         , 'wpj_delete_message' );                       // Delete message
	add_action( 'wp_ajax_resend_sms_verification_code_action'           , 'wpj_process_phone_verification' );           // Resend verification code message

	// Request
	add_action( 'wp_ajax_activate_request_action'                       , 'wpj_activate_request' );                     // Activate request
	add_action( 'wp_ajax_activate_all_requests_action'                  , 'wpj_activate_all_requests' );                // Activate all requests
	add_action( 'wp_ajax_deactivate_request_action'                     , 'wpj_deactivate_request' );                   // Deactivate request
	add_action( 'wp_ajax_deactivate_all_requests_action'                , 'wpj_deactivate_all_requests' );              // Deactivate all requests
	add_action( 'wp_ajax_delete_request_action'                         , 'wpj_delete_request' );                       // Delete request
	add_action( 'wp_ajax_delete_all_requests_action'                    , 'wpj_delete_all_requests' );                  // Delete all requests

	// Job
	add_action( 'wp_ajax_activate_job_action'                           , 'wpj_activate_job' );                         // Activate single job
	add_action( 'wp_ajax_activate_all_jobs_action'                      , 'wpj_activate_all_jobs' );                    // Activate all jobs
	add_action( 'wp_ajax_deactivate_job_action'                         , 'wpj_deactivate_job' );                       // Deactivate single job
	add_action( 'wp_ajax_deactivate_all_jobs_action'                    , 'wpj_deactivate_all_jobs' );                  // Deactivate all jobs
	add_action( 'wp_ajax_delete_job_action'                             , 'wpj_delete_job' );                           // Delete single job
	add_action( 'wp_ajax_delete_all_jobs_action'                        , 'wpj_delete_all_jobs' );                      // Delete all jobs
	add_action( 'wp_ajax_activate_vacation_mode_action'                 , 'wpj_vacation_mode_activate' );               // Activate vacation
	add_action( 'wp_ajax_deactivate_vacation_mode_action'               , 'wpj_vacation_mode_deactivate' );             // Deactivate vacation

	// User
	add_action( 'wp_ajax_user_account_graph_action'                     , 'wpj_get_graph' );                            // Load user graph
	add_action( 'wp_ajax_save_user_review_action'                       , 'wpj_save_inserted_review' );                 // Save user review
	add_action( 'wp_ajax_save_user_settings_action'                     , 'wpj_save_user_settings_information' );       // Save user settings
	add_action( 'wp_ajax_delete_user_account_action'                    , 'wpj_delete_user_account' );                  // Delete user account
	add_action( 'wp_ajax_cancel_subscription_action'                    , 'wpj_remove_subscription' );                  // Remove user subscription
	add_action( 'wp_ajax_export_transactions_action'                    , 'wpj_export_user_transactions' );             // Export user transactions

	// Menu
	add_action( 'wp_ajax_load_user_info_account_menu_action'            , 'wpj_display_user_info_account_menu' );       // Load header user info

	// Chat Sidebar
	add_action( 'wp_ajax_load_chat_system_action'                       , 'wpj_init_chat_system' );

/** END AJAX **/

/** WP ACTIONS **/

	add_action( 'template_redirect'    , 'wpj_change_currency_on_post_new_job_page' );
	add_action( 'template_redirect'    , 'wpj_create_fake_post' ); // fix ADS PRO Plugin conflict

	add_action( 'wp'                   , 'wpj_set_site_default_currency' );
	add_action( 'wp_loaded'            , 'wpj_set_site_timezone' );
	add_action( 'after_setup_theme'    , 'wpj_set_currency_globals', 1 );
	add_action( 'after_setup_theme'    , 'wpj_mobile_detect_globals' );
	add_action( 'init'                 , 'wpj_set_user_avatar_from_social_media' );
	add_action( 'init'                 , 'wpj_set_sort_cookie' );
	add_action( 'init'                 , 'wpj_download_attachments' );
	add_action( 'save_post'            , 'wpj_delete_site_jobs_count_transients' );
	add_action( 'login_init'           , 'wpj_deregister_load_style_php_style' );
	add_action( 'login_enqueue_scripts', 'wpj_register_dashicons_style' );
	add_action( 'user_register'        , 'wpj_save_user_registration_information', 10, 1 ); // save user extra info
	remove_action( 'register_new_user' , 'wp_send_new_user_notifications' ); // remove WP email
	remove_action( 'shutdown'          , 'wp_ob_end_flush_all', 1 );

	add_action( 'wp_enqueue_scripts'   , 'wpj_page_builder_rows_conditionally_appearance', 10 ); // show/hide page builder rows conditionally

/** END WP ACTIONS **/

/** WPJ ACTIONS **/

	add_action( 'wpj_after_job_payment_is_completed', 'wpj_remove_last_checkout_viewed', 10, 1 );
	add_action( 'wpj_after_job_payment_is_completed', 'wpj_activate_no_credits_jobs_on_job_purchase', 10, 1 );
	add_action( 'wpj_after_job_payment_is_completed', 'wpj_set_order_delivery_time', 10, 2 );

	add_action( 'wpj_before_footer'                 , 'wpj_init_chat_system_placeholder' );

/** END WPJ ACTIONS **/

/** CRONS ACTIONS **/

	add_action( 'wp'                  , 'wpj_setup_daily_event' );
	add_action( 'wp'                  , 'wpj_setup_twicedaily_event' );

	add_action( 'wp_head'             , 'wpj_refresh_user_notifications_cron' );

	add_action( 'wpj_daily_event'     , 'wpj_update_user_level_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_check_subscription_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_order_expired_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_order_failed_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_autoreject_order_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_inactive_expired_requests_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_order_expire_soon_notify_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_pending_payment_expire_soon_notify_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_buyer_cart_notify_cron' );
	add_action( 'wpj_daily_event'     , 'wpj_update_exchange_rates_cron' );

	add_action( 'wpj_twicedaily_event', 'wpj_check_featured_cron' );
	add_action( 'wpj_twicedaily_event', 'wpj_vacation_check_cron' );
	add_action( 'wpj_twicedaily_event', 'wpj_order_completed_cron' );
	add_action( 'wpj_twicedaily_event', 'wpj_order_cleared_cron' );

/** END CRONS ACTIONS **/

/** FILTERS **/

	// Stop WP Better Email to add extra spaces to HTML emails
	add_filter( 'wpbe_convert_line_breaks' , '__return_false' );

	// Remove WP language dropdown from authentication pages
	add_filter( 'login_display_language_dropdown', '__return_false' );

	// Authentication
	add_filter( 'wp_authenticate_user'     , 'wpj_validate_user_recaptcha_field', 10, 2 );
	add_filter( 'wp_authenticate_user'     , 'wpj_validate_user_2fa_field', 10, 2 );
	add_filter( 'registration_errors'      , 'wpj_validate_user_register_form', 10, 3 );
	add_filter( 'random_password'          , 'wpj_generate_user_empty_password' );     // registration with WSL
	add_filter( 'shake_error_codes'        , function () { return []; });              // remove WP validation
	add_filter( 'login_message'            , function () { return " "; }, 11 );        // remove WP message
	add_filter( 'login_errors'             , 'wpj_replace_wp_error_messages', 10, 1 ); // replace WP errors
	add_filter( 'validate_username'        , 'wpj_validate_username', 10, 2 );
	add_filter( 'avatar_defaults'          , 'wpj_change_default_wp_avatar' );
	add_filter( 'get_avatar'               , 'wpj_replace_default_wp_avatar', 1, 5 );
	add_filter( 'get_avatar_data'          , 'wpj_replace_wp_avatar', 100, 2 );
	add_filter( 'retrieve_password_message', 'wpj_reset_password', 10, 4 );
	add_filter( 'login_url'                , function ( $login_url, $redirect ) { return get_bloginfo( 'language' ) == 'en' ? wpj_get_login_link( $redirect ) : $login_url; }, 10, 2 );
	add_filter( 'register_url'             , function () { return wpj_get_register_link(); });
	add_filter( 'lostpassword_url'         , function ( $lostpassword_url, $redirect ) { return wpj_get_lostpassword_link( $redirect ); }, 10, 2 );

	add_filter( 'wsl_render_auth_widget_alter_provider_icon_markup', 'wpj_change_social_login_label', 10, 3 ); // change WSL login label

	// Display shortcodes inside Gutenberg blocks
	add_filter( 'newsletter_replace'       , 'wpj_email_job_listings_shortcode', 10, 3 );
	add_filter( 'wpj_email_message_filter' , 'wpj_email_job_listings_shortcode', 10, 3 );

	// Wrapper classes to pages
	add_filter( 'wpj_wrapper_class_filter' , 'wpj_add_pm_class_to_wrapper' );
	add_filter( 'wpj_wrapper_class_filter' , 'wpj_add_chat_class_to_wrapper' );

	// Add custom classes to nav menu
	add_filter( 'wp_nav_menu'              , 'wpj_add_custom_class_to_last_item_nav_menu' );
	add_filter( 'wp_nav_menu'              , 'wpj_add_custom_class_to_first_last_item_nav_menu' );
	add_filter( 'nav_menu_css_class'       , 'wpj_add_class_to_parent_nav_menu', 10, 2 );
	add_filter( 'nav_menu_css_class'       , 'wpj_add_custom_class_to_nav_menu' , 10 , 2 );
	add_filter( 'wp_nav_menu_items'        , 'wpj_add_active_class_to_nav_menu', 10, 2 );

	// Add custom classes to mobile body
	add_filter( 'body_class'               , 'wpj_mobile_body_class' );

	// Add custom classes to front page body
	add_filter( 'body_class'               , 'wpj_add_front_page_body_class' );

	// Remove 'admin-bar' class from PM page
	add_filter( 'body_class'               , 'wpj_remove_admin_bar_class_from_pm_page' );

	// Set email fields
	add_filter( 'wp_mail_from'             , 'wpj_set_email_from' );
	add_filter( 'wp_mail_from_name'        , 'wpj_set_name_from' );
	add_filter( 'wp_mail_content_type'     , 'wpj_set_email_content_type' );

	// Blog months translatable
	add_filter( 'get_archives_link'        , 'wpj_translate_archive_months' );

	// Add dots to excerpt
	add_filter( 'excerpt_more'             , 'wpj_add_three_dots_excerpt' );

	// Add args to oembed
	add_filter( 'oembed_result'            , 'wpj_add_args_to_oembed', 10, 3 );

	// Add buttons to tinyMCE
	add_filter( 'mce_buttons'              , 'wpj_tinymce_toolbar1_buttons', 99 );
	add_filter( 'mce_buttons_2'            , 'wpj_tinymce_toolbar2_buttons', 99 );

/** END FILTERS **/