<?php
if ( ! function_exists( 'wpj_display_blog_list_items' ) ) {
	function wpj_display_blog_list_items() { // used for load more
		$jobster_design = wpj_get_design_option();

		$no_image_src = ! empty( $jobster_design['no_image_icon_options_blog']['url'] ) ? $jobster_design['no_image_icon_options_blog']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';

		$no_image_src = apply_filters( 'wpj_placeholder_image_url_filter', $no_image_src, 'blog' );

		wpj_get_template( 'listings/blog-item/blog-posts-list-item-template.php', [ 'no_image_src' => $no_image_src ] );
	}
}

if ( ! function_exists( 'wpj_display_comments_list_items' ) ) {
	function wpj_display_comments_list_items( $comment, $args ) {
		$class = $comment->comment_parent != 0 ? 'child' : 'parent';
		$class .= empty( $args['has_children'] ) ? ' bordered-box' : '';

		wpj_get_template( 'listings/blog-item/comment-item-template.php', [ 'comment' => $comment, 'args' => $args, 'class' => $class ] );
	}
}

if ( ! function_exists( 'wpj_display_news_list_items' ) ) {
	function wpj_display_news_list_items() { // used for load more
		$jobster_design = wpj_get_design_option();

		$no_image_src = ! empty( $jobster_design['no_image_icon_options_news']['url'] ) ? $jobster_design['no_image_icon_options_news']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';

		$no_image_src = apply_filters( 'wpj_placeholder_image_url_filter', $no_image_src, 'blog' );

		wpj_get_template( 'listings/blog-item/news-posts-list-item-template.php', [ 'no_image_src' => $no_image_src ] );
	}
}