<?php
if ( ! function_exists( 'wpj_display_blog_posts_list' ) ) {
	function wpj_display_blog_posts_list() {
		global $wp_query;

		$posts = new WPJ_Load_More_Posts(
			[
				'function_name'   => 'wpj_display_blog_list_items',
				'post_status'     => 'publish',
				'container_class' => 'articles-grid ui three cards stackable',
				'category_name'   => isset( $wp_query->query_vars['category_name'] ) ? $wp_query->query_vars['category_name'] : ""
			]
		);

		// Display posts
		wpj_get_template( 'listings/blog/blog-posts-list-template.php', ['posts' => $posts] );
	}
}

if ( ! function_exists( 'wpj_display_news_posts_list' ) ) {
	function wpj_display_news_posts_list() {
		global $wp, $wp_query;

		if ( ! empty( $wp_query->query_vars['news_cat'] ) ) {
			$category = $wp_query->query_vars['news_cat'];

		} elseif ( $wp->request ) { // for page builder
			$url_category = explode( '/', $wp->request );

			if ( isset( $url_category[1] ) && $url_category[0] != 'tag' ) {
				$category = $url_category[1];
			}
		}

		$tax_query = '';

		if ( isset( $category ) ) {
			$tax_query = [
				'taxonomy' => 'news_cat',
				'field'    => 'slug',
				'terms'    => $category
			];
		}

		if ( ! empty( $wp_query->query_vars['tag'] ) ) {
			$tag = $wp_query->query_vars['tag'];

		} elseif ( $wp->request ) { // for page builder
			$url_tag = explode( '/', $wp->request );

			if ( isset( $url_tag[1] ) && $url_tag[0] == 'tag' ) {
				$tag = $url_tag[1];
			}
		}

		$posts = new WPJ_Load_More_Posts(
			[
				'post_type'       => 'news',
				'function_name'   => 'wpj_display_news_list_items',
				'post_status'     => 'publish',
				'tax_query'       => [ $tax_query ],
				'container_class' => 'articles-grid ui three cards stackable',
				'tag'             => isset( $tag ) ? $tag : ''
			]
		);

		// Display posts
		wpj_get_template( 'listings/blog/news-posts-list-template.php', ['posts' => $posts] );
	}
}