<?php
if ( ! function_exists( 'wpj_display_user_job_posts_list_item' ) ) {
	function wpj_display_user_job_posts_list_item( $pid = '' ) {
		if ( ! $pid ) $pid = get_the_ID();
		if ( ! $pid || ! is_numeric( $pid ) ) $pid = wpj_get_post_id( $pid );

		$post = get_post( $pid );

		$package_type  = get_post_meta( $pid, 'job_packages', true );
		$package_price = get_post_meta( $pid, 'package_price', true );

		if ( $package_type == 'yes' && $package_price ) { sort( $package_price );
			$package_price = array_diff( $package_price, [ null ] );
		}

		$g = 0;

		if (   get_post_meta( $pid, 'home_featured_until', true ) == 'z'
			|| get_post_meta( $pid, 'home_featured_until', true ) == false ) $g++;
		if (   get_post_meta( $pid, 'category_featured_until', true ) == 'z'
			|| get_post_meta( $pid, 'category_featured_until', true ) == false ) $g++;
		if (   get_post_meta( $pid, 'subcategory_featured_until', true ) == 'z'
			|| get_post_meta( $pid, 'subcategory_featured_until', true ) == false ) $g++;

		$btn_class = get_post_meta( $pid, 'active', true ) == '1' ? ' js-deactivate-job-link' : ' js-activate-job-link';

		if (
			$post->post_status == 'pending'
			&& (
				get_post_meta( $pid, 'more_extras', true ) == 'yes'
				|| get_post_meta( $pid, 'more_extra_price', true ) == 'yes'
				|| get_post_meta( $pid, 'more_job_price', true ) == 'yes'
			)
		) {
			$class = 'oe-full'; $text = __( 'disabled', 'wpjobster' );

		} elseif ( $post->post_status == 'pending' ) {
			$class = 'oe-red oe-full'; $text = __( 'rejected', 'wpjobster' );

		} elseif ( get_post_meta( $pid, 'under_review', true ) == '1' ) {
			$class = 'oe-orange oe-full'; $text = __( 'pending', 'wpjobster' );

		} elseif ( get_post_meta( $pid, 'active', true ) == 0 ) {
			$class = 'oe-yellow oe-full'; $text = __( 'paused', 'wpjobster' );

		} else {
			$class = 'oe-green oe-full'; $text = __( 'published', 'wpjobster' );

		}

		$class = apply_filters( 'wpj_user_jobs_status_class_filter', $class );
		$text  = apply_filters( 'wpj_user_jobs_status_text_filter', $text );

		wpj_get_template( 'listings/job-item/user-posted-jobs-list-item-template.php', [
			'pid'           => $pid,
			'post'          => $post,
			'package_price' => $package_price,
			'btn_class'     => $btn_class,
			'g'             => $g,
			'class'         => $class,
			'text'          => $text
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_job_favorites_list_item' ) ) {
	function wpj_display_user_job_favorites_list_item( $pid = '' ) {
		$jobster_design = wpj_get_design_option();

		if ( ! $pid ) $pid = get_the_ID();
		if ( ! $pid || ! is_numeric( $pid ) ) $pid = wpj_get_post_id( $pid );

		$post = get_post( $pid );

		$package_type  = get_post_meta( $pid, 'job_packages', true );
		$package_price = get_post_meta( $pid, 'package_price', true );

		if ( $package_type == 'yes' && $package_price ) {
			sort( $package_price );

			$package_price = array_diff( $package_price, [null] );
		}

		wpj_get_template( 'listings/job-item/user-favorites-jobs-list-item-template.php', [
			'pid'            => $pid,
			'post'           => $post,
			'package_price'  => $package_price,
			'jobster_design' => $jobster_design
		] );
	}
}