<?php
if ( ! function_exists( 'wpj_display_user_posted_jobs_list' ) ) {
	function wpj_display_user_posted_jobs_list( $tab = '' ) {
		$uid = get_current_user_id();

		if ( $tab == 'active' ) {
			$meta_query   = ['key' => 'active', 'value' => '1', 'compare' => '='];
			$post_status  = ['publish'];
			$no_jobs_text = __( 'No active jobs.', 'wpjobster' );

		} elseif ( $tab == 'inactive' ) {
			$meta_query   = ['relation' => 'AND', ['key' => 'active', 'value' => '0', 'compare' => '=' ], ['key' => 'under_review', 'value' => '0', 'compare' => '=' ]];
			$post_status  = ['draft', 'publish'];
			$no_jobs_text = __( 'No inactive jobs.', 'wpjobster' );

		} elseif ( $tab == 'under-review' ) {
			$meta_query   = ['key' => 'under_review', 'value' => '1', 'compare' => '='];
			$post_status  = ['draft'];
			$no_jobs_text = __( 'No pending review jobs.', 'wpjobster' );

		} elseif ( $tab == 'rejected' ) {
			$post_status  = ['pending'];
			$meta_query   = [];
			$no_jobs_text = __( 'No rejected jobs.', 'wpjobster' );

		} else {
			$meta_query   = ['key' => 'closed', 'value' => '0', 'compare' => '='];
			$post_status  = ['draft', 'publish', 'pending'];
			$no_jobs_text = __( 'There are no jobs yet.', 'wpjobster' );

		}

		$jobs_list = new WPJ_Load_More_Posts(
			[
				'post_type'       => 'job',
				'function_name'   => 'wpj_display_user_job_posts_list_item',
				'post_status'     => $post_status,
				'order_by'        => 'date',
				'order'           => 'DESC',
				'author'          => $uid,
				'meta_query'      => [$meta_query],
				'container_class' => 'my-account-job-listing'
			]
		);

		wpj_get_template( 'listings/job/user-posted-jobs-list-template.php', [
			'job_data'     => $jobs_list,
			'tab'          => $tab,
			'no_jobs_text' => $no_jobs_text
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_favorites_jobs_list' ) ) {
	function wpj_display_user_favorites_jobs_list() {
		if ( function_exists( 'upb_get_user_meta' ) && function_exists( 'upb_get_user_id' ) ) {
			if ( upb_get_user_meta( upb_get_user_id() ) ) {
				$jobs_list = new WPJ_Load_More_Posts(
					[
						'post_type'       => 'job',
						'post__in'        => upb_get_user_meta( upb_get_user_id() ),
						'function_name'   => 'wpj_display_user_job_favorites_list_item',
						'order_by'        => 'date',
						'order'           => 'DESC',
						'container_class' => 'my-account-job-listing'
					]
				);

			} else {
				$jobs_list = 'not_found';

			}

		} else {
			$jobs_list = 'not_allowed';

		}

		wpj_get_template( 'listings/job/user-favorites-jobs-list-template.php', ['job_data' => $jobs_list] );
	}
}

if ( ! function_exists( 'wpj_display_job_posts_list' ) ) {
	function wpj_display_job_posts_list( $args = [] ) {
		$term = get_queried_object();

		$uid       = ! empty( $args['uid'] ) ? $args['uid'] : '';
		$load_type = ! empty( $args['load_type'] ) ? $args['load_type'] : 'button';
		$columns   = ! empty( $args['columns'] ) ? wpj_number_to_string( $args['columns'] ) : 'four';

		$query_args = [
			'query_type'        => 'jobs',
			'query_status'      => 'all',
			'function_name'     => 'wpj_display_job_card_layout',
			'row_extra_classes' => 'ui ' . $columns . ' cards',
			'load_type'         => $load_type,
			'uid'               => $uid,
			'posts_per_page'    => ! empty( $args['jobs'] ) ? $args['jobs'] : wpj_get_option( 'posts_per_page' )
		];

		if ( ! empty( $args['post__not_in'] ) )
			$query_args['query_params']['post__not_in'] = [$args['post__not_in']];

		if ( ! empty( $args['category'] ) )
			$query_args['query_params']['category'] = $args['category'];

		elseif ( ! empty( $term->slug ) )
			$query_args['query_params']['category'] = $term->slug;

		if ( ! empty( $args['order'] ) )
			$query_args['query_params']['order'] = $args['order'];

		if ( isset( $args['featured'] ) && is_numeric( $args['featured'] ) )
			$query_args['query_params']['featured'] = $args['featured'];

		$posts = new WPJ_Load_More_Queries( $query_args );

		$post_new_job_link     = get_permalink( wpj_get_option( 'wpjobster_post_new_page_id' ) );
		$post_new_request_link = get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) );

		if ( ! empty( $term->term_id ) ) {
			$post_new_job_link .= '?category=' . $term->term_id;
			$post_new_request_link .= '?category=' . $term->slug . '-req';
		}

		// Display posts
		wpj_get_template( 'listings/job/job-posts-list-template.php', [
			'posts'                 => $posts,
			'post_type'             => 'job',
			'term'                  => $term,
			'post_new_job_link'     => $post_new_job_link,
			'post_new_request_link' => $post_new_request_link
		] );
	}
}

if ( ! function_exists( 'wpj_display_latest_job_posts' ) ) {
	function wpj_display_latest_job_posts( $cols = 4, $load_type = 'load_more' ) {
		wpj_display_job_posts_list([
			'featured'  => 1,
			'columns'   => $cols,
			'load_type' => $load_type,
			'order'     => wpj_get_option( 'wpjobster_jobs_order' ),
			'jobs'      => 12
		]);
	}
}