<?php
if ( ! function_exists( 'wpj_display_notification_item' ) ) {
	function wpj_display_notification_item( $row ) {
		wpj_get_template( 'listings/notify-item/notifications-list-item-template.php', [
			'notifications_arr'  => wpj_get_notification_message_by_id( $row->id ),
			'is_unread'          => $row->rd ? 0 : 1,
			'row'                => $row
		] );
	}
}

if ( ! function_exists( 'wpj_display_message_item' ) ) {
	function wpj_display_message_item( $row, $user1 = '', $user2 = '' ) {
		if ( ! $user1 ) $user1 = get_current_user_id();
		if ( ! $user2 ) $user2 = wpj_get_pm_interlocutor_from_url( 'id' );

		$user2_slug = get_user_by( 'id', $user2 );
		$user2_slug = is_object( $user2_slug ) && isset( $user2_slug->user_nicename ) ? $user2_slug->user_nicename : false;

		// mark message as read
		if ( get_current_user_id() != $row->initiator && $row->rd == 0 ) wpj_mark_pm_as_read( $row );

		// get message background color
		if ( $row->custom_offer == -1 ) {
			$bgcolor = $user1 == $row->initiator ? 'pm-request-holder pm-sent' : 'pm-request-holder';

		} elseif ( $row->custom_offer > 0 ) {
			$bgcolor = $user1 == $row->initiator ? 'pm-offer-holder pm-sent' : 'pm-offer-holder';

		} elseif ( $user1 == $row->initiator ) {
			$bgcolor = 'pm-sent';

		} else {
			$bgcolor = '';

		}

		// get custom offer icon
		$title_icon         = '';
		$custom_offer_class = '';

		if ( $row->custom_offer == -1 ) {
			$custom_offer_class = $user1 == $row->user ? 'pm-offer-blue' : 'pm-offer-gray';
			$title_icon         = 'title-tag-icon';

		} elseif ( $row->custom_offer > 0 ) {
			// expired offer?
			wpj_expire_custom_offer( $row->custom_offer, $row->user, $row->initiator );

			if ( get_post_meta( $row->custom_offer, "offer_accepted", true ) == 1 ) {
				$custom_offer_class = 'pm-offer-green';
				$title_icon         = 'title-check-icon';

			} elseif ( get_post_meta( $row->custom_offer, "offer_declined", true ) == 1 ) {
				$custom_offer_class = 'pm-offer-red';
				$title_icon         = 'title-close-icon';

			} elseif ( get_post_meta( $row->custom_offer, "offer_withdrawn", true ) == 1 ) {
				$custom_offer_class = 'pm-offer-gray';
				$title_icon         = 'title-minus-icon';

			} elseif ( get_post_meta( $row->custom_offer, "offer_expired", true ) == 1 ) {
				$custom_offer_class = 'pm-offer-gray';
				$title_icon         = 'title-clock-icon';

			} elseif ( $user1 == $row->user ) {
				$custom_offer_class = 'pm-offer-blue';
				$title_icon         = 'title-tag-icon';

			} else {
				$custom_offer_class = 'pm-offer-gray';
				$title_icon         = 'title-tag-icon';

			}
		}

		if ( $row->associate_job_id ) {
			$custom_offer_id = $row->associate_job_id;

		} elseif ( $row->associate_request_id ) {
			$custom_offer_id = $row->associate_request_id;

		} else {
			$custom_offer_id = '';

		}

		$message_data = wpj_get_message_post_id( $row->content );
		$message      = is_array( $message_data ) ? $message_data['message'] : $message_data;

		if ( ! $message ) $message = $row->content;

		$message = wpj_stripslashes( nl2br( strip_tags( htmlspecialchars_decode( $message ) ) ) );

		if ( ! str_contains( $message, sprintf( 'pwd=%d%d', $user2, $user1 ) ) ) { /* zoom link */
			$message = wpj_apply_filter_to_string( $message, true, 'privatemessages' );
		}

		if ( $row->custom_offer == -1 ) $custom_offer_type = 'request';
		elseif ( $row->custom_offer > 0 ) $custom_offer_type = 'send';
		else $custom_offer_type = '';

		$delivery_days = get_post_meta( $row->custom_offer, 'max_days', true );
		$days_word     = _n( 'day', 'days', $delivery_days, 'wpjobster' );

		$pm_custom_offer_price_filter    = apply_filters( 'wpj_pm_custom_offer_price_filter', true );
		$pm_custom_offer_duration_filter = apply_filters( 'wpj_pm_custom_offer_duration_filter', true );

		$prc = get_post_meta( $row->custom_offer, 'price', true );

		if ( is_numeric( $row->associate_job_id ) && $row->associate_job_id > 0 ) {
			$pid = $row->associate_job_id;

		} elseif ( is_numeric( $row->associate_request_id ) && $row->associate_request_id > 0 ) {
			$pid = $row->associate_request_id;

		} else {
			$pid = $row->id;

		}

		wpj_get_template( 'listings/notify-item/messages-list-item-template.php', [
			'row'                             => $row,
			'post_id'                         => is_array( $message_data ) ? $message_data['id'] : '',
			'user1'                           => $user1,
			'user2'                           => $user2,
			'initiator_data'                  => wpj_get_userdata( $row->initiator ),
			'bgcolor'                         => $bgcolor,
			'title_icon'                      => $title_icon,
			'custom_offer_class'              => $custom_offer_class,
			'custom_offer_id'                 => $custom_offer_id,
			'user2_slug'                      => $user2_slug,
			'message'                         => $message,
			'custom_offer_type'               => $custom_offer_type,
			'delivery_days'                   => $delivery_days,
			'days_word'                       => $days_word,
			'pm_custom_offer_price_filter'    => $pm_custom_offer_price_filter,
			'pm_custom_offer_duration_filter' => $pm_custom_offer_duration_filter,
			'prc'                             => $prc,
			'pid'                             => $pid
		] );
	}
}

if ( ! function_exists( 'wpj_display_chat_message_item' ) ) {
	function wpj_display_chat_message_item( $row, $user1, $user2, $i = 1 ) {
		$is_sender = get_current_user_id() == $row->initiator;

		if ( ! $is_sender && $row->rd == 0 ) wpj_mark_pm_as_read( $row );

		$user2_data = wpj_get_userdata( $user2 );

		// User last seen
		$time_elapsed    = ! empty ( $user2_data->last_user_login ) ? time() - $user2_data->last_user_login : 60000;
		$time_difference = $time_elapsed / 60;
		$time_difference = (int)$time_difference;

		$message_data = wpj_get_message_post_id( $row->content );
		$message      = is_array( $message_data ) ? $message_data['message'] : $message_data;

		if ( ! $message ) $message = $row->content;

		$message = wpj_stripslashes( nl2br( strip_tags( htmlspecialchars_decode( $message ) ) ) );

		if ( ! str_contains( $message, sprintf( 'pwd=%d%d', $user2, $user1 ) ) ) { /* zoom link */
			$message = wpj_apply_filter_to_string( $message, true, 'privatemessages' );
		}

		if ( ! $message ) $message = $row->content;

		wpj_get_template( 'listings/notify-item/chat-messages-list-item-template.php', [
			'i'            => $i,
			'row'          => $row,
			'user1'        => $user1,
			'user2'        => $user2,
			'is_sender'    => $is_sender,
			'message_date' => wpj_chat_get_message_date( $row ),
			'message'      => $message,
			'status_class' => $time_difference <= 5 ? "online" : "offline",
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_conversation_item' ) ) {
	function wpj_display_user_conversation_item( $row, $type = 'all' ) {
		$user1 = $row->other;
		$user2 = $row->author;

		$user1_data = get_userdata( $user1 );
		$user1_id   = is_object( $user1_data ) && isset( $user1_data->ID ) ? $user1_data->ID : $user1;

		$user1_name = is_object( $user1_data ) && isset( $user1_data->ID ) ? wpj_get_user_display_type( $user1_data->ID ) : __( 'Deleted User', 'wpjobster' );
		$user1_name = mb_strlen( $user1_name ) > 17 ? mb_substr( $user1_name, 0, 15 ) . '...' : $user1_name;

		$pm_content = wpj_nl_to_space( strip_tags( html_entity_decode( htmlspecialchars_decode( $row->content ) ) ) );
		$pm_content = wpj_apply_filter_to_string( $pm_content, false, 'privatemessages' );
		$pm_content = mb_strlen( $pm_content ) > 110 ? mb_substr( $pm_content, 0, 108 ) . '...' : $pm_content;

		wpj_get_template( 'listings/notify-item/users-conversation-list-item-template.php', [
			'row'                => $row,
			'type'               => WPJ_Form::get( 'type', $type ),
			'user1'              => $user1,
			'user2'              => $user2,
			'user1_data'         => $user1_data,
			'user1_id'           => $user1_id,
			'user1_name'         => $user1_name,
			'custom_offer_class' => ! empty( $row->custom_offer ) && $row->custom_offer != 0 ? ' pm-custom-offer' : '',
			'read_class'         => $user1 == $user2 && $row->rd == 0 ? ' pm-unread-message' : '',
			'url_query_args'     => isset( $_GET['type'] ) && $_GET['type'] == 'archived' ? '?type=archived' : '',
			'active_class'       => wpj_get_pm_interlocutor_from_url( 'id' ) == $user1 ? ' active' : '',
			'pm_content'         => $pm_content
		] );
	}
}