<?php
if ( ! function_exists( 'wpj_display_notifications_list' ) ) {
	function wpj_display_notifications_list() {
		$notifications = new WPJ_Load_More_Queries(
			[
				'query_type'    => 'notifications',
				'query_status'  => 'all',
				'function_name' => 'wpj_display_notification_item',
			]
		);

		wpj_get_template( 'listings/notify/notifications-list-template.php', [
			'notifications_data' => $notifications
		] );
	}
}

if ( ! function_exists( 'wpj_display_messages_list' ) ) {
	function wpj_display_messages_list( $args ) {
		global $wp_query;

		$defaults = [
			'user1'                 => get_current_user_id(),
			'user2'                 => wpj_get_pm_interlocutor_from_url( 'id' ),
			'message_type'          => 'all',
			'display_location'      => 'pm',
			'query_params'          => '',
			'display_empty_message' => true,
			'limit'                 => wpj_get_option( 'posts_per_page' ),
			'row_extra_classes'     => '',
			'load_type'             => 'icon',
			'message_id'            => '',
			'skip_search'           => false
		];

		$args = wp_parse_args( $args, $defaults );

		/**
		 * @var int $user1
		 * @var int $user2
		 * @var string $message_type
		 * @var string $display_location
		 * @var string $query_params
		 * @var bool $display_empty_message
		 * @var int $limit
		 * @var string $row_extra_classes
		 * @var string $load_type
		 * @var int $message_id
		 * @var bool $skip_search
		 */
		extract( $args );

		if ( ! $message_id )
			$message_id = isset( $wp_query->query_vars['message_id'] ) ? urldecode( $wp_query->query_vars['message_id'] ) : '';

		if ( $message_id && is_numeric( $message_id ) && ! $skip_search ) {
			wpj_display_message_by_search_result( $message_id, $user2 );

		} else {
			$messages = new WPJ_Load_More_Queries(
				[
					'query_type'        => 'messages',
					'query_status'      => $message_type,
					'query_params'      => $query_params,
					'function_name'     => $display_location == 'chat' ? 'wpj_display_chat_message_item' : 'wpj_display_message_item',
					'function_params'   => [ 'user1' => $user1, 'user2' => $user2 ],
					'uid'               => $user2,
					'load_type'         => $load_type,
					'posts_per_page'    => $limit,
					'row_extra_classes' => $row_extra_classes
				]
			);

			wpj_get_template( 'listings/notify/messages-list-template.php', [
				'messages_data'         => $messages,
				'display_empty_message' => $display_empty_message
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_users_conversation_list' ) ) {
	function wpj_display_users_conversation_list( $type = 'all' ) {
		$conversations = new WPJ_Load_More_Queries(
			[
				'query_type'    => 'conversations',
				'query_status'  => 'all',
				'function_name' => 'wpj_display_user_conversation_item',
				'load_type'     => 'icon-down'
			]
		);

		wpj_get_template( 'listings/notify/users-conversation-list-template.php', [
			'type'               => WPJ_Form::get( 'type', $type ),
			'conversations_data' => $conversations
		] );
	}
}
