<?php
if ( ! function_exists( 'wpj_display_shopping_item' ) ) {
	function wpj_display_shopping_item( $row ) {
		$pid  = $row->pid;
		$post = get_post( $row->pid );

		$completed = $row->done_buyer == 1 ? 1 : 0;
		$delivered = $row->done_seller == 1 ? 1 : 0;

		$job_image_url = $row->job_image ? wpj_get_attachment_image_url( $row->job_image, [ 60, 60 ] ) : wpj_get_job_image( $pid, 60, 60 );

		if ( wpj_is_custom_offer( $pid ) ) {
			$this_post_title = wpj_get_custom_offer_title( $pid, $post->post_author );

		} elseif ( $row->job_title ) {
			$this_post_title = wpj_wrap_title( $row->job_title, $pid );

		} elseif ( $post->post_title ) {
			$this_post_title = wpj_wrap_title( $post->post_title, $pid );

		} else {
			$this_post_title = __( 'No title', 'wpjobster' );

		}

		$total_amount = $row->mc_gross + $row->processing_fees + $row->tax_amount + wpj_get_custom_extras_amount( $row );
		$total_amount = apply_filters( 'wpj_shopping_update_filter', $total_amount, $row );

		if ( $row->payment_status == 'pending' ) {
			$class = 'oe-orange oe-full'; $text = __( 'pending', 'wpjobster' );

		} elseif ( $row->payment_status == 'failed' ) {
			$class = 'oe-red oe-full'; $text = __( 'failed', 'wpjobster' );

		} elseif ( $row->payment_status == 'cancelled' ) {
			$class = 'oe-red oe-full'; $text = __( 'cancelled', 'wpjobster' );

		} elseif ( $row->payment_status == 'expired' ) {
			$class = 'oe-burgundy oe-full'; $text = __( 'expired', 'wpjobster' );

		} elseif ( $completed == 1 ) {
			$class = 'oe-green-txt'; $text = __( 'completed', 'wpjobster' );

		} elseif ( $row->closed == 1 ) {
			$class = 'oe-red-txt'; $text = __( 'cancelled', 'wpjobster' );

		} elseif ( $delivered == 1 && $completed != 1 ) {
			$class = 'oe-green oe-full'; $text = __( 'delivered', 'wpjobster' );

		} elseif ( $row->seller_confirmation == 0 && $row->closed != 1 && $row->completed != 1 && $row->payment_status != 'pending' ) {
			$class = 'oe-orange'; $text = __( 'pending confirmation', 'wpjobster' );

		} else {
			if ( $row->request_cancellation_from_buyer == 1 && $row->accept_cancellation_request == 0 ) {
				$class = 'oe-red oe-full'; $text = __( 'problem', 'wpjobster' );

			} elseif ( $row->request_cancellation_from_seller == 1 && $row->accept_cancellation_request == 0 ) {
				$class = 'oe-red'; $text = __( 'problem', 'wpjobster' );

			} elseif ( $row->request_modification == 1 ) {
				$class = 'oe-orange oe-full'; $text = __( 'modification', 'wpjobster' );

			} elseif ( $delivered == 0 && $row->closed != 1 ) {
				$class = 'oe-green oe-full'; $text = __( 'active', 'wpjobster' );

			} else {
				$class = 'oe-green'; $text = __( 'active', 'wpjobster' );

			}
		}

		$class = apply_filters( 'wpj_user_shopping_status_class_filter', $class, $row );
		$text  = apply_filters( 'wpj_user_shopping_status_text_filter', $text, $row );

		wpj_get_template( 'listings/payment-item/user-shopping-list-item-template.php', [
			'row'             => $row,
			'pid'             => $pid,
			'post'            => $post,
			'delivered'       => $delivered,
			'completed'       => $completed,
			'job_image_url'   => $job_image_url,
			'this_post_title' => $this_post_title,
			'total_amount'    => $total_amount,
			'class'           => $class,
			'text'            => $text
		] );
	}
}

if ( ! function_exists( 'wpj_display_sales_item' ) ) {
	function wpj_display_sales_item( $row ) {
		$pid  = $row->pid;
		$post = get_post( $row->pid );

		$delivered = $row->done_seller == 1 ? 1 : 0;
		$completed = $row->done_buyer == 1 ? 1 : 0;

		$job_image_url = $row->job_image ? wpj_get_attachment_image_url( $row->job_image, [ 60, 60 ] ) : wpj_get_job_image( $pid, 60, 60 );

		if ( wpj_is_custom_offer( $pid ) ) {
			$this_post_title = wpj_get_custom_offer_title( $pid, $row->uid );

		} elseif ( $row->job_title ) {
			$this_post_title = wpj_wrap_title( $row->job_title, $pid );

		} elseif ( $post->post_title ) {
			$this_post_title = wpj_wrap_title( $post->post_title, $pid );

		} else {
			$this_post_title = __( 'No title', 'wpjobster' );

		}

		$total_amount = $row->mc_gross + $row->processing_fees + $row->tax_amount + wpj_get_custom_extras_amount( $row );
		$total_amount = apply_filters( 'wpj_sales_update_filter', $total_amount, $row );

		if ( $row->payment_status == 'pending' && $row->closed != 1 ) {
			$class = 'oe-orange'; $text = __( 'pending', 'wpjobster' );

		} elseif ( $row->payment_status == 'processing' ) {
			$class = 'oe-orange'; $text = __( 'processing', 'wpjobster' );

		} elseif ( $row->payment_status == 'failed' ) {
			$class = 'oe-red'; $text = __( 'failed', 'wpjobster' );

		} elseif ( $row->payment_status == 'expired' ) {
			$class = 'oe-burgundy'; $text = __( 'expired', 'wpjobster' );

		} elseif ( $completed == 1 ) {
			$class = 'oe-green-txt'; $text = __( 'completed', 'wpjobster' );

		} elseif ( $row->closed == 1 ) {
			$class = 'oe-orange'; $text = __( 'cancelled', 'wpjobster' );

		} elseif ( $delivered == 1 && $completed != 1 ) {
			$class = 'oe-green oe-full'; $text = __( 'delivered', 'wpjobster' );

		} elseif ( $row->seller_confirmation == 0 && $row->closed != 1 && $row->completed != 1 && $row->payment_status != 'pending' ) {
			$class = 'oe-orange'; $text = __( 'pending confirmation', 'wpjobster' );

		} else {
			if ( $row->request_cancellation_from_buyer == 1 && $row->accept_cancellation_request == 0 ) {
				$class = 'oe-red'; $text = __( 'problem', 'wpjobster' );

			} elseif ( $row->request_cancellation_from_seller == 1 && $row->accept_cancellation_request == 0 ) {
				$class = 'oe-red oe-full'; $text = __( 'problem', 'wpjobster' );

			} elseif ( $row->request_modification == 1 ) {
				$class = 'oe-orange'; $text = __( 'modification', 'wpjobster' );

			} elseif ( $delivered == 0 && $row->closed != 1 ) {
				$class = 'oe-green'; $text = __( 'active', 'wpjobster' );

			} else {
				$class = 'oe-green oe-full'; $text = __( 'active', 'wpjobster' );

			}
		}

		$class = apply_filters( 'wpj_user_sales_status_class_filter', $class, $row );
		$text  = apply_filters( 'wpj_user_sales_status_text_filter', $text, $row );

		wpj_get_template( 'listings/payment-item/user-sales-list-item-template.php', [
			'row'             => $row,
			'pid'             => $pid,
			'post'            => $post,
			'delivered'       => $delivered,
			'completed'       => $completed,
			'job_image_url'   => $job_image_url,
			'this_post_title' => $this_post_title,
			'total_amount'    => $total_amount,
			'class'           => $class,
			'text'            => $text
		] );
	}
}

if ( ! function_exists( 'wpj_display_withdrawal_pending_item' ) ) {
	function wpj_display_withdrawal_pending_item( $row ) {
		wpj_get_template( 'listings/payment-item/pending-withdrawals-list-item-template.php', [
			'receiver_data' => wpj_get_userdata( $row->uid ),
			'row'           => $row,
		] );
	}
}

if ( ! function_exists( 'wpj_display_payment_incoming_pending_item' ) ) {
	function wpj_display_payment_incoming_pending_item( $row ) {
		$post = get_post( $row->pid );

		$total_custom_extras = 0;
		$custom_extras       = wpj_json_decode( wpj_stripslashes( $row->custom_extras ) );

		if ( $custom_extras ) {
			$i = 0;

			foreach ( $custom_extras as $custom_extra ) {
				if ( $custom_extra->paid ) {
					$custom_extra_ord = wpj_get_custom_extra_order( '*', ['order_id' => $row->id, 'custom_extra_id' => $i], 'row' );

					if ( isset( $custom_extra_ord->id ) ) {
						$custom_extra_payment = wpj_get_payment( [
							'payment_type'    => 'custom_extra',
							'payment_type_id' => $custom_extra_ord->id,
						] );

						$total_custom_extras += isset( $custom_extra_payment->amount ) ? $custom_extra_payment->amount : 0;
					}
				}

				$i++;
			}
		}

		// tips total
		$total_tips = 0;
		$tips       = wpj_json_decode( wpj_stripslashes( $row->tips ) );

		if ( $tips ) {
			$i = 0;

			foreach ( $tips as $tip ) {
				if ( $tip->paid ) {
					$tips_ord = wpj_get_tips_order( '*', ['order_id' => $row->id, 'tips_id' => $i], 'row' );

					if ( isset( $tips_ord->id ) ) {
						$tips_payment = wpj_get_payment( [
							'payment_type'    => 'tips',
							'payment_type_id' => $tips_ord->id,
						] );

						$total_tips += $tips_payment->amount;
					}
				}

				$i++;
			}
		}

		$mc_gross = apply_filters( 'wpj_pending_payment_amount_update_filter', $row->mc_gross, $row );

		$total_amount = $mc_gross + $total_custom_extras + $total_tips;
		$total_amount_minus_fee = $total_amount - wpj_get_site_fee_by_amount( $total_amount, $row->id );

		$transaction_id = wpj_camouflage_oid( $row->id, $row->date_made );

		if ( wpj_is_custom_offer( $row->pid ) ) {
			$real_post_title = wpj_get_custom_offer_title( $row->pid, $row->uid );

		} else {
			if ( $row->job_title ) $real_post_title = $row->job_title;
			else $real_post_title = $post->post_title;

		}

		wpj_get_template( 'listings/payment-item/pending-incoming-payments-list-item-template.php', [
			'real_post_title'        => $real_post_title,
			'transaction_id'         => $transaction_id,
			'total_custom_extras'    => $total_custom_extras,
			'total_tips'             => $total_tips,
			'mc_gross'               => $mc_gross,
			'total_amount'           => $total_amount,
			'total_amount_minus_fee' => apply_filters( 'wpj_pending_payment_amount_filter', $total_amount_minus_fee, $row->id, $total_amount ),
			'row'                    => $row
		] );
	}
}

if ( ! function_exists( 'wpj_display_transaction_item' ) ) {
	function wpj_display_transaction_item( $row ) {
		global $wpjobster_currencies_array;

		$transaction_id = wpj_camouflage_oid( $row->oid, $row->datemade );

		if ( $row->tp == 0 ) {
			$class = 'color-ff6252';
			$sign  = '-';

		} elseif ( $row->tp == 1 ) {
			$class = 'color-20c497';
			$sign  = '+';

		} else {
			$class = 'color-dc9b00';
			$sign  = '';

		}

		if ( $row->rid > 0 ) {
			$job_title = '';
			$order_url = '';

			if ( $row->oid > 0 ) {
				$row_order = wpj_get_job_order_by_id( $row->oid );

				if ( isset( $row_order->pid ) ) {
					if ( wpj_is_custom_offer( $row_order->pid ) ) {
						$uid         = get_current_user_id();
						$private_uid = $row_order->uid;

						if ( $private_uid != $uid ) {
							$private_userdata = wpj_get_userdata( $private_uid );
							$with_username    = wpj_get_user_display_type( $private_userdata->ID );

						} else {
							$private_post       = get_post( $row_order->pid );
							$private_authorid   = $private_post->post_author;
							$private_authordata = wpj_get_userdata( $private_authorid );
							$with_username      = wpj_get_user_display_type( $private_authordata->ID );

						}

						$job_title = __( 'Private transaction with', 'wpjobster' ) . ' ' . $with_username . ' (#' . $transaction_id . ')';

					} else {
						$job_title = $row_order->job_title . ' (#' . $transaction_id . ')';

					}

					$order_url = wpj_get_order_link( $row->oid );
				}
			}

			if ( $row->rid == 1 ) {
				$reason = __( 'Payment received from Site Admin', 'wpjobster' );

			} elseif ( $row->rid == 2 ) {
				$reason = __( 'Payment withdrawn by Site Admin', 'wpjobster' );

			} elseif ( $row->rid == 3 ) {
				$reason = __( 'Payment made for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 4 ) {
				$reason = __( 'Payment collected for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 5 ) {
				$reason = __( 'Payment cleared for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 6 ) {
				$reason = __( 'Fee charged for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 7 || $row->rid == 8 ) {
				$reason = __( 'Payment refunded for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 9 ) {
				$reason = __( 'Withdrawal to', 'wpjobster' ) . ' ' . $row->details;

			} elseif ( $row->rid == 10 ) {
				$reason = __( 'Feature Job', 'wpjobster' ) . ': <a href="' . get_permalink( $row->details ) . '">' . get_the_title( $row->details ) . '</a>';

			} elseif ( $row->rid == 11 ) {
				$details_arr = explode( '_', $row->details );

				$duration_arr = [
					'weekly'    => __( 'weekly', 'wpjobster' ),
					'quarterly' => __( 'quarterly', 'wpjobster' ),
					'monthly'   => __( 'monthly', 'wpjobster' ),
					'yearly'    => __( 'yearly', 'wpjobster' ),
					'lifetime'  => __( 'lifetime', 'wpjobster' )
				];

				$duration = $duration_arr[$details_arr[0]];

				if ( $details_arr[2] == "new" ) {
					$reason = __( 'Payment for subscription', 'wpjobster' ) . ": " . $duration;

				} elseif ( $details_arr[2] == "change" ) {
					$reason = __( 'Payment for changing subscription', 'wpjobster' ) . ": " . $duration;

				} elseif ( $details_arr[2] == "renew" ) {
					$reason = __( 'Payment for subscription renewal', 'wpjobster' ) . ": " . $duration;

				} else {
					$reason = __( 'Payment for subscription', 'wpjobster' );

				}

			} elseif ( $row->rid == 12 ) {
				$reason = __( 'Top Up account balance', 'wpjobster' );

			} elseif ( $row->rid == 13 ) {
				$reason = __( 'Processing fee for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 14 ) {
				$reason = __( 'Tax for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 15 ) {
				$reason = __( 'Payment received from Affiliate System', 'wpjobster' );

			} elseif ( $row->rid == 16 ) {
				$order_url     = wpj_get_order_link( $row->oid );
				$order         = wpj_get_job_order_by_id( $row->oid );
				$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );
				$job_title     = $custom_extras[$row->details]->description;
				$reason        = apply_filters( 'wpj_custom_extra_processing_fees_filter', __( 'Processing fee for custom extra:', 'wpjobster' ), $order->pid ) . '&nbsp;<a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 17 ) {
				$order_url     = wpj_get_order_link( $row->oid );
				$order         = wpj_get_job_order_by_id( $row->oid );
				$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );
				$job_title     = $custom_extras[$row->details]->description;
				$reason        = apply_filters( 'wpj_custom_extra_tax_filter', __( 'Tax for custom extra:', 'wpjobster' ), $order->pid ) . '&nbsp;<a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 18 ) {
				$order_url     = wpj_get_order_link( $row->oid );
				$order         = wpj_get_job_order_by_id( $row->oid );
				$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );
				$job_title     = $custom_extras[$row->details]->description;
				$reason        = apply_filters( 'wpj_custom_extra_string_with_dots_filter', __( 'Custom extra:', 'wpjobster' ), $order->pid ) . '&nbsp;<a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 19 ) {
				$order_url     = wpj_get_order_link( $row->oid );
				$order         = wpj_get_job_order_by_id( $row->oid );
				$custom_extras = wpj_json_decode( wpj_stripslashes( $order->custom_extras ) );
				$job_title     = isset( $custom_extras[$row->details]->description ) ? $custom_extras[$row->details]->description : '';
				$reason        = apply_filters( 'wpj_custom_extra_collected_filter', __( 'Payment collected for custom extra:', 'wpjobster' ), $order->pid ) . '&nbsp;<a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 20 ) {
				$reason = __( 'Payoneer fee for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 21 ) {
				$reason = __( 'Discount for', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . '</a>';

			} elseif ( $row->rid == 22 ) {
				$order_url   = wpj_get_order_link( $row->oid );
				$order       = wpj_get_job_order_by_id( $row->oid );
				$tips        = wpj_json_decode( wpj_stripslashes( $order->tips ) );
				$job_title   = $order->job_title;
				$tips_reason = ! empty( $tips[$row->details]->reason ) ? ' (' . $tips[$row->details]->reason . ')' : '';
				$reason      = __( 'Processing fee for tips', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . $tips_reason . '</a>';

			} elseif ( $row->rid == 23 ) {
				$order_url   = wpj_get_order_link( $row->oid );
				$order       = wpj_get_job_order_by_id( $row->oid );
				$tips        = wpj_json_decode( wpj_stripslashes( $order->tips ) );
				$job_title   = $order->job_title;
				$tips_reason = ! empty( $tips[$row->details]->reason ) ? ' (' . $tips[$row->details]->reason . ')' : '';
				$reason      = __( 'Tax for tips', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . $tips_reason . '</a>';

			} elseif ( $row->rid == 24 ) {
				$order_url   = wpj_get_order_link( $row->oid );
				$order       = wpj_get_job_order_by_id( $row->oid );
				$tips        = wpj_json_decode( wpj_stripslashes( $order->tips ) );
				$job_title   = $order->job_title;
				$tips_reason = ! empty( $tips[$row->details]->reason ) ? ' (' . $tips[$row->details]->reason . ')' : '';
				$reason      = __( 'Tips', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . $tips_reason . '</a>';

			} elseif ( $row->rid == 25 ) {
				$order_url = wpj_get_order_link( $row->oid );
				$order     = wpj_get_job_order_by_id( $row->oid );
				$tips      = wpj_json_decode( wpj_stripslashes( $order->tips ) );
				$job_title = $order->job_title;
				$reason    = ! empty( $tips[$row->details]->reason ) ? ' (' . $tips[$row->details]->reason . ')' : '';
				$reason    = __( 'Payment collected for tips', 'wpjobster' ) . ': <a href="' . $order_url . '">' . $job_title . $reason . '</a>';

			} else {
				$reason = $row->reason;

			}

		} else {
			$reason = $row->reason;

		}

		wpj_get_template( 'listings/payment-item/transasctions-list-item-template.php', [
			'row'                 => $row,
			'sign'                => $sign,
			'multiple_currencies' => count( $wpjobster_currencies_array ) > 1 ? 1 : 0,
			'reason'              => $reason,
			'class'               => $class
		] );
	}
}

if ( ! function_exists( 'wpj_display_topup_pending_item' ) ) {
	function wpj_display_topup_pending_item( $row ) {
		wpj_get_template( 'listings/payment-item/topup-pending-list-item-template.php', ['row' => $row] );
	}
}

if ( ! function_exists( 'wpj_display_topup_completed_item' ) ) {
	function wpj_display_topup_completed_item( $row ) {
		wpj_get_template( 'listings/payment-item/topup-completed-list-item-template.php', ['row' => $row] );
	}
}