<?php
if ( ! function_exists( 'wpj_display_user_shopping_list' ) ) {
	function wpj_display_user_shopping_list( $tab = '' ) {
		if ( $tab == 'active' ) {
			$no_jobs_text = __( 'No active orders.', 'wpjobster' );

		} elseif ( $tab == 'pending-confirmation' ) {
			$no_jobs_text = __( 'No pending confirmation orders', 'wpjobster' );

		} elseif ( $tab == 'pending-payment' ) {
			$no_jobs_text = __( 'No pending payment.', 'wpjobster' );

		} elseif ( $tab == 'pending-review' ) {
			$no_jobs_text = __( 'No pending review orders.', 'wpjobster' );

		} elseif ( $tab == 'cancelled' ) {
			$no_jobs_text = __( 'No cancelled orders.', 'wpjobster' );

		} elseif ( $tab == 'completed' ) {
			$no_jobs_text = __( 'No completed orders.', 'wpjobster' );

		} else {
			$no_jobs_text = __( 'No orders.', 'wpjobster' );

		}

		wpj_get_template( 'listings/payment/user-shopping-list-template.php', [
			'shopping_data' => wpj_get_query_payments( 'shopping', $tab, 'wpj_display_shopping_item', 'my-account-shopping-list' ),
			'tab'           => $tab,
			'no_jobs_text'  => $no_jobs_text
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_sales_list' ) ) {
	function wpj_display_user_sales_list( $tab = '' ) {
		if ( $tab == 'active' ) {
			$no_jobs_text = __( 'No active orders.', 'wpjobster' );

		} elseif ( $tab == 'pending-confirmation' ) {
			$no_jobs_text = __( 'No pending confirmation orders', 'wpjobster' );

		} elseif ( $tab == 'pending-payment' ) {
			$no_jobs_text = __( 'No pending orders.', 'wpjobster' );

		} elseif ( $tab == 'delivered' ) {
			$no_jobs_text = __( 'No delivered orders.', 'wpjobster' );

		} elseif ( $tab == 'cancelled' ) {
			$no_jobs_text = __( 'No cancelled orders.', 'wpjobster' );

		} elseif ( $tab == 'completed' ) {
			$no_jobs_text = __( 'No completed orders.', 'wpjobster' );

		} else {
			$no_jobs_text = __( 'No orders.', 'wpjobster' );

		}

		wpj_get_template( 'listings/payment/user-sales-list-template.php', [
			'sales_data'   => wpj_get_query_payments( 'sales', $tab, 'wpj_display_sales_item', 'my-account-shopping-list' ),
			'tab'          => $tab,
			'no_jobs_text' => $no_jobs_text,
		] );
	}
}

if ( ! function_exists( 'wpj_display_pending_withdrawals_list' ) ) {
	function wpj_display_pending_withdrawals_list() {
		wpj_get_template( 'listings/payment/pending-withdrawals-list-template.php', [
			'pending_withdrawals_results' => wpj_get_query_payments( 'withdrawals', 'pending', 'wpj_display_withdrawal_pending_item', 'my-account-pending-withdrawal-list' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_pending_incoming_payments_list' ) ) {
	function wpj_display_pending_incoming_payments_list() {
		wpj_get_template( 'listings/payment/pending-incoming-payments-list-template.php', [
			'pending_incoming_results' => wpj_get_query_payments( 'payments', 'pending', 'wpj_display_payment_incoming_pending_item', '' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_transactions_list' ) ) {
	function wpj_display_transactions_list() {
		global $wpjobster_currencies_array;

		wpj_get_template( 'listings/payment/transasctions-list-template.php', [
			'transaction_results'        => wpj_get_query_payments( 'transactions', 'all', 'wpj_display_transaction_item', '' ),
			'wpjobster_currencies_array' => $wpjobster_currencies_array,
		] );
	}
}

if ( ! function_exists( 'wpj_display_topup_pending_list' ) ) {
	function wpj_display_topup_pending_list() {
		wpj_get_template( 'listings/payment/topup-pending-list-template.php', [
			'topup_pending_results' => wpj_get_query_payments( 'topup', 'pending', 'wpj_display_topup_pending_item', 'my-payments-topup-pending-list' ),
			'topup_packages'        => wpj_get_option( 'topup-packages-settings' ),
		] );
	}
}

if ( ! function_exists( 'wpj_display_topup_completed_list' ) ) {
	function wpj_display_topup_completed_list() {
		wpj_get_template( 'listings/payment/topup-completed-list-template.php', [
			'topup_completed_results' => wpj_get_query_payments( 'topup', 'completed', 'wpj_display_topup_completed_item', 'my-payments-topup-completed-list' )
		] );
	}
}