<?php
if ( ! function_exists( 'wpj_display_ratings_to_award_item' ) ) {
	function wpj_display_ratings_to_award_item( $row ) {
		$post  = get_post( $row->pid );
		$title = isset( $post->post_title ) ? $post->post_title : '';

		wpj_get_template( 'listings/rating-item/ratings-to-award-list-item-template.php', [
			'row'   => $row,
			'pid'   => $row->pid,
			'post'  => $post,
			'title' => $title
		] );
	}
}

if ( ! function_exists( 'wpj_display_ratings_pending_item' ) ) {
	function wpj_display_ratings_pending_item( $row ) {
		wpj_get_template( 'listings/rating-item/ratings-pending-list-item-template.php', [
			'row'  => $row,
			'pid'  => $row->pid,
			'post' => get_post( $row->pid ),
			'user' => wpj_get_userdata( $row->uid )
		] );
	}
}

if ( ! function_exists( 'wpj_display_ratings_received_item' ) ) {
	function wpj_display_ratings_received_item( $row ) {
		$post = get_post( $row->pid );

		if ( get_current_user_id() == wpj_get_seller_id( $row ) ) {
			$buyer_info = get_user_by( 'id', $row->uid );

		} else {
			$buyer_info = get_user_by( 'id', wpj_get_seller_id( $row ) );

		}

		$buyer_slug = isset( $buyer_info->data->user_nicename ) ? $buyer_info->data->user_nicename : '';

		wpj_get_template( 'listings/rating-item/ratings-received-list-item-template.php', [
			'row'        => $row,
			'pid'        => $row->pid,
			'post'       => $post,
			'buyer_info' => $buyer_info,
			'buyer_slug' => $buyer_slug
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_reviews_item' ) ) {
	function wpj_display_job_reviews_item( $row ) {
		wpj_get_template( 'listings/rating-item/job-reviews-list-item-template.php', [
			'row'  => $row,
			'user' => wpj_get_userdata( wpj_get_buyer_id( $row->orderid ) )
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_reviews_item' ) ) {
	function wpj_display_user_reviews_item( $row ) {
		$buyer_id  = wpj_get_buyer_id( $row->orderid );
		$seller_id = wpj_get_seller_id( $row->orderid );

		if ( $row->uid == $buyer_id ) {
			$buyer_id = $row->uid;

		} elseif ( $row->uid == $seller_id ) {
			$seller_id = $row->uid;

		}

		wpj_get_template( 'listings/rating-item/user-reviews-list-item-template.php', [
			'row'      => $row,
			'uid'      => apply_filters( 'wpj_user_review_author_filter', $buyer_id, $seller_id ),
			'is_offer' => wpj_is_custom_offer( $row->pid )
		] );
	}
}