<?php
if ( ! function_exists( 'wpj_display_ratings_to_award_list' ) ) {
	function wpj_display_ratings_to_award_list() {
		wpj_get_template( 'listings/rating/ratings-to-award-list-template.php', [
			'rating_to_award_results' => wpj_get_query_payments( 'reviews', 'to_award', 'wpj_display_ratings_to_award_item', 'my-account-review' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_ratings_pending_list' ) ) {
	function wpj_display_ratings_pending_list() {
		wpj_get_template( 'listings/rating/ratings-pending-list-template.php', [
			'rating_pending_results' => wpj_get_query_payments( 'reviews', 'to_receive', 'wpj_display_ratings_pending_item', 'review-row-listing' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_ratings_received_list' ) ) {
	function wpj_display_ratings_received_list() {
		wpj_get_template( 'listings/rating/ratings-received-list-template.php', [
			'rating_received_results' => wpj_get_query_payments( 'reviews', 'received', 'wpj_display_ratings_received_item', 'review-row-listing' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_reviews_list' ) ) {
	function wpj_display_job_reviews_list() {
		$job_review_results = new WPJ_Load_More_Queries(
			[
				'query_type'        => 'reviews',
				'query_status'      => 'job_reviews',
				'function_name'     => 'wpj_display_job_reviews_item',
				'posts_per_page'    => apply_filters( 'wpj_job_reviews_number_filter', 3 ),
				'uid'               => get_post_field( 'post_author', wpj_get_post_id() ),
				'pid'               => wpj_get_post_id(),
				'row_extra_classes' => 'job-review-row-listing'
			]
		);

		wpj_get_template( 'listings/rating/job-reviews-list-template.php', [ 'job_review_results' => $job_review_results ] );
	}
}

if ( ! function_exists( 'wpj_display_user_reviews_list' ) ) {
	function wpj_display_user_reviews_list() {
		$user_review_results = new WPJ_Load_More_Queries(
			[
				'query_type'        => 'reviews',
				'query_status'      => 'user_reviews',
				'function_name'     => 'wpj_display_user_reviews_item',
				'posts_per_page'    => apply_filters( 'wpj_user_reviews_number_filter', 3 ),
				'uid'               => wpj_get_user_id(),
				'row_extra_classes' => 'user-review-row-listing'
			]
		);

		wpj_get_template( 'listings/rating/user-reviews-list-template.php', [ 'user_review_results' => $user_review_results ] );
	}
}