<?php
if ( ! function_exists( 'wpj_display_user_requests_posts_list_items' ) ) {
	function wpj_display_user_requests_posts_list_items( $active_tab = '', $pid = '' ) {
		if ( ! $pid ) $pid = get_the_ID();

		$post = get_post( $pid );

		$class = '';
		$text  = '';

		if ( ( get_post_meta( $pid, 'active', true ) == '1' || ! get_post_meta( $pid, 'active', true ) ) && get_post_meta( $pid, 'active', true ) != '0' )
			$btn_class = ' js-deactivate-request-link';

		else
			$btn_class = ' js-activate-request-link';

		if ( get_post_meta( $pid, 'rejected', true ) == 1 || $post->post_status == "pending" ) {
			$class = "oe-red oe-full"; $text = __( 'rejected', 'wpjobster' );

		} elseif ( get_post_meta( $pid, 'in_review', true ) == 1 || $post->post_status == "draft" ) {
			$class = "oe-orange oe-full"; $text = __( 'pending', 'wpjobster' );

		} elseif ( get_post_meta( $pid, 'assigned', true ) == 1 ) {
			$class = "oe-burgundy oe-full"; $text = __( 'assigned', 'wpjobster' );

		} elseif ( get_post_meta( $pid, 'completed', true ) == 1 ) {
			$class = "oe-green-txt"; $text = __( 'completed', 'wpjobster' );

		} else if ( get_post_meta( $pid, 'active', true ) == '0' && $post->post_status == 'publish' ) {
			$class = "oe-yellow oe-full"; $text = __( 'paused', 'wpjobster' );

		} else if ( ! get_post_meta( $pid, 'active', true ) || get_post_meta( $pid, 'active', true ) == '1' && $post->post_status == 'publish' ) {
			$class = "oe-green oe-full"; $text = __( 'published', 'wpjobster' );

		}

		$class = apply_filters( 'wpj_user_requests_status_class_filter', $class );
		$text  = apply_filters( 'wpj_user_requests_status_text_filter', $text );

		wpj_get_template( 'listings/request-item/user-posted-requests-list-item-template.php', [
			'pid'        => $pid,
			'post'       => $post,
			'btn_class'  => $btn_class,
			'active_tab' => $active_tab,
			'class'      => $class,
			'text'       => $text
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_list_items' ) ) {
	function wpj_display_request_list_items( $pid = '' ) { // used for load more
		$jobster_design = wpj_get_design_option();

		if ( ! $pid ) $pid = get_the_ID();

		$post = get_post( $pid );

		$term = get_queried_object();

		if ( ! empty( $term->taxonomy ) && $term->taxonomy == 'request_cat' )
			$page = 'request_category';

		elseif ( ( ! empty( $term->name ) && $term->name == 'request' ) || is_page( wpj_get_option( 'wpjobster_all_requests_page_id' ) ) )
			$page = 'all_requests';

		elseif ( ! empty( $term->ID ) && $term->ID == wpj_get_option( 'wpjobster_advanced_search_request_page_id' ) )
			$page = 'search_request';

		elseif ( is_singular( 'request' ) )
			$page = 'single_request';

		else
			$page = 'request';

		wpj_get_template( 'listings/request-item/request-posts-list-item-template.php', [
			'post'           => $post,
			'post_id'        => $pid,
			'jobster_design' => $jobster_design,
			'page'           => $page,
			'Custom_Fields'  => new WPJ_Custom_Fields( $pid, 'request' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_proposal_list_items' ) ) {
	function wpj_display_proposal_list_items( $active_tab = '' ) {
		$pid = wpj_get_post_id();

		$row = wpj_get_pm_notify( '*', ['custom_offer' => $pid], 'row' );

		if ( $row ) {
			if ( $row->initiator == get_current_user_id() ) $to = $row->user;
			else $to = $row->initiator;

			$to = ! empty( $to ) ? wpj_get_user_display_type( $to ) : $to;

		} else $to = false;

		if ( ! empty( $row->associate_job_id ) ) {
			$subject = '<a class="color-426195" href="' . get_permalink( $row->associate_job_id ) . '">' . __( 'Job', 'wpjobster' ) . '</a>';

		} elseif ( ! empty( $row->associate_request_id ) ) {
			$subject = '<a class="color-426195" href="' . get_permalink( $row->associate_request_id ) . '">' . __( 'Request', 'wpjobster' ) . '</a>';

		} else {
			if ( ! empty( $row->custom_offer ) ) {
				$subject = '<a class="color-426195" href="' . wpj_get_pm_link( $to, $row->id ) . '">' . __( 'Private message', 'wpjobster' ) . '</a>';

			} else {
				$subject = '<span class="color-426195">' . __( 'Private message', 'wpjobster' ) . '</span>';
			}

		}

		wpj_get_template( 'listings/request-item/proposals-list-item-template.php',
			[
				'active_tab' => $active_tab,
				'row'        => $row,
				'pid'        => $pid,
				'post'       => get_post( $pid ),
				'price'      => ! empty( $row->custom_offer ) ? wpj_show_price( get_post_meta( $row->custom_offer, 'price', true ) ) : '-',
				'max_days'   => ! empty( $row->custom_offer ) ? get_post_meta( $row->custom_offer, 'max_days', true ) : '-',
				'accepted'   => ! empty( $row->custom_offer ) ? get_post_meta( $row->custom_offer, 'offer_accepted', true ) : false,
				'declined'   => ! empty( $row->custom_offer ) ? get_post_meta( $row->custom_offer, 'offer_declined', true ) : false,
				'withdrawn'  => ! empty( $row->custom_offer ) ? get_post_meta( $row->custom_offer, 'offer_withdrawn', true ) : false,
				'expired'    => ! empty( $row->custom_offer ) ? get_post_meta( $row->custom_offer, 'offer_expired', true ) : true,
				'subject'    => $subject
			]
		);
	}
}