<?php
if ( ! function_exists( 'wpj_display_user_posted_requests_list' ) ) {
	function wpj_display_user_posted_requests_list( $tab = '' ) {
		$uid = get_current_user_id();

		$query_params = wpj_get_user_requests( $uid, $tab, 'query' );

		$requests_list = new WPJ_Load_More_Posts(
			array_merge( $query_params, [
				'function_name'   => 'wpj_display_user_requests_posts_list_items',
				'container_class' => 'all-requests-page',
				'posts_per_page'  => wpj_get_option( 'posts_per_page' ),
				'params'          => $tab
			] )
		);

		wpj_get_template( 'listings/request/user-posted-requests-list-template.php', [
			'request_data' => $requests_list,
			'active_tab'   => $tab,
		] );
	}
}

if ( ! function_exists( 'wpj_display_request_posts_list' ) ) {
	function wpj_display_request_posts_list( $args = [] ) {
		$sort_order = ! empty( $args['order'] ) ? $args['order'] : wpj_get_current_post_sort_order( 'request' );

		$orderby = '';

		if ( $sort_order == 'new' ) {
			$orderby = 'date';
			$order   = 'DESC';
		}

		if ( $sort_order == 'old' ) {
			$orderby = 'date';
			$order   = 'ASC';
		}

		if ( $sort_order == 'distance' && wpj_get_option( 'wpjobster_request_location' ) == 'yes' ) {
			$orderby = 'distance';
			$order   = 'ASC';
		}

		$columns = ! empty( $args['columns'] ) ? wpj_number_to_string( $args['columns'] ) : 'four';

		$query_params = [
			'post_type'       => 'request',
			'post_status'     => 'publish',
			'function_name'   => 'wpj_display_request_list_items',
			'orderby'         => $orderby,
			'order'           => $order,
			'meta_query'      => [
				[
					'key'     => 'active',
					'value'   => '1',
					'compare' => '='
				]
			],
			'container_class' => 'ui ' . $columns . ' cards'
		];

		$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

		if ( $term ) {
			$query_params['tax_query'] = [
				[
					'taxonomy' => get_query_var( 'taxonomy' ),
					'field'    => 'term_id',
					'terms'    => $term->term_id,
				]
			];
		}

		if ( wpj_get_option( 'wpjobster_html5_geolocation_enable' ) == 'yes' && wpj_get_current_post_sort_order( 'request' ) == 'distance' ) {
			$query_params['search_args'] = [
				'latitude'  => WPJ_Form::cookie( 'wpj_lat', '' ),
				'longitude' => WPJ_Form::cookie( 'wpj_lng', '' ),
				'location'  => WPJ_Form::cookie( 'wpj_location', '' ),
				'radius'    => '99999',
			];
		}

		$posts = new WPJ_Load_More_Posts( $query_params );

		$post_new_job_link     = get_permalink( wpj_get_option( 'wpjobster_post_new_page_id' ) );
		$post_new_request_link = get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) );

		if ( ! empty( $term->term_id ) ) {
			$post_new_job_link     .= '?category=' . $term->term_id;
			$post_new_request_link .= '?category=' . $term->slug;
		}

		// Display posts
		wpj_get_template( 'listings/request/request-posts-list-template.php', [
			'posts'                 => $posts,
			'post_type'             => 'request',
			'post_new_job_link'     => $post_new_job_link,
			'post_new_request_link' => $post_new_request_link
		] );
	}
}

if ( ! function_exists( 'wpj_display_search_request_posts_list' ) ) {
	function wpj_display_search_request_posts_list( $args = [] ) {
		$sort_order = ! empty( $args['order'] ) ? $args['order'] : wpj_get_current_post_sort_order( 'request' );

		$meta_querya = [];
		$force_no_custom_order = TRUE;

		global $term;

		$term = trim( strip_tags( WPJ_Form::get( 'term', '' ) ) );

		if ( wpj_get_option( 'wpjobster_html5_geolocation_enable' ) == 'yes' ) {
			$location_default = WPJ_Form::cookie( 'wpj_location', '' );
			$lat_default      = WPJ_Form::cookie( 'wpj_lat', '' );
			$lng_default      = WPJ_Form::cookie( 'wpj_lng', '' );

		} else {
			$location_default = '';
			$lat_default      = '';
			$lng_default      = '';

		}

		$order    = WPJ_Form::get( 'order', 'DESC' );
		$orderby  = WPJ_Form::get( 'orderby', 'meta_value' );
		$meta_key = WPJ_Form::get( 'meta_key', '' );

		if ( $sort_order == 'auto' || $sort_order == 'rating' ) {
			$force_no_custom_order = FALSE;
		}

		if ( $sort_order == 'new' ) {
			$orderby  = 'date';
			$order    = 'DESC';
			$meta_key = '';
			add_filter( 'apto_get_orderby', 'wpj_change_post_list_order', 10, 3 );
		}

		if ( $sort_order == 'old' ) {
			$orderby  = 'date';
			$order    = 'ASC';
			$meta_key = '';
			add_filter( 'apto_get_orderby', 'wpj_change_post_list_order', 10, 3 );
		}

		if ( $sort_order == 'distance'
			&& wpj_get_option( 'wpjobster_request_location' ) == 'yes'
			&& WPJ_Form::get( 'location', $location_default )
		) {
			$orderby  = 'distance';
			$order    = 'ASC';
			$meta_key = '';
		}

		$budget_comparator = WPJ_Form::get( 'request_without_budget' ) ? '==' : '!=';
		$budget_logical_op = WPJ_Form::get( 'request_without_budget' ) ? 'OR' : 'AND';

		if ( WPJ_Form::get( 'min_price' ) ) {
			$budget_from = [
				'relation' => $budget_logical_op,
				[
					'key'     => 'request_budget_from',
					'value'   => WPJ_Form::get( 'min_price' ),
					'type'    => 'numeric',
					'compare' => '>='
				],
				[
					'key'     => 'request_budget_from',
					'value'   => 0,
					'type'    => 'numeric',
					'compare' => $budget_comparator
				],
				[
					'key'     => 'request_budget_from',
					'value'   => null,
					'type'    => 'numeric',
					'compare' => $budget_comparator
				],
			];
		}

		if ( WPJ_Form::get( 'max_price' ) ) {
			$budget_to = [
				'relation' => $budget_logical_op,
				[
					'key'     => 'request_budget_to',
					'value'   => WPJ_Form::get( 'max_price' ),
					'type'    => 'numeric',
					'compare' => '<='
				],
				[
					'key'     => 'request_budget_to',
					'value'   => 0,
					'type'    => 'numeric',
					'compare' => $budget_comparator
				],
				[
					'key'     => 'request_budget_to',
					'value'   => null,
					'type'    => 'numeric',
					'compare' => $budget_comparator
				],
			];
		}

		$delivery_comparator = WPJ_Form::get( 'request_without_delivery' ) ? '==' : '!=';
		$delivery_logical_op = WPJ_Form::get( 'request_without_delivery' ) ? 'OR' : 'AND';

		if ( WPJ_Form::get( 'max_days', '' ) ) {
			if ( WPJ_Form::get( 'max_days' ) != wpj_get_option( 'wpjobster_request_max_delivery_days' ) ) {
				$max_days = [
					'relation' => $delivery_logical_op,
					[
						'key'     => 'request_delivery',
						'value'   => WPJ_Form::get( 'max_days' ),
						'type'    => 'numeric',
						'compare' => '<='
					],
					[
						'key'     => 'request_delivery',
						'value'   => 0,
						'type'    => 'numeric',
						'compare' => $delivery_comparator
					],
					[
						'key'     => 'request_delivery',
						'value'   => null,
						'type'    => 'numeric',
						'compare' => $delivery_comparator
					],
				];
			}
		}

		if ( WPJ_Form::get( 'request_deadline' ) ) {
			$deadline = [
				'relation' => 'AND',
				[
					'key'     => 'request_deadline',
					'value'   => trim( htmlspecialchars( WPJ_Form::get( 'request_deadline' ) ) ),
					'type'    => 'numeric',
					'compare' => '<='
				],
				[
					'key'     => 'request_deadline',
					'value'   => 0,
					'type'    => 'numeric',
					'compare' => '!='
				],
				[
					'key'     => 'request_deadline',
					'value'   => null,
					'type'    => 'numeric',
					'compare' => '!='
				],
			];
		}

		$date_comparator = WPJ_Form::get( 'request_without_date' ) ? '==' : '!=';
		$date_logical_op = WPJ_Form::get( 'request_without_date' ) ? 'OR' : 'AND';

		$start_date_key_filter = apply_filters( 'wpj_search_request_start_date_key_filter', 'request_start_date' );

		if ( WPJ_Form::get( 'start_date' ) ) {
			$start_date = [
				'relation' => $date_logical_op,
				[
					'key'     => $start_date_key_filter,
					'value'   => WPJ_Form::get( 'start_date' ),
					'type'    => 'numeric',
					'compare' => '>='
				],
				[
					'key'     => $start_date_key_filter,
					'value'   => 0,
					'type'    => 'numeric',
					'compare' => $date_comparator
				],
				[
					'key'     => $start_date_key_filter,
					'value'   => null,
					'type'    => 'numeric',
					'compare' => $date_comparator
				],
			];
		}

		$end_date_key_filter = apply_filters( 'wpj_search_request_end_date_key_filter', 'request_end_date' );

		if ( WPJ_Form::get( 'end_date' ) ) {
			$end_date = [
				'relation' => $date_logical_op,
				[
					'key'     => $end_date_key_filter,
					'value'   => WPJ_Form::get( 'end_date' ),
					'type'    => 'numeric',
					'compare' => '<='
				],
				[
					'key'     => $end_date_key_filter,
					'value'   => 0,
					'type'    => 'numeric',
					'compare' => $date_comparator
				],
				[
					'key'     => $end_date_key_filter,
					'value'   => null,
					'type'    => 'numeric',
					'compare' => $date_comparator
				],
			];
		}

		$archive_val = isset( get_queried_object()->slug ) ? get_queried_object()->slug : '';
		$archive_val = $archive_val ? substr( $archive_val, 0, -4 ) : '';

		if ( WPJ_Form::get( 'category' ) || $archive_val ) {
			$request_category = [
				'taxonomy' => 'request_cat',
				'field'    => 'slug',
				'terms'    => WPJ_Form::get( 'category', $archive_val ) . '-req'
			];

		} else {
			$request_category = '';

		}

		$meta_querya = apply_filters( 'wpj_slider_search_extra_fields', $meta_querya );

		if ( ! empty( $budget_from ) ) array_push( $meta_querya, $budget_from );
		if ( ! empty( $budget_to ) )   array_push( $meta_querya, $budget_to );
		if ( ! empty( $start_date ) )  array_push( $meta_querya, $start_date );
		if ( ! empty( $end_date ) )    array_push( $meta_querya, $end_date );
		if ( ! empty( $max_days ) )    array_push( $meta_querya, $max_days );
		if ( ! empty( $deadline ) )    array_push( $meta_querya, $deadline );

		array_push( $meta_querya, wpj_get_user_requests( '', 'active', 'query' ) );

		$request_tag = WPJ_Form::get( 'tag', '' ) ? str_replace( ' ', '-', WPJ_Form::get( 'tag', '' ) ) : '';

		$columns = ! empty( $args['columns'] ) ? wpj_number_to_string( $args['columns'] ) : 'four';

		$query_params = [
			'post_status'           => 'publish',
			'post_type'             => 'request',
			'tag'                   => $request_tag,
			'order'                 => $order,
			'meta_query'            => $meta_querya,
			'meta_key'              => $meta_key,
			'orderby'               => $orderby,
			'force_no_custom_order' => $force_no_custom_order,
			'tax_query'             => [ $request_category ],
			'container_class'       => 'ui ' . $columns . ' cards',
			'search_args'           => [
				'latitude'  => WPJ_Form::get( 'latitude', $lat_default ),
				'longitude' => WPJ_Form::get( 'longitude', $lng_default ),
				'location'  => WPJ_Form::get( 'location', $location_default ),
				'radius'    => WPJ_Form::get( 'radius', '' ),
				'term'      => WPJ_Form::get( 'term', '' ),
			]
		];

		$query_params = $query_params + ['function_name' => 'wpj_display_request_list_items', 's' => $term];

		$posts = new WPJ_Load_More_Posts( $query_params );

		$term = get_queried_object();

		$post_new_job_link     = get_permalink( wpj_get_option( 'wpjobster_post_new_page_id' ) );
		$post_new_request_link = get_permalink( wpj_get_option( 'wpjobster_new_request_page_id' ) );

		if ( ! empty( $term->term_id ) ) {
			$job_term = get_term_by( 'slug', str_replace( '-req', '', $term->slug ), 'job_cat' );

			$post_new_job_link     .= '?category=' . $job_term->term_id;
			$post_new_request_link .= '?category=' . $term->slug;
		}

		// Display posts
		wpj_get_template( 'listings/request/request-posts-list-template.php', [
			'posts'                 => $posts,
			'post_type'             => 'request',
			'post_new_job_link'     => $post_new_job_link,
			'post_new_request_link' => $post_new_request_link
		] );
	}
}

if ( ! function_exists( 'wpj_display_proposals_list' ) ) {
	function wpj_display_proposals_list( $type ) {
		if ( $type == 'send' ) {
			$query_params = [
				'post_type'      => 'offer',
				'author'         => get_current_user_id(),
				'post_status'    => [ 'publish' ]
			];

			$proposals_list = new WPJ_Load_More_Posts( $query_params + [
				'function_name'   => 'wpj_display_proposal_list_items',
				'container_class' => 'all-proposals-page',
				'params'          => 'send'
			] );

		} elseif ( $type == 'received' ) {
			$query_params = [
				'post_type'      => 'offer',
				'post_status'    => [ 'publish' ],
				'meta_query'     => [
					[
						'key'     => 'offer_buyer',
						'value'   => get_current_user_id(),
						'compare' => '='
					]
				]
			];

			$proposals_list = new WPJ_Load_More_Posts( $query_params + [
				'function_name'   => 'wpj_display_proposal_list_items',
				'container_class' => 'all-proposals-page',
				'params'          => 'received'
			] );

		}

		if ( ! empty( $proposals_list ) ) {
			wpj_get_template( 'listings/request/proposals-list-template.php', [
				'tab'            => $type,
				'proposals_data' => apply_filters( 'wpj_user_proposals_' . $type . '_result_filter', $proposals_list )
			] );
		}
	}
}