<?php
if ( ! function_exists( 'wpj_display_user_info_item' ) ) {
	function wpj_display_user_info_item( $user_data = '' ) { // search user style
		if ( ! is_object( $user_data ) ) {
			$user_data = get_userdata( $user_data );
		}

		$uid = $user_data->ID;
		$cid = get_current_user_id();

		$completed_jobs = intval( wpj_get_sales_orders( $uid, 'completed' ) ) + intval( wpj_get_shopping_orders( $uid, 'completed' ) );

		$registered_data = strtotime( $user_data->user_registered ) > 0 ? wpj_seconds_to_words_joined( time() - strtotime( $user_data->user_registered ) ) : __( 'There is no record of the date!', 'wpjobster' );

		if ( wpj_get_option( 'wpjobster_enable_user_company' ) == 'yes' && get_user_meta( $uid, 'user_company', true ) ) {
			$user_company = '(' . get_user_meta( $uid, 'user_company', true ) . ')';

		} else {
			$user_company = '';

		}

		$personal_info = get_user_meta( $uid, 'description', true );

		if ( wpj_get_option( 'wpjobster_wysiwyg_for_profile' ) != 'yes' )
			$personal_info = wpj_stripslashes( $personal_info );

		else
			$personal_info = wpj_get_allowed_html_tags_for_wysiwyg( get_user_meta( $uid, 'description', true ) );

		$personal_info = wpj_apply_filter_to_string( $personal_info, false, 'userprofiles' );

		if ( $personal_info ) $personal_info = wpj_truncate_html( $personal_info, 150 );

		$contact_section = apply_filters( 'hide_for_buyers', true, $uid );

		if ( $uid != $cid && ( $contact_section || wpj_users_have_conversations( $cid, $uid ) || wpj_users_have_transactions( $cid, $uid ) ) ) {
			$contact_url = wpj_get_pm_link( $user_data->user_login );

		} else {
			$contact_url = '';

		}

		wpj_get_template( 'listings/user-item/users-list-item-template.php', [
			'uid'             => $uid,
			'user_data'       => $user_data,
			'completed_jobs'  => $completed_jobs,
			'registered_data' => $registered_data,
			'company'         => $user_company,
			'description'     => $personal_info,
			'contact_url'     => $contact_url
		] );
	}
}