<?php
if ( ! function_exists( 'wpj_display_users_list' ) ) {
	function wpj_display_users_list( $args = [] ) {
		$columns = ! empty( $args['columns'] ) ? wpj_number_to_string( $args['columns'] ) : 'four';

		$query_args = [
			'query_type'        => 'users',
			'query_status'      => 'all',
			'function_name'     => 'wpj_display_user_info_item',
			'row_extra_classes' => 'ui ' . $columns . ' cards',
			'posts_per_page'    => ! empty( $args['users'] ) ? $args['users'] : wpj_get_option( 'posts_per_page' )
		];

		if ( ! empty( $args['level'] ) ) {
			$query_args['query_params']['level'] = $args['level'];
		}

		if ( ! empty( $args['order'] ) ) {
			$query_args['query_params']['order'] = $args['order'];
		}

		$users = new WPJ_Load_More_Queries( $query_args );

		wpj_get_template( 'listings/user/users-list-template.php', [
			'users' => $users
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}