<?php /* Authentication */

if ( ! function_exists( 'wpj_init_authentication_modals' ) ) {
	function wpj_init_authentication_modals() {
		if ( ! is_user_logged_in() ) {
			wpj_init_user_login_modal();
			wpj_init_user_register_modal();
			wpj_init_user_lost_password_modal();
		}
	}
}

if ( ! function_exists( 'wpj_init_user_login_modal' ) ) {
	function wpj_init_user_login_modal() {
		wpj_get_template( 'modals/authentication/user-login-template.php', [
			'login_page' => get_post( wpj_get_option( 'wpjobster_login_page_id' ) )
		] );
	}
}

if ( ! function_exists( 'wpj_init_user_register_modal' ) ) {
	function wpj_init_user_register_modal() {
		wpj_get_template( 'modals/authentication/user-register-template.php', [
			'register_page' => get_post( wpj_get_option( 'wpjobster_register_page_id' ) )
		] );
	}
}

if ( ! function_exists( 'wpj_init_user_lost_password_modal' ) ) {
	function wpj_init_user_lost_password_modal() {
		wpj_get_template( 'modals/authentication/user-lost-password-template.php', [
			'lost_password_page' => get_post( wpj_get_option( 'wpjobster_forgot_password_page_id' ) )
		] );
	}
}