<?php
if ( ! function_exists( 'wpj_init_request_custom_offer_modal' ) ) {
	function wpj_init_request_custom_offer_modal( $args = [] ) {
		$args['pid']  = $args['id'];
		$args['page'] = ! empty( $args['page'] ) ? $args['page'] : $args['pid'];

		wpj_get_template( 'modals/offer/request-custom-offer-template.php', $args );
	}
}

if ( ! function_exists( 'wpj_init_send_custom_offer_modal' ) ) {
	function wpj_init_send_custom_offer_modal( $args = [] ) {
		$args['pid']  = $args['id'];
		$args['page'] = ! empty( $args['page'] ) ? $args['page'] : $args['pid'];

		if ( $args['extra'] ) {
			if ( wpj_get_user_feature_status( 'wpjobster_enable_min_custom_extras', 'wpjobster_subscription_custom_extras_enabled' ) != 'no' )
				$price_min = wpj_get_user_feature_value( 'min_customextrasamount', 'min_customextrasamount' );
			else
				$price_min = 0;

			if ( wpj_get_user_feature_status( 'wpjobster_enable_max_custom_extras', 'wpjobster_subscription_custom_extras_enabled' ) != 'no' )
				$price_max = wpj_get_user_feature_value( 'max_customextrasamount', 'max_customextrasamount' );
			else
				$price_max = '';

		} else {
			$price_min = wpj_get_option( 'wpj_custom_offer_amount_price_limits' )[1];
			$price_max = wpj_get_option( 'wpj_custom_offer_amount_price_limits' )[2];

			if ( ! is_numeric( $price_min ) || ! is_numeric( $price_max ) || $price_min > $price_max ) {
				$price_min = 5;
				$price_max = 5000;
			}

		}

		$args['price_min'] = $price_min;
		$args['price_max'] = $price_max;

		$args['offer_description'] = apply_filters( 'wpj_send_custom_offer_display_description_filter', true );
		$args['offer_price']       = apply_filters( 'wpj_send_custom_offer_display_price_filter', true );
		$args['offer_days']        = apply_filters( 'wpj_send_custom_offer_display_days_filter', true );

		wpj_get_template( 'modals/offer/send-custom-offer-template.php', $args );
	}
}