<?php
if ( ! function_exists( 'wpj_init_order_modals' ) ) {
	function wpj_init_order_modals( $order = '' ) {
		global $wp_query;

		if ( ! $order && ! empty ( $wp_query->query_vars['oid'] ) ) {
			$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( $order ) {
			wpj_init_add_tips_modal( $order );
			wpj_init_request_arbitration_modal( $order );
			wpj_init_request_extended_delivery_modal( $order );
			wpj_init_request_modification_modal( $order );
			wpj_init_request_mutual_cancellation_modal( $order );
			wpj_init_resolution_center_modal( $order );
		}
	}
}

if ( ! function_exists( 'wpj_init_legend_modal' ) ) {
	function wpj_init_legend_modal( $page = '', $active_tab = '' ) {
		wpj_get_template( 'modals/order/legend-template.php', [
			'statuses'   => wpj_get_post_status_legend( $page ),
			'page'       => $page,
			'active_tab' => $active_tab
		] );
	}
}

if ( ! function_exists( 'wpj_init_add_tips_modal' ) ) {
	function wpj_init_add_tips_modal( $order = '' ) {
		wpj_get_template( 'modals/order/add-tips-template.php', [
			'order'   => $order,
			'orderid' => $order->id,
		] );
	}
}

if ( ! function_exists( 'wpj_init_request_arbitration_modal' ) ) {
	function wpj_init_request_arbitration_modal( $order = '' ) {
		wpj_get_template( 'modals/order/request-arbitration-template.php', [
			'order'   => $order,
			'orderid' => $order->id,
		] );
	}
}

if ( ! function_exists( 'wpj_init_request_extended_delivery_modal' ) ) {
	function wpj_init_request_extended_delivery_modal( $order = '' ) {
		wpj_get_template( 'modals/order/request-extended-delivery-template.php', [
			'order'   => $order,
			'orderid' => $order->id,
		] );
	}
}

if ( ! function_exists( 'wpj_init_request_modification_modal' ) ) {
	function wpj_init_request_modification_modal( $order = '' ) {
		wpj_get_template( 'modals/order/request-modification-template.php', [
			'order'   => $order,
			'orderid' => $order->id,
		] );
	}
}

if ( ! function_exists( 'wpj_init_request_mutual_cancellation_modal' ) ) {
	function wpj_init_request_mutual_cancellation_modal( $order = '' ) {
		wpj_get_template( 'modals/order/request-mutual-cancellation-template.php', [
			'order'   => $order,
			'orderid' => $order->id,
		] );
	}
}

if ( ! function_exists( 'wpj_init_resolution_center_modal' ) ) {
	function wpj_init_resolution_center_modal( $order = '' ) {
		wpj_get_template( 'modals/order/resolution-center-template.php', [
			'order'              => $order,
			'orderid'            => $order->id,
			'cancellation_count' => wpj_get_cancellations_count_by_order_id( $order->id )
		] );
	}
}