<?php
/* Vacation Mode */
if ( ! function_exists( 'wpj_init_vacation_mode_modal' ) ) {
	function wpj_init_vacation_mode_modal() {
		wpj_get_template( 'modals/user/vacation-template.php', [
			'user_vacation' => wpj_get_user_vacation( get_current_user_id() )
		] );
	}
}

/* Export User Transactions */
if ( ! function_exists( 'wpj_init_export_user_transactions_modal' ) ) {
	function wpj_init_export_user_transactions_modal( $uid = '' ) {
		if ( ! $uid ) $uid = get_current_user_id();

		$user_info = get_userdata( $uid );

		$intervals = [
			'today' => [
				'name'       => __( 'Today', 'wpjobster' ),
				'start_date' => date( 'M d Y', strtotime( 'today 00:00' ) ),
				'end_date'   => date( 'M d Y', strtotime( 'today 24:00' ) )
			],
			'yesterday' => [
				'name'       => __( 'Yesterday', 'wpjobster' ),
				'start_date' => date( 'M d Y', strtotime( 'yesterday 00:00' ) ),
				'end_date'   => date( 'M d Y', strtotime( 'yesterday 24:00' ) )
			],
			'seven_days' => [
				'name'       => __( 'Last 7 days', 'wpjobster' ),
				'start_date' => date( 'M d Y', strtotime( '-6 days' ) ),
				'end_date'   => date( 'M d Y', strtotime( 'tomorrow midnight' ) )
			],
			'last_week' => [
				'name'       => __( 'Last week', 'wpjobster' ),
				'start_date' => date( 'M d Y', strtotime( 'last week monday midnight' ) ),
				'end_date'   => date( 'M d Y', strtotime( 'last week sunday + 1 day' ) )
			],
			'last_two_weeks' => [
				'name'       => __( 'Last 2 weeks', 'wpjobster' ),
				'start_date' => date( 'M d Y', strtotime( 'last week monday midnight - 7 days' ) ),
				'end_date'   => date( 'M d Y', strtotime( 'last week sunday + 1 day' ) )
			],
			'this_month' => [
				'name'       => __( 'This month', 'wpjobster' ),
				'start_date' => date( 'M d Y', strtotime( 'first day of this month' ) ),
				'end_date'   => date( 'M d Y', strtotime( 'first day of next month midnight' ) )
			],
			'last_month' => [
				'name'       => __( 'Last month', 'wpjobster' ),
				'start_date' => date( 'M d Y', strtotime( 'first day of last month' ) ),
				'end_date'   => date( 'M d Y', strtotime( 'first day of this month midnight' ) )
			],
			'all' => [
				'name'       => __( 'All', 'wpjobster' ),
				'start_date' => '',
				'end_date'   => ''
			],
		];

		$intervals = apply_filters( 'wpj_export_user_transactions_intervals_filter', $intervals );

		wpj_get_template( 'modals/user/export-user-transactions-template.php', [
			'uid'       => $uid,
			'uname'     => $user_info->user_login,
			'intervals' => $intervals
		] );
	}
}

/* User Education */
if ( ! function_exists( 'wpj_init_new_education_modal' ) ) {
	function wpj_init_new_education_modal( $indx = '' ) {
		/**
		 * @var string $school
		 * @var string $degree
		 * @var string $grade
		 * @var string $study
		 * @var string $activities
		 * @var string $from
		 * @var string $to
		 * @var string $description
		 * @var string $attachments
		 */
		$education_fields = [ 'school', 'degree', 'grade', 'study', 'activities', 'from', 'to', 'description', 'attachments' ];

		if ( $indx || $indx === 0 ) {
			$education = get_user_meta( get_current_user_id(), 'user_educations', true );

			if ( $education ) {
				foreach ( $education_fields as $key => $val ) {
					$$val = isset( $education[$indx][$val] ) ? $education[$indx][$val] : '';
				}
			}

		}

		foreach ( $education_fields as $key => $val ) {
			$$val = isset( $$val ) ? $$val : '';
		}

		wpj_get_template( 'modals/user/new-education-template.php', [
			'indx'        => $indx,
			'school'      => $school,
			'degree'      => $degree,
			'grade'       => $grade,
			'study'       => $study,
			'activities'  => $activities,
			'from'        => $from,
			'to'          => $to,
			'description' => $description,
			'attachments' => $attachments
		] );
	}
}

/* User Certification */
if ( ! function_exists( 'wpj_init_new_certification_modal' ) ) {
	function wpj_init_new_certification_modal( $indx = '' ) {
		/**
		 * @var string $certification_name
		 * @var string $certification_authority
		 * @var string $license_number
		 * @var string $from_year
		 * @var string $to_year
		 * @var string $from_month
		 * @var string $to_month
		 * @var string $certification_not_expire
		 * @var string $certification_url
		 */
		$certification_fields = [ 'certification_name', 'certification_authority', 'license_number', 'from_year', 'to_year', 'from_month', 'to_month', 'certification_not_expire', 'certification_url' ];

		if ( $indx || $indx === 0 ) {
			$certification = get_user_meta( get_current_user_id(), 'user_certifications', true );

			if ( $certification ) {
				foreach ( $certification_fields as $key => $val ) {
					$$val = isset( $certification[$indx][$val] ) ? $certification[$indx][$val] : '';
				}
			}

		}

		foreach ( $certification_fields as $key => $val ) {
			$$val = isset( $$val ) ? $$val : '';
		}

		wpj_get_template( 'modals/user/new-certification-template.php', [
			'indx'                     => $indx,
			'certification_name'       => $certification_name,
			'certification_authority'  => $certification_authority,
			'license_number'           => $license_number,
			'from_year'                => $from_year,
			'to_year'                  => $to_year,
			'from_month'               => $from_month,
			'to_month'                 => $to_month,
			'certification_not_expire' => $certification_not_expire,
			'certification_url'        => $certification_url,
		] );
	}
}

if ( ! function_exists( 'wpj_init_delete_account_modal' ) ) {
	function wpj_init_delete_account_modal() {
		wpj_get_template( 'modals/user/delete-account-template.php' );
	}
}