<?php

// Login form
if ( ! function_exists( 'wpj_page_login_fnc' ) ) {
	function wpj_page_login_fnc( $display_location = '' ) {
		$wp_login_form = wp_login_form(
			[
				'echo'           => false,
				'redirect'       => wpj_login_redirect(),
				'label_log_in'   => _x( 'Continue', 'Authentication button name', 'wpjobster' ),
				'label_username' => '',
				'label_password' => '',
				'form_id'        => 'loginform_' . wpj_generate_random_value( 5 ),
				'id_username'    => 'user_login_' . wpj_generate_random_value( 5 ),
				'id_password'    => 'user_password_' . wpj_generate_random_value( 5 ),
				'id_remember'    => 'user_remember_' . wpj_generate_random_value( 5 ),
				'id_submit'      => 'wp-submit-' . wpj_generate_random_value( 5 ),
				'remember'       => false
			]
		);
		$wp_login_form = str_replace( 'method="post"', 'method="post" class="ui form js-login-form"', $wp_login_form );
		$wp_login_form = str_replace( 'class="button button-primary"', 'class="ui fluid primary button uppercase js-authentication-button"', $wp_login_form );
		$wp_login_form = str_replace( 'name="log"', 'name="log" placeholder="' . __( 'Username / Email Address', 'wpjobster' ) . '"', $wp_login_form );
		$wp_login_form = str_replace( 'name="pwd"', 'name="pwd" placeholder="' . __( 'Password', 'wpjobster' ) . '"', $wp_login_form );

		wpj_get_template( 'pages/authentication/login-template.php', [
			'wp_login_form'    => $wp_login_form,
			'display_location' => $display_location
		] );
	}
}

// Register form
if ( ! function_exists( 'wpj_page_register_fnc' ) ) {
	function wpj_page_register_fnc( $display_location = '' ) {
		wpj_get_template( 'pages/authentication/register-template.php', [
			'display_location' => $display_location
		] );
	}
}

// Lost password form
if ( ! function_exists( 'wpj_page_forgot_password_fnc' ) ) {
	function wpj_page_forgot_password_fnc( $display_location = '' ) {
		wpj_get_template( 'pages/authentication/lost-password-template.php', [
			'display_location' => $display_location
		] );
	}
}

// Add header to authentication pages
add_action( 'login_head', function() { get_header(); });

// Login custom fields
add_action( 'login_form', 'wpj_add_custom_fields_to_login_form', 10 );
if ( ! function_exists( 'wpj_add_custom_fields_to_login_form' ) ) {
	function wpj_add_custom_fields_to_login_form() {
		wpj_get_template( 'pages/authentication/wp-login-template.php' );
	}
}

add_filter( 'login_form_middle', 'wpj_add_custom_fields_to_custom_login_form', 10 );
if ( ! function_exists( 'wpj_add_custom_fields_to_custom_login_form' ) ) {
	function wpj_add_custom_fields_to_custom_login_form() {
		ob_start();

		if ( $GLOBALS['pagenow'] !== 'wp-login.php' ) {
			wpj_get_template( 'pages/authentication/wp-login-template.php' );
		}

		return ob_get_clean();
	}
}

// Register custom fields
add_action( 'register_form', 'wpj_add_password_fields_to_register_form', 1 );
if ( ! function_exists( 'wpj_add_password_fields_to_register_form' ) ) {
	function wpj_add_password_fields_to_register_form() {
		wpj_get_template( 'pages/authentication/wp-register-template.php', [
			'with_priority' => true
		] );
	}
}

add_action( 'register_form', 'wpj_add_custom_fields_to_register_form', 11 );
if ( ! function_exists( 'wpj_add_custom_fields_to_register_form' ) ) {
	function wpj_add_custom_fields_to_register_form() {
		wpj_get_template( 'pages/authentication/wp-register-template.php', [
			'with_priority' => false
		] );
	}
}

// Add footer to authentication pages
add_action( 'login_footer', function() { get_footer(); });