<?php
if ( ! function_exists( 'wpj_page_single_job_fnc' ) ) {
	function wpj_page_single_job_fnc() {
		$pid  = wpj_get_post_id();
		$post = get_post( $pid );

		$user = wpj_get_userdata( $post->post_author );

		wpj_save_last_viewed_job( $pid );

		wpj_get_template( 'pages/job/single-job-template.php', [
			'post'            => $post,
			'pid'             => $post->ID,
			'user'            => $user,
			'has_cover_image' => ! empty( get_post_meta( get_the_ID(), 'cover-image', true ) ) && wpj_get_attachment_image_url( get_post_meta( get_the_ID(), 'cover-image', true ), 'job_cover_image' ),
			'display_tags'    => get_the_tags() ? true : false,
			'display_views'   => wpj_get_option( 'wpjobster_enable_job_views' ) == 'yes'
		] );
	}
}

if ( ! function_exists( 'wpj_page_my_account_fnc' ) ) {
	function wpj_page_my_account_fnc() {
		global $wp_query;

		$uid = get_current_user_id();

		$tabs = wpj_get_tabs_by_page( 'user_jobs' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		wpj_get_template( 'pages/job/my-account-template.php', [
			'uid'        => $uid,
			'tabs'       => $tabs,
			'active_tab' => $active_tab,
		] );
	}
}

if ( ! function_exists( 'wpj_page_favourites_fnc' ) ) {
	function wpj_page_favourites_fnc() {
		wpj_get_template( 'pages/job/my-favorites-template.php' );
	}
}

if ( ! function_exists( 'wpj_page_all_categories_fnc' ) ) {
	function wpj_page_all_categories_fnc() {
		wpj_get_template( 'pages/job/all-categories-template.php' );
	}
}

if ( ! function_exists( 'wpj_page_job_search_fnc' ) ) {
	function wpj_page_job_search_fnc() {
		wpj_get_template( 'pages/job/search-job-template.php' );
	}
}

if ( ! function_exists( 'wpj_page_post_new_edit_job_fnc' ) ) {
	function wpj_page_post_new_edit_job_fnc() {
		if ( function_exists( 'have_rows' ) && have_rows( 'job_fields', wpj_get_option( 'wpjobster_post_new_page_id' ) ) ) {
			$JobsNewEditClass = new WPJJobsNewEdit();

			$job_fields = wpj_generate_array_tab_fields( 'job', wpj_get_option( 'wpjobster_post_new_page_id' ) );
			$use_tabs   = ! $job_fields[0]['tab_fields'];

			end( $job_fields ); $last_tab = key( $job_fields ); // get last tab

			$class        = $use_tabs ? 'tabs-container' : 'post-new-no-tab-wrapper';
			$last_tab_str = wpj_number_to_string( $last_tab );
			$action_type  = isset( $_GET['action'] ) ? 'edit-job' : 'new-job';

			wpj_get_template( 'pages/job/post-new-edit-job-template.php', [
				'JobsNewEditClass' => $JobsNewEditClass,
				'tab_no'           => 0,
				'tab_number'       => 0,
				'ji'               => 0,
				'ti'               => 0,
				'uid'              => get_current_user_id(),
				'pid'              => WPJ_Form::get( 'jobid' ),
				'post'             => get_post( WPJ_Form::get( 'jobid' ) ),
				'job_fields'       => $job_fields,
				'use_tabs'         => $use_tabs,
				'last_tab'         => $last_tab,
				'class'            => $class,
				'action_type'      => $action_type,
				'last_tab_str'     => $last_tab_str
			] );

		} else {
			wpj_get_template( 'pages/job/post-new-edit-job-template.php' );

		}
	}
}

if ( ! function_exists( 'wpj_page_jobs_map_overview_fnc' ) ) {
	function wpj_page_jobs_map_overview_fnc() {
		wpj_get_template( 'pages/job/jobs-map-overview-template.php' );
	}
}