<?php
if ( ! function_exists( 'wpj_page_all_notifications_fnc' ) ) {
	function wpj_page_all_notifications_fnc() {
		wpj_get_template( 'pages/notify/all-notifications-template.php' );
	}
}

if ( ! function_exists( 'wpj_page_private_message_fnc' ) ) {
	function wpj_page_private_message_fnc() {
		$current_user_id   = get_current_user_id();
		$current_user_data = wpj_get_userdata( $current_user_id );

		wpj_get_template( 'pages/notify/private-message-template.php', [
			'interlocutor_id'       => wpj_get_pm_interlocutor_from_url( 'id' ),
			'interlocutor_data'     => wpj_get_pm_interlocutor_from_url( 'data' ),
			'interlocutor_username' => is_object( wpj_get_pm_interlocutor_from_url( 'data' ) ) ? wpj_get_user_display_type( wpj_get_pm_interlocutor_from_url( 'id' ) ) : __( 'Deleted User', 'wpjobster' ),
			'current_user_id'       => $current_user_id,
			'current_user_data'     => $current_user_data,
			'type'                  => WPJ_Form::get( 'type' )
		] );
	}
}

if ( ! function_exists( 'wpj_page_email_settings_fnc' ) ) {
	function wpj_page_email_settings_fnc() {
		wpj_get_template( 'pages/notify/email-settings-template.php', [
			'sms_gateway_op' => wpj_get_option( 'wpjobster_sms_gateways_enable' )
		] );
	}
}