<?php
if ( ! function_exists( 'wpj_page_order_fnc' ) ) {
	function wpj_page_order_fnc() {
		global $wp_query;

		$oid = WPJ_Form::request( 'oid' );

		if ( ! $oid && isset( $wp_query->query_vars['oid'] ) ) $oid = $wp_query->query_vars['oid'];

		$order = wpj_get_job_order_by_id( $oid );

		if ( isset( $order->id ) ) {
			$job_post = get_post( $order->pid );

			// Modals
			wpj_init_order_modals( $order );

			// Users
			$seller_data = get_userdata( wpj_get_seller_id( $order ) );
			$seller_name = is_object( $seller_data ) ? wpj_get_user_display_type( wpj_get_seller_id( $order ) ) : __( 'Deleted User', 'wpjobster' );

			$buyer_data  = get_userdata( $order->uid );
			$buyer_name  = is_object( $buyer_data ) ? wpj_get_user_display_type( $order->uid ) : __( 'Deleted User', 'wpjobster' );

			wpj_get_template( 'pages/order/order-template.php', [
				'order'             => $order,
				'job_post'          => $job_post,
				'seller_name'       => $seller_name,
				'buyer_name'        => $buyer_name,
				'offer_class'       => wpj_is_custom_offer( $order->pid ) ? 'cp-offer-class' : ''
			] );

		} else wpj_get_template( 'pages/order/order-template.php', [ 'order' => $order ] );
	}
}

if ( ! function_exists( 'wpj_page_topup_order_fnc' ) ) {
	function wpj_page_topup_order_fnc() {
		$order = wpj_get_topup_order_details();

		wpj_get_template( 'pages/order/topup-order-template.php', [
			'uid'                => $order['uid'],
			'orderid'            => $order['orderid'],
			'order'              => $order['current_order'],
			'date_made'          => $order['date_made'],
			'order_status_lbl'   => $order['order_status_lbl'],
			'order_status_class' => $order['order_status_class'],
			'order_status_desc'  => $order['order_status_desc'],
			'payment_method'     => $order['payment_method'],
			'show_bank_details'  => apply_filters( 'wpj_show_bank_details_order_page_filter', true, $order['payment_method'] ),
		] );
	}
}

if ( ! function_exists( 'wpj_page_review_fnc' ) ) {
	function wpj_page_review_fnc() {
		global $wp_query;

		$tabs = wpj_get_tabs_by_page( 'user_feedback' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		wpj_get_template( 'pages/order/my-reviews-template.php', [
			'active_tab' => $active_tab,
			'tabs'       => $tabs
		] );
	}
}