<?php
if ( ! function_exists( 'wpj_page_sales_fnc' ) ) {
	function wpj_page_sales_fnc() {
		global $wp_query;

		$uid = get_current_user_id();

		$tabs = wpj_get_tabs_by_page( 'user_sales' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		wpj_get_template( 'pages/payment/my-sales-template.php', [
			'uid'        => $uid,
			'active_tab' => $active_tab,
			'tabs'       => $tabs,
		] );
	}
}

if ( ! function_exists( 'wpj_page_shopping_fnc' ) ) {
	function wpj_page_shopping_fnc() {
		global $wp_query;

		$uid = get_current_user_id();

		$tabs = wpj_get_tabs_by_page( 'user_shopping' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		wpj_get_template( 'pages/payment/my-shopping-template.php', [
			'uid'        => $uid,
			'active_tab' => $active_tab,
			'tabs'       => $tabs,
		] );
	}
}

if ( ! function_exists( 'wpj_page_payments_fnc' ) ) {
	function wpj_page_payments_fnc() {
		global $wp_query;

		$tabs = wpj_get_tabs_by_page( 'user_payments' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		wpj_get_template( 'pages/payment/my-payments-template.php', [
			'currency'       => wpj_get_site_currency(),
			'uid'            => get_current_user_id(),
			'active_tab'     => $active_tab,
			'tabs'           => $tabs,
			'topup_packages' => wpj_get_option( 'topup-packages-settings' ),
		] );
	}
}

if ( ! function_exists( 'wpj_page_checkout_fnc' ) ) {
	function wpj_page_checkout_fnc() {
		$pid = wpj_get_payment_info_by_url( 'pid' );

		wpj_get_template( 'pages/payment/checkout-template.php', [
			'pid'           => $pid,
			'post'          => get_post( $pid ),
			'payment_type'  => wpj_get_payment_info_by_url( 'payment_type' ),
			'Custom_Fields' => new WPJ_Custom_Fields( $pid, 'job' )
		] );
	}
}

if ( ! function_exists( 'wpj_page_badge_checkout_fnc' ) ) {
	function wpj_page_badge_checkout_fnc() {
		$badges_data = wpj_get_badge_info();

		$user_badge = get_user_meta( get_current_user_id(), 'user_badge', true );

		if ( $user_badge && ! is_array( $user_badge ) ) $user_badge = [ $user_badge ];

		wpj_get_template( 'pages/payment/badge-checkout-template.php', [
			'badges_data' => $badges_data,
			'user_badge'  => $user_badge
		] );
	}
}

if ( ! function_exists( 'wpj_page_feature_checkout_fnc' ) ) {
	function wpj_page_feature_checkout_fnc() {
		wpj_get_template( 'pages/payment/feature-checkout-template.php', [
			'pid' => wpj_get_post_id()
		] );
	}
}

if ( ! function_exists( 'wpj_page_subscription_fnc' ) ) {
	function wpj_page_subscription_fnc() {
		global $wp_query;

		$tabs = wpj_get_tabs_by_page( 'user_subscription' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		$is_subscribed = '0';

		if ( is_object( wpj_get_subscription_by_uid( get_current_user_id() ) ) ) $is_subscribed = '1';

		$subscription_arr = [
			'is_subscription_enabled' => wpj_get_option( 'wpjobster_subscription_enabled' ),
			'is_subscribed'           => $is_subscribed,
			'tabs'                    => $tabs,
			'active_tab'              => $active_tab
		];

		$subscription_arr['subscription_form_arr'] = $subscription_arr;

		wpj_get_template( 'pages/payment/subscription-template.php', $subscription_arr );
	}
}