<?php
if ( ! function_exists( 'wpj_page_single_request_fnc' ) ) {
	function wpj_page_single_request_fnc() {
		$pid  = wpj_get_post_id();
		$post = get_post( $pid );

		wpj_get_template( 'pages/request/single-request-template.php', [
			'pid'          => $pid,
			'post'         => $post,
			'post_content' => wpj_apply_filter_to_string( wpautop( strip_tags( $post->post_content ) ), false, 'requestlistings' )
		] );
	}
}

if ( ! function_exists( 'wpj_page_my_requests_fnc' ) ) {
	function wpj_page_my_requests_fnc() {
		global $wp_query;

		$uid = get_current_user_id();

		$tabs = wpj_get_tabs_by_page( 'user_requests' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		wpj_get_template( 'pages/request/my-request-template.php', [
			'uid'        => $uid,
			'active_tab' => $active_tab,
			'tabs'       => $tabs,
		] );
	}
}

if ( ! function_exists( 'wpj_page_request_search_fnc' ) ) {
	function wpj_page_request_search_fnc() {
		wpj_get_template( 'pages/request/search-request-template.php' );
	}
}

if ( ! function_exists( 'wpj_page_post_new_edit_request_fnc' ) ) {
	function wpj_page_post_new_edit_request_fnc() {
		if ( function_exists( 'have_rows' ) && have_rows( 'request_fields', wpj_get_option( 'wpjobster_new_request_page_id' ) ) ) {
			$RequestsNewEditClass = new WPJRequestsNewEdit();

			$request_fields = wpj_generate_array_tab_fields( 'request', wpj_get_option( 'wpjobster_new_request_page_id' ) );
			$use_tabs = ! $request_fields[0]['tab_fields'];

			end( $request_fields ); $last_tab = key( $request_fields ); // get last tab

			$class        = $use_tabs ? 'tabs-container' : 'post-new-no-tab-wrapper';
			$last_tab_str = wpj_number_to_string( $last_tab );
			$action_type  = isset( $_GET['action'] ) ? 'edit-request' : 'new-request';

			wpj_get_template( 'pages/request/post-new-edit-request-template.php', [
				'RequestsNewEditClass' => $RequestsNewEditClass,
				'tab_no'               => 0,
				'tab_number'           => 0,
				'ji'                   => 0,
				'ti'                   => 0,
				'uid'                  => get_current_user_id(),
				'pid'                  => WPJ_Form::get( 'requestid' ),
				'post'                 => get_post( WPJ_Form::get( 'requestid' ) ),
				'request_fields'       => $request_fields,
				'use_tabs'             => $use_tabs,
				'last_tab'             => $last_tab,
				'class'                => $class,
				'action_type'          => $action_type,
				'last_tab_str'         => $last_tab_str
			] );

		} else {
			wpj_get_template( 'pages/request/post-new-edit-request-template.php' );

		}
	}
}

if ( ! function_exists( 'wpj_page_all_requests_fnc' ) ) {
	function wpj_page_all_requests_fnc() {
		wpj_get_template( 'pages/request/all-requests-template.php' );
	}
}

if ( ! function_exists( 'wpj_page_proposals_fnc' ) ) {
	function wpj_page_all_proposals_fnc() {
		global $wp_query;

		$tabs = wpj_get_tabs_by_page( 'user_proposals' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		wpj_get_template( 'pages/request/all-proposals-template.php',
			[
				'active_tab'          => $active_tab,
				'tabs'                => $tabs,
				'uid'                 => get_current_user_id(),
				'count_send'          => wpj_get_user_proposals( get_current_user_id(), 'send', 'count' ),
				'count_received'      => wpj_get_user_proposals( get_current_user_id(), 'received', 'count' ),
				'enable_custom_offer' => wpj_get_option( 'wpjobster_enable_custom_offers' )
			]
		);
	}
}