<?php
if ( ! function_exists( 'wpj_page_not_found_fnc' ) ) {
	function wpj_page_not_found_fnc() {
		wpj_get_template( 'pages/site/404-template.php' );
	}
}

if ( ! function_exists( 'wpj_page_homepage_fnc' ) ) {
	function wpj_page_homepage_fnc() {
		wpj_get_template( 'pages/site/homepage-template.php', [
			'categories' => get_categories( [ 'taxonomy' => 'job_cat', 'parent' => 0, 'hide_empty' => false ] )
		] );
	}
}

if ( ! function_exists( 'wpj_page_homepage_loggedin_fnc' ) ) {
	function wpj_page_homepage_loggedin_fnc() {
		wpj_get_template( 'pages/site/homepage-loggedin-template.php', [
			'is_seller' => apply_filters( 'hide_for_buyers', true, get_current_user_id() )
		] );
	}
}

if ( ! function_exists( 'wpj_page_levels_fnc' ) ) {
	function wpj_page_levels_fnc() {
		$level0_benefits = [
			__( 'Jobs up to $500', 'wpjobster' ),
			__( 'Extras up to $100', 'wpjobster' ),
			__( 'Custom Extras up to $100', 'wpjobster' ),
			__( '20% fee for orders up to $20', 'wpjobster' ),
			__( '19% fee for orders over $20', 'wpjobster' ),
			__( '18% fee for orders over $100', 'wpjobster' ),
			__( '11% fee for orders over $500', 'wpjobster' ),
			__( '3 Extra Services', 'wpjobster' ),
			__( '3 Additional Revisions', 'wpjobster' ),
			__( '3 Extra Fast Deliveries', 'wpjobster' ),
			__( '3 Multiples', 'wpjobster' ),
			__( '1 Video Presentation per Job', 'wpjobster' )
		];

		$level1_benefits = [
			__( 'Jobs up to $1000', 'wpjobster' ),
			__( 'Extras up to $200 ', 'wpjobster' ),
			__( 'Custom Extras up to $200', 'wpjobster' ),
			__( '20% fee for orders up to $20', 'wpjobster' ),
			__( '19% fee for orders over $20', 'wpjobster' ),
			__( '18% fee for orders over $100', 'wpjobster' ),
			__( '11% fee for orders over $500', 'wpjobster' ),
			__( '5 Extra Services', 'wpjobster' ),
			__( '5 Additional Revisions', 'wpjobster' ),
			__( '5 Extra Fast Deliveries', 'wpjobster' ),
			__( '5 Multiples', 'wpjobster' ),
			__( '2 Video Presentation per Job', 'wpjobster' )
		];

		$level2_benefits = [
			__( 'Jobs up to $5000', 'wpjobster' ),
			__( 'Extras up to $1000 ', 'wpjobster' ),
			__( 'Custom Extras up to $1000', 'wpjobster' ),
			__( '20% fee for orders up to $20', 'wpjobster' ),
			__( '15% fee for orders over $20', 'wpjobster' ),
			__( '14% fee for orders over $100', 'wpjobster' ),
			__( '9% fee for orders over $500', 'wpjobster' ),
			__( '10 Extra Services', 'wpjobster' ),
			__( '10 Additional Revisions', 'wpjobster' ),
			__( '10 Extra Fast Deliveries', 'wpjobster' ),
			__( '10 Multiples', 'wpjobster' ),
			__( '3 Video Presentation per Job', 'wpjobster' )
		];

		$level3_benefits = [
			__( 'Jobs up to $10000', 'wpjobster' ),
			__( 'Extras up to $2000 ', 'wpjobster' ),
			__( 'Custom Extras up to $2000', 'wpjobster' ),
			__( '20% fee for orders up to $20', 'wpjobster' ),
			__( '13% fee for orders over $20', 'wpjobster' ),
			__( '12% fee for orders over $100', 'wpjobster' ),
			__( '8% fee for orders over $500', 'wpjobster' ),
			__( '20 Extra Services', 'wpjobster' ),
			__( '20 Additional Revisions', 'wpjobster' ),
			__( '20 Extra Fast Deliveries', 'wpjobster' ),
			__( '20 Multiples', 'wpjobster' ),
			__( '5 Video Presentation per Job', 'wpjobster' )
		];

		wpj_get_template( 'pages/site/levels-template.php', [
			'icon'            => 'check circle outline',
			'level0_benefits' => $level0_benefits,
			'level1_benefits' => $level1_benefits,
			'level2_benefits' => $level2_benefits,
			'level3_benefits' => $level3_benefits
		] );
	}
}

if ( ! function_exists( 'wpj_page_how_it_works_fnc' ) ) {
	function wpj_page_how_it_works_fnc() {
		$buyer_content = [
			[
				'title'       => __( '1. Find a service that you need', 'wpjobster' ),
				'description' => __( 'Compare prices, portfolios, delivery time, and community recommendations in order to find a seller that best suits your needs. If you have a specific question, simply send them an enquiry.', 'wpjobster' )
			],
			[
				'title'       => __( '2. Supply your brief', 'wpjobster' ),
				'description' => __( 'Be as detailed as possible so the seller can provide you with the quality service that you are expecting. Your payment is held secure until you confirm that the service is performed to your satisfaction.', 'wpjobster' )
			],
			[
				'title'       => __( '3. Manage transaction', 'wpjobster' ),
				'description' => __( 'Exchange files and feedback with the seller via the built-in conversation and transaction management system. The seller will deliver service within a specified time frame.', 'wpjobster' )
			],
			[
				'title'       => __( '4. Approve service delivered', 'wpjobster' ),
				'description' => __( 'Once you are happy with the service performed, you can mark the transaction complete, and we’ll make sure that the seller gets paid. Help the community by leaving a feedback for the seller.', 'wpjobster' )
			]
		];

		$seller_content = [
			[
				'title'       => __( '1. Post your service', 'wpjobster' ),
				'description' => __( 'Post a service offer in accordance with your skills. Be as specific as possible so your clients will know exactly what they are getting for the money they are paying.', 'wpjobster' )
			],
			[
				'title'       => __( '2. Communicate promptly', 'wpjobster' ),
				'description' => __( 'Respond to customer enquiries, as well as requests for custom offers, within a reasonable time. Good communication is a prerequisite for successful cooperation.', 'wpjobster' )
			],
			[
				'title'       => __( '3. Build your reputation', 'wpjobster' ),
				'description' => __( 'Make sure you treat all of your customers the same, and try to provide the best possible service regardless of the transaction value. Satisfied customers will recommend you to their friends.', 'wpjobster' )
			]
		];

		wpj_get_template( 'pages/site/how-it-works-template.php', [
			'seller_content' => $seller_content,
			'buyer_content'  => $buyer_content
		] );
	}
}

if ( ! function_exists( 'wpj_page_privacy_policy_fnc' ) ) {
	function wpj_page_privacy_policy_fnc() {
		wpj_get_template( 'pages/site/privacy-policy-template.php' );
	}
}

if ( ! function_exists( 'wpj_page_terms_of_service_fnc' ) ) {
	function wpj_page_terms_of_service_fnc() {
		wpj_get_template( 'pages/site/terms-of-service-template.php' );
	}
}