<?php

if ( ! function_exists( 'wpj_page_personal_info_fnc' ) ) {
	function wpj_page_personal_info_fnc() {
		global $wp_query;

		$tabs = wpj_get_tabs_by_page( 'user_settings' );

		$active_tab = isset( $wp_query->query_vars['pg'] ) ? urldecode( $wp_query->query_vars['pg'] ) : '';

		if ( ! $active_tab ) $active_tab = array_key_first( $tabs );

		$uid       = get_current_user_id();
		$user_info = wpj_get_userdata( $uid );

		$phone_number = empty( $_POST['cell_number'] ) ? wpj_user( $uid, 'cell_number' ) : wpj_stripslashes( wpj_validate_input_content( $_POST['cell_number'] ) );

		$custom_field = new WPJ_Custom_Fields( $uid, 'up' );

		if ( wpj_get_option( 'wpjobster_phone_country_select' ) != 'autodetect' ) {
			$default_country = wpj_get_option( 'wpjobster_phone_country_select' );

		} else {
			$default_country = wpj_get_country_code_by_ip( wpj_get_user_ip() );

		}

		$registration_data_fields = [
			'first_name'   => [
				'label'       => __( 'First Name', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'First Name', 'wpjobster' ),
				'value'       => empty( $_POST['first_name'] ) ? wpj_stripslashes( wpj_user( $uid, 'first_name' ) ) : wpj_stripslashes( $_POST['first_name'] ),
				'atts'        => ''
			],
			'last_name'    => [
				'label'       => __( 'Last Name', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'Last Name', 'wpjobster' ),
				'value'       => empty( $_POST['last_name'] ) ? wpj_stripslashes( wpj_user( $uid, 'last_name' ) ) : wpj_stripslashes( $_POST['last_name'] ),
				'atts'        => ''
			],
			'email'        => [
				'label'       => __( 'Email', 'wpjobster' ),
				'inp_type'    => 'email',
				'placeholder' => _x( 'email@example.com', 'Placeholder for: Email', 'wpjobster' ),
				'value'       => apply_filters( 'wpj_user_email_settings_filter', empty( $_POST['email'] ) ? $user_info->user_email : wpj_stripslashes( $_POST['email'] ), $uid ),
				'atts'        => ''
			],
			'cell_number'  => [
				'label'       => __( 'Phone Number', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => _x( '+123456789000', 'Placeholder for: Phone Number', 'wpjobster' ),
				'value'       => wpj_format_phone_number( $uid, $phone_number ),
				'atts'        => 'class="cell_number" data-default-country="' . $default_country . '" data-only-countries="' . apply_filters( 'wpj_phone_prefixes_intltelinput_filter', '' ) . '" data-country="' . get_user_meta( $uid, 'country_code', true ) . '"'
			]
		];

		if ( wpj_get_option( 'wpjobster_enable_user_company' ) == 'yes' ) {
			$registration_data_fields['user_company'] = [
				'label'       => __( 'Company', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => _x( 'My Company LLC', 'Placeholder for: Company', 'wpjobster' ),
				'value'       => empty( $_POST['company'] ) ? get_user_meta( $uid, 'user_company', true ) : wpj_stripslashes( $_POST['company'] ),
				'atts'        => ''
			];
		}

		if ( wpj_get_option( 'wpjobster_enable_user_vat_id' ) == 'yes' ) {
			$registration_data_fields['tax_id'] = [
				'label'       => __( 'Tax/VAT ID', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => _x( 'XX-XXXXXXX', 'Placeholder for: Tax ID', 'wpjobster' ),
				'value'       => empty( $_POST['tax_id'] ) ? get_user_meta( $uid, 'tax_id', true ) : wpj_stripslashes( $_POST['tax_id'] ),
				'atts'        => ''
			];
		}

		$address_data_fields = [
			'city'   => [
				'label'       => __( 'City', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'City', 'wpjobster' ),
				'value'       => empty( $_POST['city'] ) ? wpj_stripslashes( wpj_user( $uid, 'city' ) ) : wpj_stripslashes( $_POST['city'] ),
				'atts'        => ''
			],
			'state'   => [
				'label'       => __( 'State/Province/Region', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'State/Province/Region', 'wpjobster' ),
				'value'       => empty( $_POST['state'] ) ? wpj_stripslashes( wpj_user( $uid, 'state' ) ) : wpj_stripslashes( $_POST['state'] ),
				'atts'        => ''
			],
			'zip'   => [
				'label'       => __( 'ZIP/Postal Code', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => _x( '123456', 'Placeholder for: ZIP Code', 'wpjobster' ),
				'value'       => empty( $_POST['zip'] ) ? wpj_stripslashes( wpj_user( $uid, 'zip' ) ) : wpj_stripslashes( $_POST['zip'] ),
				'atts'        => ''
			]
		];

		if ( wpj_get_option( "wpjobster_enable_country_select" ) != "no" ) {
			$address_data_fields['country_code'] = [
				'label'       => __( 'Country', 'wpjobster' ),
				'inp_type'    => 'select',
				'placeholder' => '',
				'value'       => wpj_user( $uid, 'country_code' ),
				'atts'        => wpj_get_country_name_by_code()
			];
		}

		$address_data_fields['timezone_select'] = [
			'label'       => __( 'Timezone', 'wpjobster' ),
			'inp_type'    => 'select',
			'placeholder' => '',
			'value'       => wpj_user( $uid, 'timezone_select' ),
			'atts'        => wpj_get_timezone_by_name()
		];

		if ( count( wpj_get_preferred_languages() ) > 1 ) {
			$address_data_fields['preferred_language'] = [
				'label'       => __( 'Preffered Notifications Language', 'wpjobster' ),
				'inp_type'    => 'select',
				'placeholder' => '',
				'value'       => wpj_user( $uid, 'preferred_language' ),
				'atts'        => wpj_get_preferred_languages()
			];
		}

		$bank_fields = [
			'bank_bank_name'  => [
				'label'       => __( 'Bank Name', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'Bank Name', 'wpjobster' ),
				'value'       => wpj_user( $uid, 'bank_bank_name' ),
				'atts'        => ''
			],
			'bank_bank_address'  => [
				'label'       => __( 'Bank Address', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'Bank Address', 'wpjobster' ),
				'value'       => wpj_user( $uid, 'bank_bank_address' ),
				'atts'        => ''
			],
			'bank_account_name'  => [
				'label'       => __( 'Bank Account Name', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'Bank Account Name', 'wpjobster' ),
				'value'       => wpj_user( $uid, 'bank_account_name' ),
				'atts'        => ''
			],
			'bank_account_number'  => [
				'label'       => __( 'Bank Account Number', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'Bank Account Number', 'wpjobster' ),
				'value'       => wpj_user( $uid, 'bank_account_number' ),
				'atts'        => ''
			],
			'bank_account_currency'  => [
				'label'       => __( 'Bank Account Currency', 'wpjobster' ),
				'inp_type'    => 'text',
				'placeholder' => __( 'Bank Account Currency', 'wpjobster' ),
				'value'       => wpj_user( $uid, 'bank_account_currency' ),
				'atts'        => ''
			],
			'bank_additional_info'  => [
				'label'       => __( 'Bank Additional Info', 'wpjobster' ),
				'inp_type'    => 'textarea',
				'placeholder' => __( 'Bank Additional Info', 'wpjobster' ),
				'value'       => wpj_user( $uid, 'bank_additional_info' ),
				'atts'        => ''
			]
		];

		wpj_get_template( 'pages/user/personal-info-template.php', [
			'uid'                      => $uid,
			'active_tab'               => $active_tab,
			'tabs'                     => $tabs,
			'providers'                => wpj_get_user_social_media_providers(),
			'custom_field'             => $custom_field,
			'registration_data_fields' => apply_filters( 'wpj_user_registration_data_fields_filter', $registration_data_fields ),
			'address_data_fields'      => apply_filters( 'wpj_user_address_data_fields_filter', $address_data_fields ),
			'bank_fields'              => apply_filters( 'wpj_user_bank_fields_filter', $bank_fields ),
		] );

	}
}

if ( ! function_exists( 'wpj_page_user_search_fnc' ) ) {
	function wpj_page_user_search_fnc() {
		$term      = WPJ_Form::request( 'term' );
		$location  = WPJ_Form::request( 'location' );
		$radius    = WPJ_Form::request( 'radius' );

		if ( wpj_get_option( 'wpjobster_locations_unit' ) == 'miles' ) {
			$radius_placeholder = __( 'Radius (miles)', 'wpjobster' );

		} else {
			$radius_placeholder = __( 'Radius (kilometers)', 'wpjobster' );

		}

		if ( wpj_get_option( 'wpjobster_enable_user_company' ) == 'yes' ) {
			$title_placeholder = __( 'Username, First Name, Last Name, Company or Description', 'wpjobster' );

		} else {
			$title_placeholder = __( 'Username, First Name, Last Name or Description', 'wpjobster' );

		}

		wpj_get_template( 'pages/user/search-user-template.php', [
			'term'               => $term,
			'location'           => $location,
			'radius'             => $radius,
			'radius_placeholder' => $radius_placeholder,
			'title_placeholder'  => $title_placeholder
		] );
	}
}

if ( ! function_exists( 'wpj_page_user_profile_fnc' ) ) {
	function wpj_page_user_profile_fnc() {
		$WPJUserProfile = new WPJUserProfile();

		wpj_get_template( 'pages/user/user-profile-template.php', [
			'WPJUserProfile' => $WPJUserProfile,
			'uid'            => wpj_get_user_id(),
			'item_per_row'   => function_exists( 'get_field' ) && get_field( 'icons_per_row', wpj_get_option( 'wpjobster_user_profile_page_id' ) ) ? get_field( 'icons_per_row', wpj_get_option( 'wpjobster_user_profile_page_id' ) ) : 3
		] );
	}
}