<?php /* AUTHENTICATION */

wpj_add_shortcode( 'authentication_form', function( $atts = '' ) {
	$_atts = shortcode_atts( [
		'echo'           => false,
		'redirect'       => wpj_login_redirect(),
		'form_id'        => 'loginform_' . wpj_generate_random_value( 5 ),
		'form_class'     => '',
		'label_username' => '',
		'label_password' => '',
		'label_remember' => __( 'Keep me logged in', 'wpjobster' ),
		'label_log_in'   => _x( 'Continue', 'Authentication button name', 'wpjobster' ),
		'id_username'    => 'user_login_' . wpj_generate_random_value( 5 ),
		'id_password'    => 'user_password_' . wpj_generate_random_value( 5 ),
		'id_remember'    => 'user_remember_' . wpj_generate_random_value( 5 ),
		'id_submit'      => 'wp-submit-' . wpj_generate_random_value( 5 ),
		'remember'       => false,
		'value_username' => '',
		'value_remember' => ''
	], $atts );

	$_atts['echo'] = false;

	$wp_login_form = wp_login_form( $_atts );
	$wp_login_form = str_replace( 'method="post"', 'method="post" class="ui form js-login-form form-from-shortcode' . $_atts['form_class'] . '"', $wp_login_form );
	$wp_login_form = str_replace( 'class="button button-primary"', 'class="ui fluid primary button uppercase js-authentication-button"', $wp_login_form );
	$wp_login_form = str_replace( 'name="log"', 'name="log" placeholder="' . __( 'Username / Email Address', 'wpjobster' ) . '"', $wp_login_form );
	$wp_login_form = str_replace( 'name="pwd"', 'name="pwd" placeholder="' . __( 'Password', 'wpjobster' ) . '"', $wp_login_form );

	return $wp_login_form;
});

wpj_add_shortcode( 'password_field', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_password_field' );
});

wpj_add_shortcode( 'phone_number_field', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_phone_number_field' );
});

wpj_add_shortcode( 'company_field', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_company_field' );
});

wpj_add_shortcode( 'tos_field', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_tos_field' );
});