<?php /* COUNT */

wpj_add_shortcode( 'user_ongoing_jobs', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_tooltip', [ 'args' => [ 'tooltip' => wpj_get_ongoing_jobs_count( 'tooltip' ), 'value' => wpj_get_ongoing_jobs_count( 'total' ) ] ] );
});

wpj_add_shortcode( 'user_completed_jobs', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_tooltip', [ 'args' => [ 'tooltip' => wpj_get_completed_jobs_count( 'tooltip' ), 'value' => wpj_get_completed_jobs_count( 'total' ) ] ] );
});

wpj_add_shortcode( 'user_cancelled_jobs', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_tooltip', [ 'args' => [ 'tooltip' => wpj_get_cancelled_jobs_count( 'tooltip' ), 'value' => wpj_get_cancelled_jobs_count( 'total' ) ] ] );
});

wpj_add_shortcode( 'user_posted_jobs', function( $atts = '' ) {
	return wpj_get_posted_jobs_count();
});

wpj_add_shortcode( 'user_ongoing_requests', function( $atts = '' ) {
	return wpj_get_ongoing_requests_count();
});

wpj_add_shortcode( 'user_completed_requests', function( $atts = '' ) {
	return wpj_get_completed_requests_count();
});

wpj_add_shortcode( 'user_cancelled_requests', function( $atts = '' ) {
	return wpj_get_cancelled_requests_count();
});

wpj_add_shortcode( 'user_delivered_on_time', function( $atts = '' ) {
	$_atts = shortcode_atts( [
		'uid' => wpj_get_user_id(),
	], $atts );

	$delivered_on_time_percent = wpj_get_sales_orders( $_atts['uid'], 'delivered_on_time_percent', 'var' );

	if ( ! $delivered_on_time_percent ) {
		$percent_option = wpj_get_option( 'wpj_order_response_rate_stats_percent' );

		if ( is_numeric( $percent_option ) && $percent_option == 0 ) {
			$delivered_on_time_percent = 0;

		} else {
			$delivered_on_time_percent = 100;

		}
	}

	return round( $delivered_on_time_percent ) . '%';
});

wpj_add_shortcode( 'user_order_completion', function( $atts = '' ) {
	$_atts = shortcode_atts( [
		'uid' => wpj_get_user_id(),
	], $atts );

	$completed_percent = wpj_get_sales_orders( $_atts['uid'], 'completed_percent', 'var' );

	if ( ! $completed_percent ) {
		$percent_option = wpj_get_option( 'wpj_order_completion_stats_percent' );

		if ( is_numeric( $percent_option ) && $percent_option == 0 ) {
			$completed_percent = 0;

		} else {
			$completed_percent = 100;

		}
	}

	return round( $completed_percent ) . '%';
});

wpj_add_shortcode( 'user_order_response_rate', function( $atts = '' ) {
	$_atts = shortcode_atts( [
		'uid' => wpj_get_user_id(),
	], $atts );

	$response_rate = wpj_get_sales_orders( $_atts['uid'], 'response_rate', 'var' );

	if ( ! $response_rate ) {
		$percent_option = wpj_get_option( 'wpj_order_response_rate_stats_percent' );

		if ( is_numeric( $percent_option ) && $percent_option == 0 ) {
			$response_rate = 0;

		} else {
			$response_rate = 100;

		}
	}

	return round( $response_rate ) . '%';
});

wpj_add_shortcode( 'user_posted_requests', function( $atts = '' ) {
	return wpj_get_posted_requests_count();
});

wpj_add_shortcode( 'total_posted_jobs', function( $atts = '' ) {
	return wpj_get_total_posted_jobs();
});

wpj_add_shortcode( 'total_posted_requests', function( $atts = '' ) {
	return wpj_get_total_posted_requests();
});

wpj_add_shortcode( 'total_amount_spent', function( $atts = [] ) {
	$_atts = shortcode_atts( [ 'by_user' => '' ], $atts );

	return wpj_get_total_amount_spent( $_atts['by_user'] );
});

wpj_add_shortcode( 'total_completed_jobs', function( $atts = [] ) {
	$_atts = shortcode_atts( [ 'by_user' => '' ], $atts );

	return wpj_get_total_completed_orders( $_atts['by_user'] );
});

wpj_add_shortcode( 'count_site_users', function( $atts = [] ) {
	$_atts = shortcode_atts( [ 'rated_type' => '', 'user_type' => '' ], $atts );

	return wpj_get_total_site_users( $_atts['rated_type'], $_atts['user_type'] );
});