<?php /* EMAIL */

/**
 * List Latest Jobs - Email Shortcode {job_listings}
 *
 * arguments      | accepts         | default
 * ----------------------------------------------------
 * category       | (id/slug/name)  | all
 * featured       | true/false      | false
 * posts_per_page | (int)           | 12
 */
if ( ! function_exists( 'wpj_email_job_listings_shortcode' ) ) {
	function wpj_email_job_listings_shortcode( $text = '', $user_data = '', $email = '' ) {
		if ( ! is_object( $user_data ) && is_numeric( $user_data ) ) $user_data = get_user_by( 'id', $user_data );

		if ( ! $user_data && $email ) $user_data = get_user_by( 'email', $email );

		if ( ! $user_data ) $user_data = get_userdata( get_current_user_id() );

		$user_id = is_object( $user_data ) ? $user_data->ID : get_current_user_id();

		/* LATEST JOBS */
		if ( strpos( $text, '{job_listings' ) !== false ) {
			preg_match( '~\{job_listings([^}]*)\}~', $text, $shortcode );

			$shortcode = array_map( 'trim', $shortcode );

			$posts_per_page = wpj_get_email_shortcode_attr_value( $shortcode, 'posts_per_page' );
			$posts_per_page = $posts_per_page ? intval( $posts_per_page ) : 12;

			$category = wpj_get_email_shortcode_attr_value( $shortcode, 'category' );
			$featured = wpj_get_email_shortcode_attr_value( $shortcode, 'featured' );

			// Category
			$this_term = ctype_digit( $category ) || is_int( $category ) ? get_term_by( 'id', $category, 'job_cat' ) : false;
			$this_term = ! $this_term ? get_term_by( 'slug', $category, 'job_cat' ) : $this_term;
			$this_term = ! $this_term ? get_term_by( 'name', $category, 'job_cat' ) : $this_term;

			$category_id = isset( $this_term->term_id ) && is_numeric( $this_term->term_id ) ? $this_term->term_id : 0;

			$tax_query = $category_id ? [
				[
					'taxonomy' => 'job_cat',
					'field'    => 'term_id',
					'terms'    => [ $category_id ],
				],
			] : [];

			// Query
			$args = [
				'post_status'    =>'publish',
				'posts_per_page' => $posts_per_page,
				'post_type'      => 'job',
				'tax_query'      => $tax_query,
				'order'          => 'DESC',
				'meta_query'     => [
					[
						'key'     => 'active',
						'value'   => '1',
						'compare' => '='
					]
				]
			];

			// Featured
			if ( $featured && wpj_get_option( 'wpjobster_featured_enable' ) == 'yes' ) {
				$args['meta_key'] = 'home_featured_now';
				$args['orderby']  = [ 'meta_value' => 'ASC', 'date' => 'DESC' ];

			} else {
				$args['orderby']  = 'date';

			}

			ob_start();

			wpj_display_card_email_layout( get_posts( $args ) );

			$jobs_list = ob_get_contents();

			ob_end_clean();

			$text = str_replace( $shortcode[0], str_replace( [ "\n", "\r" ], '', $jobs_list ), $text );
		}

		/* JOBS VIEWED */
		if ( strpos( $text, '{job_viewed_listings' ) !== false ) {
			preg_match( '~\{job_viewed_listings([^}]*)\}~', $text, $shortcode );

			$shortcode = array_map( 'trim', $shortcode );

			$user_id_param = wpj_get_email_shortcode_attr_value( $shortcode, 'user_id' );
			$user_id       = $user_id_param ? intval( $user_id_param ) : $user_id;

			$posts_per_page = wpj_get_email_shortcode_attr_value( $shortcode, 'posts_per_page' );
			$posts_per_page = $posts_per_page ? intval( $posts_per_page ) : 12;

			$args = [
				'post_type'           => 'job',
				'posts_per_page'      => $posts_per_page,
				'post__in'            => get_user_meta( $user_id, 'last_viewed', true ),
				'ignore_sticky_posts' => true,
				'orderby'             => 'post__in'
			];

			$results = get_user_meta( $user_id, 'last_viewed', true ) ? get_posts( $args ) : '';

			ob_start();

			wpj_display_card_email_layout( $results );

			$jobs_list = ob_get_contents();

			ob_end_clean();

			$text = str_replace( $shortcode[0], str_replace( [ "\n", "\r" ], '', $jobs_list ), $text );
		}

		/* JOBS CHECKOUT VIEWED */
		if ( strpos( $text, '{job_checkout_viewed_listings' ) !== false ) {
			preg_match( '~\{job_checkout_viewed_listings([^}]*)\}~', $text, $shortcode );

			$shortcode = array_map( 'trim', $shortcode );

			$user_id_param = wpj_get_email_shortcode_attr_value( $shortcode, 'user_id' );
			$user_id       = $user_id_param ? intval( $user_id_param ) : $user_id;

			$posts_per_page = wpj_get_email_shortcode_attr_value( $shortcode, 'posts_per_page' );
			$posts_per_page = $posts_per_page ? intval( $posts_per_page ) : 12;

			$args = [
				'post_type'           => 'job',
				'posts_per_page'      => $posts_per_page,
				'post__in'            => get_user_meta( $user_id, 'last_checkout_viewed', true ),
				'ignore_sticky_posts' => true,
				'orderby'             => 'post__in'
			];

			$results = get_user_meta( $user_id, 'last_checkout_viewed', true ) ? get_posts( $args ) : '';

			ob_start();

			wpj_display_card_email_layout( $results );

			$jobs_list = ob_get_contents();

			ob_end_clean();

			$text = str_replace( $shortcode[0], str_replace( [ "\n", "\r" ], '', $jobs_list ), $text );

		}

		return apply_filters( 'wpj_email_job_listings_filter', $text, $user_data );
	}
}